/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class EntityThrownTrident
extends EntityProjectile {
    public static final int NETWORK_ID = 73;
    public static final int DATA_SOURCE_ID = 17;
    protected Item trident;
    protected float gravity = 0.04f;
    protected float drag = 0.01f;

    @Override
    public int getNetworkId() {
        return 73;
    }

    @Override
    public float getWidth() {
        return 0.05f;
    }

    @Override
    public float getLength() {
        return 0.5f;
    }

    @Override
    public float getHeight() {
        return 0.05f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        this(chunk, nbt, shootingEntity, false);
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.damage = this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : 8.0;
        this.trident = this.namedTag.contains("Trident") ? NBTIO.getItemHelper(this.namedTag.getCompound("Trident")) : Item.get(0);
        this.closeOnCollide = false;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put("Trident", NBTIO.putItemHelper(this.trident));
    }

    public Item getItem() {
        return this.trident != null ? this.trident.clone() : Item.get(0);
    }

    public void setItem(Item item) {
        this.trident = item.clone();
    }

    public void setCritical() {
        this.setCritical(true);
    }

    public void setCritical(boolean value) {
        this.setDataFlag(0, 13, value);
    }

    public boolean isCritical() {
        return this.getDataFlag(0, 13);
    }

    @Override
    public int getResultDamage() {
        int base = super.getResultDamage();
        if (this.isCritical()) {
            base += ThreadLocalRandom.current().nextInt(base / 2 + 2);
        }
        return base;
    }

    @Override
    protected double getBaseDamage() {
        return 8.0;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        if (this.isCollided && !this.hadCollision) {
            this.getLevel().addLevelSoundEvent(this, 185);
        }
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.onGround || this.hadCollision) {
            this.setCritical(false);
        }
        if (this.age > 1200) {
            this.close();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    public void spawnTo(Player player) {
        AddEntityPacket pk = new AddEntityPacket();
        pk.type = 73;
        pk.entityUniqueId = this.getId();
        pk.entityRuntimeId = this.getId();
        pk.x = (float)this.x;
        pk.y = (float)this.y;
        pk.z = (float)this.z;
        pk.speedX = (float)this.motionX;
        pk.speedY = (float)this.motionY;
        pk.speedZ = (float)this.motionZ;
        pk.yaw = (float)this.yaw;
        pk.pitch = (float)this.pitch;
        pk.metadata = this.dataProperties;
        player.dataPacket(pk);
        super.spawnTo(player);
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity)));
        float damage = this.getResultDamage();
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage);
        entity.attack(ev);
        this.getLevel().addLevelSoundEvent(this, 178);
        this.hadCollision = true;
        this.close();
        Entity newTrident = this.create("ThrownTrident", this, new Object[0]);
        ((EntityThrownTrident)newTrident).setItem(this.trident);
        newTrident.spawnToAll();
    }

    public Entity create(Object type, Position source, Object ... args) {
        BaseFullChunk chunk = source.getLevel().getChunk((int)source.x >> 4, (int)source.z >> 4);
        if (chunk == null) {
            return null;
        }
        CompoundTag nbt = Entity.getDefaultNBT(source.add(0.5, 0.0, 0.5), new Vector3(), new Random().nextFloat() * 360.0f, 0.0f);
        return Entity.createEntity(type.toString(), (FullChunk)chunk, nbt, args);
    }
}

