/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.server;

import cn.nukkit.event.HandlerList;
import cn.nukkit.event.server.ServerEvent;
import cn.nukkit.utils.PlayerDataSerializer;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;

public class PlayerDataSerializeEvent
extends ServerEvent {
    private static HandlerList handlers = new HandlerList();
    private final Optional<String> name;
    private final Optional<UUID> uuid;
    private PlayerDataSerializer serializer;

    public PlayerDataSerializeEvent(String name, PlayerDataSerializer serializer) {
        Preconditions.checkNotNull((Object)name);
        this.serializer = (PlayerDataSerializer)Preconditions.checkNotNull((Object)serializer);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uuid = Optional.ofNullable(uuid);
        this.name = this.uuid.isPresent() ? Optional.empty() : Optional.of(name);
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<UUID> getUuid() {
        return this.uuid;
    }

    public PlayerDataSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(PlayerDataSerializer serializer) {
        this.serializer = (PlayerDataSerializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer");
    }

    public static HandlerList getHandlers() {
        return handlers;
    }
}

