/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;

public class EnchantInventory
extends FakeBlockUIComponent {
    @Since(value="1.3.1.0-PN")
    public static final int ENCHANT_INPUT_ITEM_UI_SLOT = 14;
    @Since(value="1.3.1.0-PN")
    public static final int ENCHANT_REAGENT_UI_SLOT = 15;

    public EnchantInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.ENCHANT_TABLE, 14, position);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 3;
    }

    @Override
    public void onClose(Player who) {
        super.onClose(who);
        who.craftingType = 0;
        Item[] drops = new Item[]{this.getItem(0), this.getItem(1)};
        for (Item drop : drops = who.getInventory().addItem(drops)) {
            if (who.dropItem(drop)) continue;
            this.getHolder().getLevel().dropItem(this.getHolder().add(0.5, 0.5, 0.5), drop);
        }
        this.clear(0);
        this.clear(1);
        who.resetCraftingGridType();
    }

    @Since(value="1.3.1.0-PN")
    public Item getInputSlot() {
        return this.getItem(0);
    }

    @Since(value="1.3.1.0-PN")
    public Item getOutputSlot() {
        return this.getItem(0);
    }

    @Since(value="1.3.1.0-PN")
    public Item getReagentSlot() {
        return this.getItem(1);
    }
}

