/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.item.Item;

public abstract class InventoryAction {
    private long creationTime;
    protected Item sourceItem;
    protected Item targetItem;

    public InventoryAction(Item sourceItem, Item targetItem) {
        this.sourceItem = sourceItem;
        this.targetItem = targetItem;
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Item getSourceItem() {
        return this.sourceItem.clone();
    }

    public Item getTargetItem() {
        return this.targetItem.clone();
    }

    public boolean onPreExecute(Player source) {
        return true;
    }

    public abstract boolean isValid(Player var1);

    public void onAddToTransaction(InventoryTransaction transaction) {
    }

    public abstract boolean execute(Player var1);

    public abstract void onExecuteSuccess(Player var1);

    public abstract void onExecuteFail(Player var1);
}

