/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.block.Block;
import cn.nukkit.item.Item;

public class ItemBlock
extends Item {
    public ItemBlock(Block block) {
        this(block, (Integer)0, 1);
    }

    public ItemBlock(Block block, Integer meta) {
        this(block, meta, 1);
    }

    public ItemBlock(Block block, Integer meta, int count) {
        super(block.getItemId(), meta, count, block.getName());
        this.block = block;
    }

    @Override
    public void setDamage(Integer meta) {
        if (meta != null) {
            this.meta = meta & 0xFFFF;
        } else {
            this.hasMeta = false;
        }
        this.block.setDamage(meta);
    }

    @Override
    public ItemBlock clone() {
        ItemBlock block = (ItemBlock)super.clone();
        block.block = this.block.clone();
        return block;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getMaxStackSize() {
        if (this.getBlock().getId() == 218 || this.getBlock().getId() == 205) {
            return 1;
        }
        return super.getMaxStackSize();
    }
}

