/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFire;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.item.ItemTool;
import cn.nukkit.level.Level;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;

public class ItemFlintSteel
extends ItemTool {
    public ItemFlintSteel() {
        this((Integer)0, 1);
    }

    public ItemFlintSteel(Integer meta) {
        this(meta, 1);
    }

    public ItemFlintSteel(Integer meta, int count) {
        super(259, meta, count, "Flint and Steel");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (block.getId() == 0 && (target.isSolid() || target.getBurnChance() > 0)) {
            if (target.getId() == 49 && level.createPortal(target)) {
                return true;
            }
            BlockFire fire = (BlockFire)Block.get(51);
            fire.x = block.x;
            fire.y = block.y;
            fire.z = block.z;
            fire.level = level;
            if (fire.isBlockTopFacingSurfaceSolid(fire.down()) || fire.canNeighborBurn()) {
                BlockIgniteEvent e = new BlockIgniteEvent(block, null, player, BlockIgniteEvent.BlockIgniteCause.FLINT_AND_STEEL);
                block.getLevel().getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    level.setBlock((Vector3)fire, fire, true);
                    level.addLevelSoundEvent(block, 50);
                    level.scheduleUpdate(fire, fire.tickRate() + ThreadLocalRandom.current().nextInt(10));
                }
                return true;
            }
            if ((player.gamemode & 1) == 0 && this.useOn(block)) {
                if (this.getDamage() >= this.getMaxDurability()) {
                    this.count = 0;
                } else {
                    ++this.meta;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getMaxDurability() {
        return 65;
    }
}

