/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockRail;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityMinecartTNT;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Rail;

public class ItemMinecartTNT
extends Item {
    public ItemMinecartTNT() {
        this((Integer)0, 1);
    }

    public ItemMinecartTNT(Integer meta) {
        this(meta, 1);
    }

    public ItemMinecartTNT(Integer meta, int count) {
        super(407, meta, count, "Minecart with TNT");
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        if (Rail.isRailBlock(target)) {
            EntityMinecartTNT minecart;
            Rail.Orientation type = ((BlockRail)target).getOrientation();
            double adjacent = 0.0;
            if (type.isAscending()) {
                adjacent = 0.5;
            }
            if ((minecart = (EntityMinecartTNT)Entity.createEntity("MinecartTnt", (FullChunk)level.getChunk(target.getFloorX() >> 4, target.getFloorZ() >> 4), new CompoundTag("").putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", target.getX() + 0.5)).add(new DoubleTag("", target.getY() + 0.0625 + adjacent)).add(new DoubleTag("", target.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f))), new Object[0])) == null) {
                return false;
            }
            if (player.isSurvival()) {
                Item item = player.getInventory().getItemInHand();
                item.setCount(item.getCount() - 1);
                player.getInventory().setItemInHand(item);
            }
            minecart.spawnToAll();
            return true;
        }
        return false;
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }
}

