/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import java.util.Arrays;

public class BytePalette {
    private static byte[] BYTE0 = new byte[0];
    private byte[] keys = BYTE0;
    private byte lastIndex = (byte)-128;

    public void add(byte key) {
        this.keys = this.insert(key);
        this.lastIndex = (byte)-128;
    }

    protected void set(byte[] keys) {
        this.keys = keys;
        this.lastIndex = (byte)-128;
    }

    private byte[] insert(byte val) {
        this.lastIndex = (byte)-128;
        if (this.keys.length == 0) {
            return new byte[]{val};
        }
        if (val < this.keys[0]) {
            byte[] s = new byte[this.keys.length + 1];
            System.arraycopy(this.keys, 0, s, 1, this.keys.length);
            s[0] = val;
            return s;
        }
        if (val > this.keys[this.keys.length - 1]) {
            byte[] s = Arrays.copyOf(this.keys, this.keys.length + 1);
            s[this.keys.length] = val;
            return s;
        }
        byte[] s = Arrays.copyOf(this.keys, this.keys.length + 1);
        for (int i = 0; i < s.length; ++i) {
            if (this.keys[i] < val) continue;
            System.arraycopy(this.keys, i, s, i + 1, s.length - i - 1);
            s[i] = val;
            break;
        }
        return s;
    }

    public byte getKey(int index) {
        return this.keys[index];
    }

    public byte getValue(byte key) {
        int index;
        boolean hasLast;
        byte lastTmp = this.lastIndex;
        boolean bl = hasLast = lastTmp != -128;
        if (hasLast) {
            byte lastKey = this.keys[lastTmp];
            if (lastKey == key) {
                return lastTmp;
            }
            index = lastKey > key ? this.binarySearch0(0, lastTmp, key) : this.binarySearch0(lastTmp + 1, this.keys.length, key);
        } else {
            index = this.binarySearch0(0, this.keys.length, key);
        }
        if (index >= this.keys.length || index < 0) {
            this.lastIndex = -128;
            return -128;
        }
        this.lastIndex = (byte)index;
        return this.lastIndex;
    }

    private int binarySearch0(int fromIndex, int toIndex, byte key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte midVal = this.keys[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

