/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import com.google.common.base.Preconditions;

public class NibbleArray
implements Cloneable {
    private final byte[] data;

    public NibbleArray(int length) {
        this.data = new byte[length / 2];
    }

    public NibbleArray(byte[] array) {
        this.data = array;
    }

    public byte get(int index) {
        Preconditions.checkElementIndex((int)index, (int)(this.data.length * 2));
        byte val = this.data[index / 2];
        if ((index & 1) == 0) {
            return (byte)(val & 0xF);
        }
        return (byte)((val & 0xF0) >>> 4);
    }

    public void set(int index, byte value) {
        Preconditions.checkArgument((value >= 0 && value < 16 ? 1 : 0) != 0, (Object)"Nibbles must have a value between 0 and 15.");
        Preconditions.checkElementIndex((int)index, (int)(this.data.length * 2));
        value = (byte)(value & 0xF);
        int half = index / 2;
        byte previous = this.data[half];
        this.data[half] = (index & 1) == 0 ? (byte)(previous & 0xF0 | value) : (byte)(previous & 0xF | value << 4);
    }

    public void fill(byte value) {
        Preconditions.checkArgument((value >= 0 && value < 16 ? 1 : 0) != 0, (Object)"Nibbles must have a value between 0 and 15.");
        value = (byte)(value & 0xF);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(value << 4 | value);
        }
    }

    public void copyFrom(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        Preconditions.checkArgument((bytes.length == this.data.length ? 1 : 0) != 0, (String)"length of provided byte array is %s but expected %s", (int)bytes.length, (int)this.data.length);
        System.arraycopy(bytes, 0, this.data, 0, this.data.length);
    }

    public void copyFrom(NibbleArray array) {
        Preconditions.checkNotNull((Object)array, (Object)"array");
        this.copyFrom(array.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public NibbleArray copy() {
        return new NibbleArray((byte[])this.getData().clone());
    }
}

