/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.generic;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.LevelProvider;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.NumberTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.BatchPacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseFullChunk
implements FullChunk,
ChunkManager {
    protected Map<Long, Entity> entities;
    protected Map<Long, BlockEntity> tiles;
    protected Map<Integer, BlockEntity> tileList;
    protected byte[] biomes;
    protected byte[] blocks;
    protected byte[] data;
    protected byte[] skyLight;
    protected byte[] blockLight;
    protected byte[] heightMap;
    protected List<CompoundTag> NBTtiles;
    protected List<CompoundTag> NBTentities;
    protected Map<Integer, Integer> extraData;
    protected LevelProvider provider;
    protected Class<? extends LevelProvider> providerClass;
    private int x;
    private int z;
    private long hash;
    protected long changes;
    protected boolean isInit;
    protected BatchPacket chunkPacket;

    public BaseFullChunk clone() {
        BaseFullChunk chunk;
        try {
            chunk = (BaseFullChunk)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.biomes != null) {
            chunk.biomes = (byte[])this.biomes.clone();
        }
        if (this.blocks != null) {
            chunk.blocks = (byte[])this.blocks.clone();
        }
        if (this.data != null) {
            chunk.data = (byte[])this.data.clone();
        }
        if (this.skyLight != null) {
            chunk.skyLight = (byte[])this.skyLight.clone();
        }
        if (this.blockLight != null) {
            chunk.blockLight = (byte[])this.blockLight.clone();
        }
        if (this.heightMap != null) {
            chunk.heightMap = (byte[])this.getHeightMapArray().clone();
        }
        return chunk;
    }

    public void setChunkPacket(BatchPacket packet) {
        if (packet != null) {
            packet.trim();
        }
        this.chunkPacket = packet;
    }

    public BatchPacket getChunkPacket() {
        BatchPacket pk = this.chunkPacket;
        if (pk != null) {
            pk.trim();
        }
        return this.chunkPacket;
    }

    @PowerNukkitOnly(value="Needed for level backward compatibility")
    @Since(value="1.3.0.0-PN")
    public void backwardCompatibilityUpdate(Level level) {
    }

    @Override
    public void initChunk() {
        if (this.getProvider() != null && !this.isInit) {
            boolean changed = false;
            if (this.NBTentities != null) {
                this.getProvider().getLevel().timings.syncChunkLoadEntitiesTimer.startTiming();
                for (CompoundTag nbt : this.NBTentities) {
                    if (!nbt.contains("id")) {
                        this.setChanged();
                        continue;
                    }
                    ListTag<? extends Tag> pos = nbt.getList("Pos");
                    if (((Number)((NumberTag)pos.get(0)).getData()).intValue() >> 4 != this.getX() || ((Number)((NumberTag)pos.get(2)).getData()).intValue() >> 4 != this.getZ()) {
                        changed = true;
                        continue;
                    }
                    Entity entity = Entity.createEntity(nbt.getString("id"), (FullChunk)this, nbt, new Object[0]);
                    if (entity == null) continue;
                    changed = true;
                }
                this.getProvider().getLevel().timings.syncChunkLoadEntitiesTimer.stopTiming();
                this.NBTentities = null;
            }
            if (this.NBTtiles != null) {
                this.getProvider().getLevel().timings.syncChunkLoadBlockEntitiesTimer.startTiming();
                for (CompoundTag nbt : this.NBTtiles) {
                    if (nbt == null) continue;
                    if (!nbt.contains("id")) {
                        changed = true;
                        continue;
                    }
                    if (nbt.getInt("x") >> 4 != this.getX() || nbt.getInt("z") >> 4 != this.getZ()) {
                        changed = true;
                        continue;
                    }
                    BlockEntity blockEntity = BlockEntity.createBlockEntity(nbt.getString("id"), this, nbt, new Object[0]);
                    if (blockEntity != null) continue;
                    changed = true;
                }
                this.getProvider().getLevel().timings.syncChunkLoadBlockEntitiesTimer.stopTiming();
                this.NBTtiles = null;
            }
            if (changed) {
                this.setChanged();
            }
            this.isInit = true;
        }
    }

    @Override
    public final long getIndex() {
        return this.hash;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getZ() {
        return this.z;
    }

    @Override
    public void setPosition(int x, int z) {
        this.x = x;
        this.z = z;
        this.hash = Level.chunkHash(x, z);
    }

    @Override
    public final void setX(int x) {
        this.x = x;
        this.hash = Level.chunkHash(x, this.getZ());
    }

    @Override
    public final void setZ(int z) {
        this.z = z;
        this.hash = Level.chunkHash(this.getX(), z);
    }

    @Override
    public LevelProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(LevelProvider provider) {
        this.provider = provider;
    }

    @Override
    public int getBiomeId(int x, int z) {
        return this.biomes[x << 4 | z] & 0xFF;
    }

    @Override
    public void setBiomeId(int x, int z, byte biomeId) {
        this.setChanged();
        this.biomes[x << 4 | z] = biomeId;
    }

    @Override
    public int getHeightMap(int x, int z) {
        return this.heightMap[z << 4 | x] & 0xFF;
    }

    @Override
    public void setHeightMap(int x, int z, int value) {
        this.heightMap[z << 4 | x] = (byte)value;
    }

    @Override
    public void recalculateHeightMap() {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                this.recalculateHeightMapColumn(x, z);
            }
        }
    }

    @Override
    public int recalculateHeightMapColumn(int x, int z) {
        int max;
        int y;
        for (y = max = this.getHighestBlockAt(x, z, false); y >= 0 && Block.lightFilter[this.getBlockIdAt(x, y, z)] <= 1 && !Block.diffusesSkyLight[this.getBlockIdAt(x, y, z)]; --y) {
        }
        this.setHeightMap(x, z, y + 1);
        return y + 1;
    }

    @Override
    public int getBlockExtraData(int x, int y, int z) {
        int index = Level.chunkBlockHash(x, y, z);
        if (this.extraData != null && this.extraData.containsKey(index)) {
            return this.extraData.get(index);
        }
        return 0;
    }

    @Override
    public void setBlockExtraData(int x, int y, int z, int data) {
        if (data == 0) {
            if (this.extraData != null) {
                this.extraData.remove(Level.chunkBlockHash(x, y, z));
            }
        } else {
            if (this.extraData == null) {
                this.extraData = new Int2ObjectOpenHashMap();
            }
            this.extraData.put(Level.chunkBlockHash(x, y, z), data);
        }
        this.setChanged(true);
    }

    @Override
    public void populateSkyLight() {
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                int y;
                int top = this.getHeightMap(x, z) - 1;
                for (y = 255; y > top; --y) {
                    this.setBlockSkyLight(x, y, z, 15);
                }
                int nextLight = 15;
                int nextDecrease = 0;
                for (y = top; y >= 0; --y) {
                    int light = nextLight -= nextDecrease;
                    if (light < 0) {
                        light = 0;
                    }
                    this.setBlockSkyLight(x, y, z, light);
                    if (light == 0) continue;
                    int id = this.getBlockId(x, y, z);
                    if (!Block.transparent[id]) {
                        nextLight = 0;
                        continue;
                    }
                    if (Block.diffusesSkyLight[id]) {
                        ++nextDecrease;
                        continue;
                    }
                    nextDecrease -= Block.lightFilter[id];
                }
            }
        }
    }

    @Override
    public int getHighestBlockAt(int x, int z) {
        return this.getHighestBlockAt(x, z, true);
    }

    @Override
    public int getHighestBlockAt(int x, int z, boolean cache) {
        int h;
        if (cache && (h = this.getHeightMap(x, z)) != 0 && h != 255) {
            return h;
        }
        for (int y = 255; y >= 0; --y) {
            if (this.getBlockId(x, y, z) == 0) continue;
            this.setHeightMap(x, z, y);
            return y;
        }
        return 0;
    }

    @Override
    public void addEntity(Entity entity) {
        if (this.entities == null) {
            this.entities = new Long2ObjectOpenHashMap();
        }
        this.entities.put(entity.getId(), entity);
        if (!(entity instanceof Player) && this.isInit) {
            this.setChanged();
        }
    }

    @Override
    public void removeEntity(Entity entity) {
        if (this.entities != null) {
            this.entities.remove(entity.getId());
            if (!(entity instanceof Player) && this.isInit) {
                this.setChanged();
            }
        }
    }

    @Override
    public void addBlockEntity(BlockEntity blockEntity) {
        if (this.tiles == null) {
            this.tiles = new Long2ObjectOpenHashMap();
            this.tileList = new Int2ObjectOpenHashMap();
        }
        this.tiles.put(blockEntity.getId(), blockEntity);
        int index = (blockEntity.getFloorZ() & 0xF) << 12 | (blockEntity.getFloorX() & 0xF) << 8 | blockEntity.getFloorY() & 0xFF;
        if (this.tileList.containsKey(index) && !this.tileList.get(index).equals(blockEntity)) {
            BlockEntity entity = this.tileList.get(index);
            this.tiles.remove(entity.getId());
            entity.close();
        }
        this.tileList.put(index, blockEntity);
        if (this.isInit) {
            this.setChanged();
        }
    }

    @Override
    public void removeBlockEntity(BlockEntity blockEntity) {
        if (this.tiles != null) {
            this.tiles.remove(blockEntity.getId());
            int index = (blockEntity.getFloorZ() & 0xF) << 12 | (blockEntity.getFloorX() & 0xF) << 8 | blockEntity.getFloorY() & 0xFF;
            this.tileList.remove(index);
            if (this.isInit) {
                this.setChanged();
            }
        }
    }

    @Override
    public Map<Long, Entity> getEntities() {
        return this.entities == null ? Collections.emptyMap() : this.entities;
    }

    @Override
    public Map<Long, BlockEntity> getBlockEntities() {
        return this.tiles == null ? Collections.emptyMap() : this.tiles;
    }

    @Override
    public Map<Integer, Integer> getBlockExtraDataArray() {
        return this.extraData == null ? Collections.emptyMap() : this.extraData;
    }

    @Override
    public BlockEntity getTile(int x, int y, int z) {
        return this.tileList != null ? this.tileList.get(z << 12 | x << 8 | y) : null;
    }

    @Override
    public boolean isLoaded() {
        return this.getProvider() != null && this.getProvider().isChunkLoaded(this.getX(), this.getZ());
    }

    @Override
    public boolean load() throws IOException {
        return this.load(true);
    }

    @Override
    public boolean load(boolean generate) throws IOException {
        return this.getProvider() != null && this.getProvider().getChunk(this.getX(), this.getZ(), true) != null;
    }

    @Override
    public boolean unload() throws Exception {
        return this.unload(true, true);
    }

    @Override
    public boolean unload(boolean save) throws Exception {
        return this.unload(save, true);
    }

    @Override
    public boolean unload(boolean save, boolean safe) {
        LevelProvider provider = this.getProvider();
        if (provider == null) {
            return true;
        }
        if (save && this.changes != 0L) {
            provider.saveChunk(this.getX(), this.getZ());
        }
        if (safe) {
            for (Entity entity : this.getEntities().values()) {
                if (!(entity instanceof Player)) continue;
                return false;
            }
        }
        for (Entity entity : new ArrayList<Entity>(this.getEntities().values())) {
            if (entity instanceof Player) continue;
            entity.close();
        }
        for (BlockEntity blockEntity : new ArrayList<BlockEntity>(this.getBlockEntities().values())) {
            blockEntity.close();
        }
        this.provider = null;
        return true;
    }

    @Override
    public byte[] getBlockIdArray() {
        return this.blocks;
    }

    @Override
    public byte[] getBlockDataArray() {
        return this.data;
    }

    @Override
    public byte[] getBlockSkyLightArray() {
        return this.skyLight;
    }

    @Override
    public byte[] getBlockLightArray() {
        return this.blockLight;
    }

    @Override
    public byte[] getBiomeIdArray() {
        return this.biomes;
    }

    @Override
    public byte[] getHeightMapArray() {
        return this.heightMap;
    }

    public long getChanges() {
        return this.changes;
    }

    @Override
    public boolean hasChanged() {
        return this.changes != 0L;
    }

    @Override
    public void setChanged() {
        ++this.changes;
        this.chunkPacket = null;
    }

    @Override
    public void setChanged(boolean changed) {
        if (changed) {
            this.setChanged();
        } else {
            this.changes = 0L;
        }
    }

    @Override
    public byte[] toFastBinary() {
        return this.toBinary();
    }

    @Override
    public boolean isLightPopulated() {
        return true;
    }

    @Override
    public void setLightPopulated() {
        this.setLightPopulated(true);
    }

    @Override
    public void setLightPopulated(boolean value) {
    }

    @Override
    public int getBlockIdAt(int x, int y, int z) {
        return this.getBlockIdAt(x, y, z, 0);
    }

    @Override
    public int getBlockIdAt(int x, int y, int z, int layer) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            return this.getBlockId(x & 0xF, y, z & 0xF, layer);
        }
        return 0;
    }

    @Override
    public void setBlockFullIdAt(int x, int y, int z, int fullId) {
        this.setFullBlockId(x, y, z, 0, fullId);
    }

    @Override
    public void setBlockFullIdAt(int x, int y, int z, int layer, int fullId) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            this.setFullBlockId(x & 0xF, y, z & 0xF, layer, fullId);
        }
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId) {
        return this.setBlockAtLayer(x, y, z, layer, blockId, 0);
    }

    @Override
    public boolean setBlockAtLayer(int x, int y, int z, int layer, int blockId, int meta) {
        int oldId = this.getBlockId(x, y, z, layer);
        int oldData = this.getBlockData(x, y, z, layer);
        if (oldId != blockId || oldData != meta) {
            this.setBlock(x, y, z, layer, blockId);
            this.setBlockData(x, y, z, layer, meta);
            return true;
        }
        return false;
    }

    @Override
    public void setBlockIdAt(int x, int y, int z, int id) {
        this.setBlockIdAt(x, y, z, 0, id);
    }

    @Override
    public void setBlockIdAt(int x, int y, int z, int layer, int id) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            this.setBlockId(x & 0xF, y, z & 0xF, layer, id);
        }
    }

    @Override
    public void setBlockAt(int x, int y, int z, int id, int data) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            this.setBlock(x & 0xF, y, z & 0xF, id, data);
        }
    }

    @Override
    public int getBlockDataAt(int x, int y, int z) {
        return this.getBlockDataAt(x, y, z, 0);
    }

    @Override
    public int getBlockDataAt(int x, int y, int z, int layer) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            return this.getBlockIdAt(x & 0xF, y, z & 0xF, layer);
        }
        return 0;
    }

    @Override
    public void setBlockDataAt(int x, int y, int z, int data) {
        this.setBlockDataAt(x, y, z, 0, data);
    }

    @Override
    public void setBlockDataAt(int x, int y, int z, int layer, int data) {
        if (x >> 4 == this.getX() && z >> 4 == this.getZ()) {
            this.setBlockData(x & 0xF, y, z & 0xF, layer, data);
        }
    }

    @Override
    public BaseFullChunk getChunk(int chunkX, int chunkZ) {
        if (chunkX == this.getX() && chunkZ == this.getZ()) {
            return this;
        }
        return null;
    }

    @Override
    public void setChunk(int chunkX, int chunkZ) {
        this.setChunk(chunkX, chunkZ, null);
    }

    @Override
    public void setChunk(int chunkX, int chunkZ, BaseFullChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSeed() {
        throw new UnsupportedOperationException("Chunk does not have a seed");
    }

    public boolean compress() {
        BatchPacket pk = this.chunkPacket;
        if (pk != null) {
            pk.trim();
            return true;
        }
        return false;
    }
}

