/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.noise.nukkit.f;

import cn.nukkit.level.generator.noise.nukkit.f.PerlinF;
import cn.nukkit.math.NukkitRandom;

public class SimplexF
extends PerlinF {
    protected static float SQRT_3;
    protected static float SQRT_5;
    protected static float F2;
    protected static float G2;
    protected static float G22;
    protected static float F3;
    protected static float G3;
    protected static float F4;
    protected static float G4;
    protected static float G42;
    protected static float G43;
    protected static float G44;
    public static final int[][] grad3;
    protected final float offsetW;

    public SimplexF(NukkitRandom random, float octaves, float persistence) {
        super(random, octaves, persistence);
        this.offsetW = random.nextFloat() * 256.0f;
        SQRT_3 = (float)Math.sqrt(3.0);
        SQRT_5 = (float)Math.sqrt(5.0);
        F2 = 0.5f * (SQRT_3 - 1.0f);
        G2 = (3.0f - SQRT_3) / 6.0f;
        G22 = G2 * 2.0f - 1.0f;
        F3 = 0.33333334f;
        G3 = 0.16666667f;
        F4 = (SQRT_5 - 1.0f) / 4.0f;
        G4 = (5.0f - SQRT_5) / 20.0f;
        G42 = G4 * 2.0f;
        G43 = G4 * 3.0f;
        G44 = G4 * 4.0f - 1.0f;
    }

    public SimplexF(NukkitRandom random, float octaves, float persistence, float expansion) {
        super(random, octaves, persistence, expansion);
        this.offsetW = random.nextFloat() * 256.0f;
        SQRT_3 = (float)Math.sqrt(3.0);
        SQRT_5 = (float)Math.sqrt(5.0);
        F2 = 0.5f * (SQRT_3 - 1.0f);
        G2 = (3.0f - SQRT_3) / 6.0f;
        G22 = G2 * 2.0f - 1.0f;
        F3 = 0.33333334f;
        G3 = 0.16666667f;
        F4 = (SQRT_5 - 1.0f) / 4.0f;
        G4 = (5.0f - SQRT_5) / 20.0f;
        G42 = G4 * 2.0f;
        G43 = G4 * 3.0f;
        G44 = G4 * 4.0f - 1.0f;
    }

    protected static float dot2D(int[] g, float x, float y) {
        return (float)g[0] * x + (float)g[1] * y;
    }

    protected static float dot3D(int[] g, float x, float y, float z) {
        return (float)g[0] * x + (float)g[1] * y + (float)g[2] * z;
    }

    protected static float dot4D(int[] g, float x, float y, float z, float w) {
        return (float)g[0] * x + (float)g[1] * y + (float)g[2] * z + (float)g[3] * w;
    }

    @Override
    public float getNoise3D(float x, float y, float z) {
        float t3;
        float t2;
        float t1;
        float s = ((x += this.offsetX) + (y += this.offsetY) + (z += this.offsetZ)) * F3;
        int i = (int)(x + s);
        int j = (int)(y + s);
        int k = (int)(z + s);
        float t = (float)(i + j + k) * G3;
        float x0 = x - ((float)i - t);
        float y0 = y - ((float)j - t);
        float z0 = z - ((float)k - t);
        int i1 = 0;
        int j1 = 0;
        int k1 = 0;
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        float x1 = x0 - (float)i1 + G3;
        float y1 = y0 - (float)j1 + G3;
        float z1 = z0 - (float)k1 + G3;
        float x2 = x0 - (float)i2 + 2.0f * G3;
        float y2 = y0 - (float)j2 + 2.0f * G3;
        float z2 = z0 - (float)k2 + 2.0f * G3;
        float x3 = x0 - 1.0f + 3.0f * G3;
        float y3 = y0 - 1.0f + 3.0f * G3;
        float z3 = z0 - 1.0f + 3.0f * G3;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        float n = 0.0f;
        float t0 = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 > 0.0f) {
            int[] gi0 = grad3[this.perm[ii + this.perm[jj + this.perm[kk]]] % 12];
            n += t0 * t0 * t0 * t0 * ((float)gi0[0] * x0 + (float)gi0[1] * y0 + (float)gi0[2] * z0);
        }
        if ((t1 = 0.6f - x1 * x1 - y1 * y1 - z1 * z1) > 0.0f) {
            int[] gi1 = grad3[this.perm[ii + i1 + this.perm[jj + j1 + this.perm[kk + k1]]] % 12];
            n += t1 * t1 * t1 * t1 * ((float)gi1[0] * x1 + (float)gi1[1] * y1 + (float)gi1[2] * z1);
        }
        if ((t2 = 0.6f - x2 * x2 - y2 * y2 - z2 * z2) > 0.0f) {
            int[] gi2 = grad3[this.perm[ii + i2 + this.perm[jj + j2 + this.perm[kk + k2]]] % 12];
            n += t2 * t2 * t2 * t2 * ((float)gi2[0] * x2 + (float)gi2[1] * y2 + (float)gi2[2] * z2);
        }
        if ((t3 = 0.6f - x3 * x3 - y3 * y3 - z3 * z3) > 0.0f) {
            int[] gi3 = grad3[this.perm[ii + 1 + this.perm[jj + 1 + this.perm[kk + 1]]] % 12];
            n += t3 * t3 * t3 * t3 * ((float)gi3[0] * x3 + (float)gi3[1] * y3 + (float)gi3[2] * z3);
        }
        return 32.0f * n;
    }

    @Override
    public float getNoise2D(float x, float y) {
        float t2;
        float t1;
        float s = ((x += this.offsetX) + (y += this.offsetY)) * F2;
        int i = (int)(x + s);
        int j = (int)(y + s);
        float t = (float)(i + j) * G2;
        float x0 = x - ((float)i - t);
        float y0 = y - ((float)j - t);
        int i1 = 0;
        int j1 = 0;
        if (x0 > y0) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        float x1 = x0 - (float)i1 + G2;
        float y1 = y0 - (float)j1 + G2;
        float x2 = x0 + G22;
        float y2 = y0 + G22;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        float n = 0.0f;
        float t0 = 0.5f - x0 * x0 - y0 * y0;
        if (t0 > 0.0f) {
            int[] gi0 = grad3[this.perm[ii + this.perm[jj]] % 12];
            n += t0 * t0 * t0 * t0 * ((float)gi0[0] * x0 + (float)gi0[1] * y0);
        }
        if ((t1 = 0.5f - x1 * x1 - y1 * y1) > 0.0f) {
            int[] gi1 = grad3[this.perm[ii + i1 + this.perm[jj + j1]] % 12];
            n += t1 * t1 * t1 * t1 * ((float)gi1[0] * x1 + (float)gi1[1] * y1);
        }
        if ((t2 = 0.5f - x2 * x2 - y2 * y2) > 0.0f) {
            int[] gi2 = grad3[this.perm[ii + 1 + this.perm[jj + 1]] % 12];
            n += t2 * t2 * t2 * t2 * ((float)gi2[0] * x2 + (float)gi2[1] * y2);
        }
        return 70.0f * n;
    }

    static {
        grad3 = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    }
}

