/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.generator.populator.impl;

import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.generator.object.tree.ObjectTree;
import cn.nukkit.level.generator.populator.type.PopulatorCount;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.NukkitRandom;

public class PopulatorTree
extends PopulatorCount {
    private final int type;
    private ChunkManager level;

    public PopulatorTree() {
        this(0);
    }

    public PopulatorTree(int type) {
        this.type = type;
    }

    @Override
    public void populateCount(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random, FullChunk chunk) {
        int z;
        this.level = level;
        int x = NukkitMath.randomRange(random, chunkX << 4, (chunkX << 4) + 15);
        int y = this.getHighestWorkableBlock(x, z = NukkitMath.randomRange(random, chunkZ << 4, (chunkZ << 4) + 15));
        if (y < 3) {
            return;
        }
        ObjectTree.growTree(this.level, x, y, z, random, this.type);
    }

    private int getHighestWorkableBlock(int x, int z) {
        int b;
        int y;
        for (y = 254; y > 0 && (b = this.level.getBlockIdAt(x, y, z)) != 3 && b != 2; --y) {
            if (b == 0 || b == 78) continue;
            return -1;
        }
        return ++y;
    }
}

