/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.util;

import cn.nukkit.level.util.BitArray;
import cn.nukkit.level.util.BitArrayVersion;
import cn.nukkit.math.MathHelper;
import com.google.common.base.Preconditions;
import java.util.Arrays;

public class PaddedBitArray
implements BitArray {
    private final int[] words;
    private final BitArrayVersion version;
    private final int size;

    PaddedBitArray(BitArrayVersion version, int size, int[] words) {
        this.size = size;
        this.version = version;
        this.words = words;
        int expectedWordsLength = MathHelper.ceil((float)size / (float)version.entriesPerWord);
        if (words.length != expectedWordsLength) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + words.length + " but expected: " + expectedWordsLength);
        }
    }

    @Override
    public void set(int index, int value) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        Preconditions.checkArgument((value >= 0 && value <= this.version.maxEntryValue ? 1 : 0) != 0, (String)"Max value: %s. Received value", (int)this.version.maxEntryValue, (int)value);
        int arrayIndex = index / this.version.entriesPerWord;
        int offset = index % this.version.entriesPerWord * this.version.bits;
        this.words[arrayIndex] = this.words[arrayIndex] & ~(this.version.maxEntryValue << offset) | (value & this.version.maxEntryValue) << offset;
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int arrayIndex = index / this.version.entriesPerWord;
        int offset = index % this.version.entriesPerWord * this.version.bits;
        return this.words[arrayIndex] >>> offset & this.version.maxEntryValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] getWords() {
        return this.words;
    }

    @Override
    public BitArrayVersion getVersion() {
        return this.version;
    }

    @Override
    public BitArray copy() {
        return new PaddedBitArray(this.version, this.size, Arrays.copyOf(this.words, this.words.length));
    }
}

