/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.event.player.PlayerCreationEvent;
import cn.nukkit.event.server.QueryRegenerateEvent;
import cn.nukkit.network.AdvancedSourceInterface;
import cn.nukkit.network.Network;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Utils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.nukkitx.network.raknet.EncapsulatedPacket;
import com.nukkitx.network.raknet.RakNetServer;
import com.nukkitx.network.raknet.RakNetServerListener;
import com.nukkitx.network.raknet.RakNetServerSession;
import com.nukkitx.network.raknet.RakNetSessionListener;
import com.nukkitx.network.raknet.RakNetState;
import com.nukkitx.network.util.DisconnectReason;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RakNetInterface
implements RakNetServerListener,
AdvancedSourceInterface {
    private static final Logger log = LogManager.getLogger(RakNetInterface.class);
    private final Server server;
    private Network network;
    private final RakNetServer raknet;
    private final Map<InetSocketAddress, NukkitRakNetSession> sessions = new ConcurrentHashMap<InetSocketAddress, NukkitRakNetSession>();
    private final Set<ScheduledFuture<?>> tickFutures = new HashSet();
    private final FastThreadLocal<Set<NukkitRakNetSession>> sessionsToTick = new FastThreadLocal<Set<NukkitRakNetSession>>(){

        protected Set<NukkitRakNetSession> initialValue() {
            return Collections.newSetFromMap(new IdentityHashMap());
        }
    };
    private byte[] advertisement;

    public RakNetInterface(Server server) {
        this.server = server;
        InetSocketAddress bindAddress = new InetSocketAddress(Strings.isNullOrEmpty((String)this.server.getIp()) ? "0.0.0.0" : this.server.getIp(), this.server.getPort());
        this.raknet = new RakNetServer(bindAddress, Runtime.getRuntime().availableProcessors());
        this.raknet.setProtocolVersion(10);
        this.raknet.bind().join();
        this.raknet.setListener((RakNetServerListener)this);
        for (EventExecutor executor : this.raknet.getBootstrap().config().group()) {
            this.tickFutures.add(executor.scheduleAtFixedRate(() -> {
                for (NukkitRakNetSession session : (Set)this.sessionsToTick.get()) {
                    try {
                        session.sendOutbound();
                    }
                    catch (Exception e) {
                        log.fatal("Exception while sending packets to {}", (Object)session.player.getName(), (Object)e);
                        session.player.close("Outbound packet error");
                    }
                }
            }, 0L, 50L, TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void setNetwork(Network network) {
        this.network = network;
    }

    @Override
    public boolean process() {
        Iterator<NukkitRakNetSession> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            DataPacket packet;
            NukkitRakNetSession listener = iterator.next();
            Player player = listener.player;
            if (listener.disconnectReason != null) {
                player.close(player.getLeaveMessage(), listener.disconnectReason, false);
                iterator.remove();
                continue;
            }
            while ((packet = (DataPacket)listener.inbound.poll()) != null) {
                listener.player.handleDataPacket(packet);
            }
        }
        return true;
    }

    @Override
    public int getNetworkLatency(Player player) {
        RakNetServerSession session = this.raknet.getSession(player.getSocketAddress());
        return session == null ? -1 : (int)session.getPing();
    }

    @Override
    public void close(Player player) {
        this.close(player, "unknown reason");
    }

    @Override
    public void close(Player player, String reason) {
        RakNetServerSession session = this.raknet.getSession(player.getSocketAddress());
        if (session != null) {
            session.close();
        }
    }

    @Override
    public void shutdown() {
        this.tickFutures.forEach(future -> future.cancel(false));
        this.raknet.close();
    }

    @Override
    public void emergencyShutdown() {
        this.tickFutures.forEach(future -> future.cancel(true));
        this.raknet.close();
    }

    @Override
    public void blockAddress(InetAddress address) {
        this.raknet.block(address);
    }

    @Override
    public void blockAddress(InetAddress address, int timeout) {
        this.raknet.block(address, (long)timeout, TimeUnit.SECONDS);
    }

    @Override
    public void unblockAddress(InetAddress address) {
        this.raknet.unblock(address);
    }

    @Override
    public void sendRawPacket(InetSocketAddress socketAddress, ByteBuf payload) {
        this.raknet.send(socketAddress, payload);
    }

    @Override
    public void setName(String name) {
        QueryRegenerateEvent info = this.server.getQueryInformation();
        String[] names = name.split("!@#");
        String motd = Utils.rtrim(names[0].replace(";", "\\;"), '\\');
        String subMotd = names.length > 1 ? Utils.rtrim(names[1].replace(";", "\\;"), '\\') : "";
        StringJoiner joiner = new StringJoiner(";").add("MCPE").add(motd).add(Integer.toString(ProtocolInfo.CURRENT_PROTOCOL)).add("1.16.200").add(Integer.toString(info.getPlayerCount())).add(Integer.toString(info.getMaxPlayerCount())).add(Long.toString(this.raknet.getGuid())).add(subMotd).add(Server.getGamemodeString(this.server.getDefaultGamemode(), true)).add("1");
        this.advertisement = joiner.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Integer putPacket(Player player, DataPacket packet) {
        return this.putPacket(player, packet, false);
    }

    @Override
    public Integer putPacket(Player player, DataPacket packet, boolean needACK) {
        return this.putPacket(player, packet, needACK, false);
    }

    @Override
    public Integer putPacket(Player player, DataPacket packet, boolean needACK, boolean immediate) {
        NukkitRakNetSession session = this.sessions.get(player.getSocketAddress());
        if (session != null) {
            session.outbound.offer(packet);
        }
        return null;
    }

    public boolean onConnectionRequest(InetSocketAddress inetSocketAddress) {
        return true;
    }

    public byte[] onQuery(InetSocketAddress inetSocketAddress) {
        return this.advertisement;
    }

    public void onSessionCreation(RakNetServerSession session) {
        Player player;
        PlayerCreationEvent ev = new PlayerCreationEvent(this, Player.class, Player.class, null, session.getAddress());
        this.server.getPluginManager().callEvent(ev);
        Class<? extends Player> clazz = ev.getPlayerClass();
        InetSocketAddress socketAddress = ev.getSocketAddress();
        try {
            Constructor<? extends Player> constructor = clazz.getConstructor(SourceInterface.class, Long.class, InetSocketAddress.class);
            player = constructor.newInstance(this, ev.getClientId(), socketAddress);
        }
        catch (ReflectiveOperationException e) {
            try {
                Constructor<? extends Player> constructor = clazz.getConstructor(SourceInterface.class, Long.class, String.class, Integer.TYPE);
                player = constructor.newInstance(this, ev.getClientId(), socketAddress.getHostString(), socketAddress.getPort());
            }
            catch (ReflectiveOperationException e2) {
                e2.addSuppressed(e);
                Server.getInstance().getLogger().logException(e);
                session.disconnect();
                return;
            }
        }
        this.server.addPlayer(session.getAddress(), player);
        NukkitRakNetSession nukkitSession = new NukkitRakNetSession(session, player);
        this.sessions.put(session.getAddress(), nukkitSession);
        ((Set)this.sessionsToTick.get()).add(nukkitSession);
        session.setListener((RakNetSessionListener)nukkitSession);
    }

    public void onUnhandledDatagram(ChannelHandlerContext ctx, DatagramPacket datagramPacket) {
        this.server.handlePacket((InetSocketAddress)datagramPacket.sender(), (ByteBuf)datagramPacket.content());
    }

    private class NukkitRakNetSession
    implements RakNetSessionListener {
        private final RakNetServerSession session;
        private final Player player;
        private final Queue<DataPacket> inbound = PlatformDependent.newSpscQueue();
        private final Queue<DataPacket> outbound = PlatformDependent.newSpscQueue();
        private String disconnectReason = null;

        public void onSessionChangeState(RakNetState rakNetState) {
        }

        public void onDisconnect(DisconnectReason disconnectReason) {
            this.disconnectReason = disconnectReason == DisconnectReason.TIMED_OUT ? "Timed out" : "Disconnected from Server";
            ((Set)RakNetInterface.this.sessionsToTick.get()).remove(this);
        }

        public void onEncapsulated(EncapsulatedPacket packet) {
            ByteBuf buffer = packet.getBuffer();
            short packetId = buffer.readUnsignedByte();
            if (packetId == 254) {
                DataPacket batchPacket = RakNetInterface.this.network.getPacket((byte)-1);
                if (batchPacket == null) {
                    return;
                }
                byte[] packetBuffer = new byte[buffer.readableBytes()];
                buffer.readBytes(packetBuffer);
                batchPacket.setBuffer(packetBuffer);
                batchPacket.decode();
                this.inbound.offer(batchPacket);
            }
        }

        public void onDirect(ByteBuf byteBuf) {
        }

        private void sendOutbound() {
            DataPacket packet;
            ArrayList<DataPacket> toBatch = new ArrayList<DataPacket>();
            while ((packet = this.outbound.poll()) != null) {
                if (packet.pid() == -1) {
                    if (!toBatch.isEmpty()) {
                        this.sendPackets(toBatch.toArray(new DataPacket[0]));
                        toBatch.clear();
                    }
                    this.sendPacket(((BatchPacket)packet).payload);
                    continue;
                }
                toBatch.add(packet);
            }
            if (!toBatch.isEmpty()) {
                this.sendPackets(toBatch.toArray(new DataPacket[0]));
            }
        }

        private void sendPackets(DataPacket[] packets) {
            BinaryStream batched = new BinaryStream();
            for (DataPacket packet : packets) {
                Preconditions.checkArgument((!(packet instanceof BatchPacket) ? 1 : 0) != 0, (Object)"Cannot batch BatchPacket");
                if (!packet.isEncoded) {
                    packet.encode();
                }
                byte[] buf = packet.getBuffer();
                batched.putUnsignedVarInt(buf.length);
                batched.put(buf);
            }
            try {
                this.sendPacket(Network.deflateRaw(batched.getBuffer(), ((RakNetInterface)RakNetInterface.this).network.getServer().networkCompressionLevel));
            }
            catch (IOException e) {
                log.info("Unable to deflate batched packets", (Throwable)e);
            }
        }

        private void sendPacket(byte[] payload) {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.ioBuffer(1 + payload.length);
            byteBuf.writeByte(254);
            byteBuf.writeBytes(payload);
            this.session.send(byteBuf);
        }

        public NukkitRakNetSession(RakNetServerSession session, Player player) {
            this.session = session;
            this.player = player;
        }
    }
}

