/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.block.Block;
import cn.nukkit.math.BlockFace;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class Rail {
    public static boolean isRailBlock(Block block) {
        Objects.requireNonNull(block, "Rail block predicate can not accept null block");
        return Rail.isRailBlock(block.getId());
    }

    public static boolean isRailBlock(int blockId) {
        switch (blockId) {
            case 27: 
            case 28: 
            case 66: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    private Rail() {
    }

    public static enum Orientation {
        STRAIGHT_NORTH_SOUTH(0, State.STRAIGHT, BlockFace.NORTH, BlockFace.SOUTH, null),
        STRAIGHT_EAST_WEST(1, State.STRAIGHT, BlockFace.EAST, BlockFace.WEST, null),
        ASCENDING_EAST(2, State.ASCENDING, BlockFace.EAST, BlockFace.WEST, BlockFace.EAST),
        ASCENDING_WEST(3, State.ASCENDING, BlockFace.EAST, BlockFace.WEST, BlockFace.WEST),
        ASCENDING_NORTH(4, State.ASCENDING, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.NORTH),
        ASCENDING_SOUTH(5, State.ASCENDING, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.SOUTH),
        CURVED_SOUTH_EAST(6, State.CURVED, BlockFace.SOUTH, BlockFace.EAST, null),
        CURVED_SOUTH_WEST(7, State.CURVED, BlockFace.SOUTH, BlockFace.WEST, null),
        CURVED_NORTH_WEST(8, State.CURVED, BlockFace.NORTH, BlockFace.WEST, null),
        CURVED_NORTH_EAST(9, State.CURVED, BlockFace.NORTH, BlockFace.EAST, null);

        private static final Orientation[] META_LOOKUP;
        private final int meta;
        private final State state;
        private final List<BlockFace> connectingDirections;
        private final BlockFace ascendingDirection;

        private Orientation(int meta, State state, BlockFace from, BlockFace to, BlockFace ascendingDirection) {
            this.meta = meta;
            this.state = state;
            this.connectingDirections = Arrays.asList(from, to);
            this.ascendingDirection = ascendingDirection;
        }

        public static Orientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static Orientation straight(BlockFace face) {
            switch (face) {
                case NORTH: 
                case SOUTH: {
                    return STRAIGHT_NORTH_SOUTH;
                }
                case EAST: 
                case WEST: {
                    return STRAIGHT_EAST_WEST;
                }
            }
            return STRAIGHT_NORTH_SOUTH;
        }

        public static Orientation ascending(BlockFace face) {
            switch (face) {
                case NORTH: {
                    return ASCENDING_NORTH;
                }
                case SOUTH: {
                    return ASCENDING_SOUTH;
                }
                case EAST: {
                    return ASCENDING_EAST;
                }
                case WEST: {
                    return ASCENDING_WEST;
                }
            }
            return ASCENDING_EAST;
        }

        public static Orientation curved(BlockFace f1, BlockFace f2) {
            for (Orientation o : new Orientation[]{CURVED_SOUTH_EAST, CURVED_SOUTH_WEST, CURVED_NORTH_WEST, CURVED_NORTH_EAST}) {
                if (!o.connectingDirections.contains((Object)f1) || !o.connectingDirections.contains((Object)f2)) continue;
                return o;
            }
            return CURVED_SOUTH_EAST;
        }

        public static Orientation straightOrCurved(BlockFace f1, BlockFace f2) {
            for (Orientation o : new Orientation[]{STRAIGHT_NORTH_SOUTH, STRAIGHT_EAST_WEST, CURVED_SOUTH_EAST, CURVED_SOUTH_WEST, CURVED_NORTH_WEST, CURVED_NORTH_EAST}) {
                if (!o.connectingDirections.contains((Object)f1) || !o.connectingDirections.contains((Object)f2)) continue;
                return o;
            }
            return STRAIGHT_NORTH_SOUTH;
        }

        public int metadata() {
            return this.meta;
        }

        public boolean hasConnectingDirections(BlockFace ... faces) {
            return Stream.of(faces).allMatch(this.connectingDirections::contains);
        }

        public List<BlockFace> connectingDirections() {
            return this.connectingDirections;
        }

        public Optional<BlockFace> ascendingDirection() {
            return Optional.ofNullable(this.ascendingDirection);
        }

        public boolean isStraight() {
            return this.state == State.STRAIGHT;
        }

        public boolean isAscending() {
            return this.state == State.ASCENDING;
        }

        public boolean isCurved() {
            return this.state == State.CURVED;
        }

        static {
            META_LOOKUP = new Orientation[Orientation.values().length];
            Orientation[] orientationArray = Orientation.values();
            int n = orientationArray.length;
            for (int i = 0; i < n; ++i) {
                Orientation o;
                Orientation.META_LOOKUP[o.meta] = o = orientationArray[i];
            }
        }

        public static enum State {
            STRAIGHT,
            ASCENDING,
            CURVED;

        }
    }
}

