/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import cn.nukkit.Server;
import co.aikar.timings.Timing;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsHistory;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class TimingsManager {
    static final Map<TimingIdentifier, Timing> TIMING_MAP = Collections.synchronizedMap(new HashMap(256, 0.5f));
    static final Queue<Timing> TIMINGS = new ArrayDeque<Timing>();
    static final ArrayDeque<TimingsHistory.MinuteReport> MINUTE_REPORTS = new ArrayDeque();
    static Queue<TimingsHistory> HISTORY = new BoundedQueue<TimingsHistory>(12);
    static Timing CURRENT;
    static long timingStart;
    static long historyStart;
    static boolean needsFullReset;
    static boolean needsRecheckEnabled;

    static void reset() {
        needsFullReset = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tick() {
        if (Timings.isTimingsEnabled()) {
            boolean violated = Timings.fullServerTickTimer.isViolated();
            Queue<Timing> queue = TIMINGS;
            synchronized (queue) {
                for (Timing timing : TIMINGS) {
                    if (timing.isSpecial()) continue;
                    timing.tick(violated);
                }
            }
            TimingsHistory.playerTicks += (long)Server.getInstance().getOnlinePlayers().size();
            ++TimingsHistory.timedTicks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recheckEnabled() {
        Map<TimingIdentifier, Timing> map = TIMING_MAP;
        synchronized (map) {
            TIMING_MAP.values().forEach(Timing::checkEnabled);
        }
        needsRecheckEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTimings() {
        if (needsFullReset) {
            Map<TimingIdentifier, Timing> map = TIMING_MAP;
            synchronized (map) {
                for (Timing timing : TIMING_MAP.values()) {
                    timing.reset(true);
                }
            }
            HISTORY.clear();
            needsFullReset = false;
            needsRecheckEnabled = false;
            timingStart = System.currentTimeMillis();
        } else {
            for (Timing timing : TIMINGS) {
                timing.reset(false);
            }
        }
        TIMINGS.clear();
        MINUTE_REPORTS.clear();
        TimingsHistory.resetTicks(true);
        historyStart = System.currentTimeMillis();
    }

    public static Timing getTiming(String name) {
        return TimingsManager.getTiming(null, name, null);
    }

    static Timing getTiming(String group, String name, Timing groupTiming) {
        TimingIdentifier id = new TimingIdentifier(group, name, groupTiming);
        return TIMING_MAP.computeIfAbsent(id, k -> new Timing(id));
    }

    static {
        timingStart = 0L;
        historyStart = 0L;
        needsFullReset = false;
        needsRecheckEnabled = false;
    }

    static final class BoundedQueue<E>
    extends LinkedList<E> {
        final int maxSize;

        BoundedQueue(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize must be greater than zero");
            }
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(E e) {
            if (this.size() == this.maxSize) {
                this.remove();
            }
            return super.add(e);
        }
    }
}

