/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit;

import cn.nukkit.Achievement;
import cn.nukkit.AdventureSettings;
import cn.nukkit.IPlayer;
import cn.nukkit.PlayerFood;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDragonEgg;
import cn.nukkit.block.BlockEnderChest;
import cn.nukkit.block.BlockLectern;
import cn.nukkit.block.BlockNoteblock;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityItemFrame;
import cn.nukkit.blockentity.BlockEntityLectern;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandDataVersions;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHuman;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.data.EntityData;
import cn.nukkit.entity.data.EntityMetadata;
import cn.nukkit.entity.data.IntPositionEntityData;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.entity.item.EntityFishingHook;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.entity.item.EntityXPOrb;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.event.block.ItemFrameDropItemEvent;
import cn.nukkit.event.block.LecternPageChangeEvent;
import cn.nukkit.event.block.WaterFrostEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityPortalEnterEvent;
import cn.nukkit.event.entity.ProjectileLaunchEvent;
import cn.nukkit.event.inventory.InventoryCloseEvent;
import cn.nukkit.event.inventory.InventoryPickupArrowEvent;
import cn.nukkit.event.inventory.InventoryPickupItemEvent;
import cn.nukkit.event.inventory.InventoryPickupTridentEvent;
import cn.nukkit.event.player.PlayerAchievementAwardedEvent;
import cn.nukkit.event.player.PlayerAnimationEvent;
import cn.nukkit.event.player.PlayerAsyncPreLoginEvent;
import cn.nukkit.event.player.PlayerBedEnterEvent;
import cn.nukkit.event.player.PlayerBedLeaveEvent;
import cn.nukkit.event.player.PlayerBlockPickEvent;
import cn.nukkit.event.player.PlayerChangeSkinEvent;
import cn.nukkit.event.player.PlayerChatEvent;
import cn.nukkit.event.player.PlayerChunkRequestEvent;
import cn.nukkit.event.player.PlayerCommandPreprocessEvent;
import cn.nukkit.event.player.PlayerDeathEvent;
import cn.nukkit.event.player.PlayerEditBookEvent;
import cn.nukkit.event.player.PlayerFormRespondedEvent;
import cn.nukkit.event.player.PlayerGameModeChangeEvent;
import cn.nukkit.event.player.PlayerInteractEntityEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.event.player.PlayerInvalidMoveEvent;
import cn.nukkit.event.player.PlayerJoinEvent;
import cn.nukkit.event.player.PlayerJumpEvent;
import cn.nukkit.event.player.PlayerKickEvent;
import cn.nukkit.event.player.PlayerLocallyInitializedEvent;
import cn.nukkit.event.player.PlayerLoginEvent;
import cn.nukkit.event.player.PlayerMapInfoRequestEvent;
import cn.nukkit.event.player.PlayerMouseOverEntityEvent;
import cn.nukkit.event.player.PlayerMoveEvent;
import cn.nukkit.event.player.PlayerPreLoginEvent;
import cn.nukkit.event.player.PlayerQuitEvent;
import cn.nukkit.event.player.PlayerRespawnEvent;
import cn.nukkit.event.player.PlayerServerSettingsRequestEvent;
import cn.nukkit.event.player.PlayerSettingsRespondedEvent;
import cn.nukkit.event.player.PlayerTeleportEvent;
import cn.nukkit.event.player.PlayerToggleFlightEvent;
import cn.nukkit.event.player.PlayerToggleGlideEvent;
import cn.nukkit.event.player.PlayerToggleSneakEvent;
import cn.nukkit.event.player.PlayerToggleSprintEvent;
import cn.nukkit.event.player.PlayerToggleSwimEvent;
import cn.nukkit.event.server.DataPacketReceiveEvent;
import cn.nukkit.event.server.DataPacketSendEvent;
import cn.nukkit.form.window.FormWindow;
import cn.nukkit.form.window.FormWindowCustom;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.BigCraftingGrid;
import cn.nukkit.inventory.CraftingGrid;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.PlayerCursorInventory;
import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.transaction.CraftingTransaction;
import cn.nukkit.inventory.transaction.EnchantTransaction;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.data.ReleaseItemData;
import cn.nukkit.inventory.transaction.data.UseItemData;
import cn.nukkit.inventory.transaction.data.UseItemOnEntityData;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.item.ItemArrow;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemBookAndQuill;
import cn.nukkit.item.ItemBookWritten;
import cn.nukkit.item.ItemMap;
import cn.nukkit.item.ItemTool;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.lang.TextContainer;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.ChunkLoader;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.particle.PunchBlockParticle;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector3;
import cn.nukkit.metadata.MetadataValue;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.Network;
import cn.nukkit.network.SourceInterface;
import cn.nukkit.network.protocol.AdventureSettingsPacket;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.AvailableCommandsPacket;
import cn.nukkit.network.protocol.AvailableEntityIdentifiersPacket;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.BiomeDefinitionListPacket;
import cn.nukkit.network.protocol.BlockEntityDataPacket;
import cn.nukkit.network.protocol.BlockPickRequestPacket;
import cn.nukkit.network.protocol.BookEditPacket;
import cn.nukkit.network.protocol.ChangeDimensionPacket;
import cn.nukkit.network.protocol.ChunkRadiusUpdatedPacket;
import cn.nukkit.network.protocol.CommandRequestPacket;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.network.protocol.CraftingEventPacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.DisconnectPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.network.protocol.GameRulesChangedPacket;
import cn.nukkit.network.protocol.InteractPacket;
import cn.nukkit.network.protocol.InventoryTransactionPacket;
import cn.nukkit.network.protocol.ItemFrameDropItemPacket;
import cn.nukkit.network.protocol.LecternUpdatePacket;
import cn.nukkit.network.protocol.LevelChunkPacket;
import cn.nukkit.network.protocol.LevelEventPacket;
import cn.nukkit.network.protocol.LevelSoundEventPacket;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.network.protocol.MapInfoRequestPacket;
import cn.nukkit.network.protocol.MobEquipmentPacket;
import cn.nukkit.network.protocol.ModalFormRequestPacket;
import cn.nukkit.network.protocol.ModalFormResponsePacket;
import cn.nukkit.network.protocol.MovePlayerPacket;
import cn.nukkit.network.protocol.NetworkChunkPublisherUpdatePacket;
import cn.nukkit.network.protocol.PacketViolationWarningPacket;
import cn.nukkit.network.protocol.PlayStatusPacket;
import cn.nukkit.network.protocol.PlayerActionPacket;
import cn.nukkit.network.protocol.PlayerHotbarPacket;
import cn.nukkit.network.protocol.PlayerInputPacket;
import cn.nukkit.network.protocol.PlayerSkinPacket;
import cn.nukkit.network.protocol.PositionTrackingDBClientRequestPacket;
import cn.nukkit.network.protocol.PositionTrackingDBServerBroadcastPacket;
import cn.nukkit.network.protocol.ProtocolInfo;
import cn.nukkit.network.protocol.RequestChunkRadiusPacket;
import cn.nukkit.network.protocol.ResourcePackChunkDataPacket;
import cn.nukkit.network.protocol.ResourcePackChunkRequestPacket;
import cn.nukkit.network.protocol.ResourcePackClientResponsePacket;
import cn.nukkit.network.protocol.ResourcePackDataInfoPacket;
import cn.nukkit.network.protocol.ResourcePackStackPacket;
import cn.nukkit.network.protocol.ResourcePacksInfoPacket;
import cn.nukkit.network.protocol.RespawnPacket;
import cn.nukkit.network.protocol.ServerSettingsResponsePacket;
import cn.nukkit.network.protocol.SetCommandsEnabledPacket;
import cn.nukkit.network.protocol.SetEntityMotionPacket;
import cn.nukkit.network.protocol.SetPlayerGameTypePacket;
import cn.nukkit.network.protocol.SetSpawnPositionPacket;
import cn.nukkit.network.protocol.SetTimePacket;
import cn.nukkit.network.protocol.SetTitlePacket;
import cn.nukkit.network.protocol.ShowProfilePacket;
import cn.nukkit.network.protocol.StartGamePacket;
import cn.nukkit.network.protocol.TakeItemEntityPacket;
import cn.nukkit.network.protocol.TextPacket;
import cn.nukkit.network.protocol.TransferPacket;
import cn.nukkit.network.protocol.UpdateAttributesPacket;
import cn.nukkit.network.protocol.types.NetworkInventoryAction;
import cn.nukkit.permission.PermissibleBase;
import cn.nukkit.permission.Permission;
import cn.nukkit.permission.PermissionAttachment;
import cn.nukkit.permission.PermissionAttachmentInfo;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.positiontracking.PositionTrackingService;
import cn.nukkit.scheduler.AsyncTask;
import cn.nukkit.scheduler.TaskHandler;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.BlockIterator;
import cn.nukkit.utils.ClientChainData;
import cn.nukkit.utils.DummyBossBar;
import cn.nukkit.utils.LoginChainData;
import cn.nukkit.utils.TextFormat;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.util.internal.EmptyArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class Player
extends EntityHuman
implements CommandSender,
InventoryHolder,
ChunkLoader,
IPlayer {
    private static final Logger log = LogManager.getLogger(Player.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final Player[] EMPTY_ARRAY = new Player[0];
    private static final int NO_SHIELD_DELAY = 10;
    public static final int SURVIVAL = 0;
    public static final int CREATIVE = 1;
    public static final int ADVENTURE = 2;
    public static final int SPECTATOR = 3;
    public static final int VIEW = 3;
    public static final int SURVIVAL_SLOTS = 36;
    public static final int CREATIVE_SLOTS = 112;
    public static final int CRAFTING_SMALL = 0;
    public static final int CRAFTING_BIG = 1;
    public static final int CRAFTING_ANVIL = 2;
    public static final int CRAFTING_ENCHANT = 3;
    public static final int CRAFTING_BEACON = 4;
    @PowerNukkitOnly
    public static final int CRAFTING_GRINDSTONE = 1000;
    @PowerNukkitOnly
    public static final int CRAFTING_STONECUTTER = 1001;
    @PowerNukkitOnly
    public static final int CRAFTING_CARTOGRAPHY = 1002;
    public static final float DEFAULT_SPEED = 0.1f;
    public static final float MAXIMUM_SPEED = 0.5f;
    public static final int PERMISSION_CUSTOM = 3;
    public static final int PERMISSION_OPERATOR = 2;
    public static final int PERMISSION_MEMBER = 1;
    public static final int PERMISSION_VISITOR = 0;
    public static final int ANVIL_WINDOW_ID = 2;
    public static final int ENCHANT_WINDOW_ID = 3;
    public static final int BEACON_WINDOW_ID = 4;
    public static final int GRINDSTONE_WINDOW_ID = 2;
    protected final SourceInterface interfaz;
    public boolean playedBefore;
    public boolean spawned = false;
    public boolean loggedIn = false;
    public boolean locallyInitialized = false;
    public int gamemode;
    public long lastBreak;
    private BlockVector3 lastBreakPosition = new BlockVector3();
    protected int windowCnt = 4;
    protected final BiMap<Inventory, Integer> windows = HashBiMap.create();
    protected final BiMap<Integer, Inventory> windowIndex = this.windows.inverse();
    protected final Set<Integer> permanentWindows = new IntOpenHashSet();
    private boolean inventoryOpen;
    protected int messageCounter = 2;
    private String clientSecret;
    public Vector3 speed = null;
    public final HashSet<String> achievements = new HashSet();
    public int craftingType = 0;
    protected PlayerUIInventory playerUIInventory;
    protected CraftingGrid craftingGrid;
    protected CraftingTransaction craftingTransaction;
    @Since(value="1.3.1.0-PN")
    protected EnchantTransaction enchantTransaction;
    public long creationTime = 0L;
    protected long randomClientId;
    protected Vector3 forceMovement = null;
    protected Vector3 teleportPosition = null;
    protected boolean connected = true;
    protected final InetSocketAddress socketAddress;
    protected boolean removeFormat = true;
    protected String username;
    protected String iusername;
    protected String displayName;
    protected int startAction = -1;
    protected Vector3 sleeping = null;
    protected Long clientID = null;
    private int loaderId;
    protected float stepHeight = 0.6f;
    public final Map<Long, Boolean> usedChunks = new Long2ObjectOpenHashMap<Boolean>();
    protected int chunkLoadCount = 0;
    protected final Long2ObjectLinkedOpenHashMap<Boolean> loadQueue = new Long2ObjectLinkedOpenHashMap();
    protected int nextChunkOrderRun = 1;
    protected final Map<UUID, Player> hiddenPlayers = new HashMap<UUID, Player>();
    protected Vector3 newPosition = null;
    protected int chunkRadius;
    protected int viewDistance;
    protected final int chunksPerTick;
    protected final int spawnThreshold;
    protected Position spawnPosition = null;
    protected int inAirTicks = 0;
    protected int startAirTicks = 5;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    private int noShieldTicks;
    protected AdventureSettings adventureSettings;
    protected boolean checkMovement = true;
    private final Queue<DataPacket> packetQueue = new ConcurrentLinkedDeque<DataPacket>();
    private PermissibleBase perm = null;
    private int exp = 0;
    private int expLevel = 0;
    protected PlayerFood foodData = null;
    private Entity killer = null;
    private final AtomicReference<Locale> locale = new AtomicReference<Object>(null);
    private int hash;
    private String buttonText = "Button";
    protected boolean enableClientCommand = true;
    private BlockEnderChest viewingEnderChest = null;
    protected int lastEnderPearl = 20;
    protected int lastChorusFruitTeleport = 20;
    private LoginChainData loginChainData;
    public Block breakingBlock = null;
    public int pickedXPOrb = 0;
    protected int formWindowCount = 0;
    protected Map<Integer, FormWindow> formWindows = new Int2ObjectOpenHashMap<FormWindow>();
    protected Map<Integer, FormWindow> serverSettings = new Int2ObjectOpenHashMap<FormWindow>();
    protected Map<Long, DummyBossBar> dummyBossBars = new Long2ObjectLinkedOpenHashMap<DummyBossBar>();
    private AsyncTask preLoginEventTask = null;
    protected boolean shouldLogin = false;
    public EntityFishingHook fishing = null;
    public long lastSkinChange;
    protected double lastRightClickTime = 0.0;
    protected Vector3 lastRightClickPos = null;
    protected int lastPlayerdLevelUpSoundTime = 0;
    private TaskHandler delayedPosTrackingUpdate;
    private float soulSpeedMultiplier = 1.0f;
    private boolean wasInSoulSandCompatible;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    private int timeSinceRest;
    private boolean foodEnabled = true;

    public float getSoulSpeedMultiplier() {
        return this.soulSpeedMultiplier;
    }

    public int getStartActionTick() {
        return this.startAction;
    }

    public void startAction() {
        this.startAction = this.server.getTick();
    }

    public void stopAction() {
        this.startAction = -1;
    }

    public int getLastEnderPearlThrowingTick() {
        return this.lastEnderPearl;
    }

    public void onThrowEnderPearl() {
        this.lastEnderPearl = this.server.getTick();
    }

    public int getLastChorusFruitTeleport() {
        return this.lastChorusFruitTeleport;
    }

    public void onChorusFruitTeleport() {
        this.lastChorusFruitTeleport = this.server.getTick();
    }

    public BlockEnderChest getViewingEnderChest() {
        return this.viewingEnderChest;
    }

    public void setViewingEnderChest(BlockEnderChest chest) {
        if (chest == null && this.viewingEnderChest != null) {
            this.viewingEnderChest.getViewers().remove(this);
        } else if (chest != null) {
            chest.getViewers().add(this);
        }
        this.viewingEnderChest = chest;
    }

    public TranslationContainer getLeaveMessage() {
        return new TranslationContainer((Object)((Object)TextFormat.YELLOW) + "%multiplayer.player.left", this.getDisplayName());
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @Deprecated
    public Long getClientId() {
        return this.randomClientId;
    }

    @Override
    public boolean isBanned() {
        return this.server.getNameBans().isBanned(this.getName());
    }

    @Override
    public void setBanned(boolean value) {
        if (value) {
            this.server.getNameBans().addBan(this.getName(), null, null, null);
            this.kick(PlayerKickEvent.Reason.NAME_BANNED, "Banned by admin");
        } else {
            this.server.getNameBans().remove(this.getName());
        }
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.isWhitelisted(this.getName().toLowerCase());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.addWhitelist(this.getName().toLowerCase());
        } else {
            this.server.removeWhitelist(this.getName().toLowerCase());
        }
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    @Override
    public Long getFirstPlayed() {
        return this.namedTag != null ? Long.valueOf(this.namedTag.getLong("firstPlayed")) : null;
    }

    @Override
    public Long getLastPlayed() {
        return this.namedTag != null ? Long.valueOf(this.namedTag.getLong("lastPlayed")) : null;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.playedBefore;
    }

    public AdventureSettings getAdventureSettings() {
        return this.adventureSettings;
    }

    public void setAdventureSettings(AdventureSettings adventureSettings) {
        this.adventureSettings = adventureSettings.clone(this);
        this.adventureSettings.update();
    }

    public void resetInAirTicks() {
        this.inAirTicks = 0;
    }

    @Deprecated
    public void setAllowFlight(boolean value) {
        this.getAdventureSettings().set(AdventureSettings.Type.ALLOW_FLIGHT, value);
        this.getAdventureSettings().update();
    }

    @Deprecated
    public boolean getAllowFlight() {
        return this.getAdventureSettings().get(AdventureSettings.Type.ALLOW_FLIGHT);
    }

    public void setAllowModifyWorld(boolean value) {
        this.getAdventureSettings().set(AdventureSettings.Type.WORLD_IMMUTABLE, !value);
        this.getAdventureSettings().set(AdventureSettings.Type.BUILD_AND_MINE, value);
        this.getAdventureSettings().set(AdventureSettings.Type.WORLD_BUILDER, value);
        this.getAdventureSettings().update();
    }

    public void setAllowInteract(boolean value) {
        this.setAllowInteract(value, value);
    }

    public void setAllowInteract(boolean value, boolean containers) {
        this.getAdventureSettings().set(AdventureSettings.Type.WORLD_IMMUTABLE, !value);
        this.getAdventureSettings().set(AdventureSettings.Type.DOORS_AND_SWITCHED, value);
        this.getAdventureSettings().set(AdventureSettings.Type.OPEN_CONTAINERS, containers);
        this.getAdventureSettings().update();
    }

    @Deprecated
    public void setAutoJump(boolean value) {
        this.getAdventureSettings().set(AdventureSettings.Type.AUTO_JUMP, value);
        this.getAdventureSettings().update();
    }

    @Deprecated
    public boolean hasAutoJump() {
        return this.getAdventureSettings().get(AdventureSettings.Type.AUTO_JUMP);
    }

    @Override
    public void spawnTo(Player player) {
        if (this.spawned && player.spawned && this.isAlive() && player.getLevel() == this.level && player.canSee(this) && !this.isSpectator()) {
            super.spawnTo(player);
        }
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public boolean getRemoveFormat() {
        return this.removeFormat;
    }

    public void setRemoveFormat() {
        this.setRemoveFormat(true);
    }

    public void setRemoveFormat(boolean remove) {
        this.removeFormat = remove;
    }

    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getUniqueId());
    }

    public void hidePlayer(Player player) {
        if (this == player) {
            return;
        }
        this.hiddenPlayers.put(player.getUniqueId(), player);
        player.despawnFrom(this);
    }

    public void showPlayer(Player player) {
        if (this == player) {
            return;
        }
        this.hiddenPlayers.remove(player.getUniqueId());
        if (player.isOnline()) {
            player.spawnTo(this);
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public void resetFallDistance() {
        super.resetFallDistance();
        if (this.inAirTicks != 0) {
            this.startAirTicks = 5;
        }
        this.inAirTicks = 0;
        this.highestPosition = this.y;
    }

    @Override
    public boolean isOnline() {
        return this.connected && this.loggedIn;
    }

    @Override
    public boolean isOp() {
        return this.server.isOp(this.getName());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.addOp(this.getName());
        } else {
            this.server.removeOp(this.getName());
        }
        this.recalculatePermissions();
        this.getAdventureSettings().update();
        this.sendCommandData();
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission permission) {
        return this.perm.isPermissionSet(permission);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm != null && this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.perm.hasPermission(permission);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.addAttachment(plugin, null);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name) {
        return this.addAttachment(plugin, name, null);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, Boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.user", this);
        this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.admin", this);
        if (this.perm == null) {
            return;
        }
        this.perm.recalculatePermissions();
        if (this.hasPermission("nukkit.broadcast.user")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.user", this);
        }
        if (this.hasPermission("nukkit.broadcast.admin")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.admin", this);
        }
        if (this.isEnableClientCommand() && this.spawned) {
            this.sendCommandData();
        }
    }

    public boolean isEnableClientCommand() {
        return this.enableClientCommand;
    }

    public void setEnableClientCommand(boolean enable) {
        this.enableClientCommand = enable;
        SetCommandsEnabledPacket pk = new SetCommandsEnabledPacket();
        pk.enabled = enable;
        this.dataPacket(pk);
        if (enable) {
            this.sendCommandData();
        }
    }

    public void sendCommandData() {
        if (!this.spawned) {
            return;
        }
        AvailableCommandsPacket pk = new AvailableCommandsPacket();
        HashMap<String, CommandDataVersions> data = new HashMap<String, CommandDataVersions>();
        int count = 0;
        for (Command command : this.server.getCommandMap().getCommands().values()) {
            if (!command.testPermissionSilent(this)) continue;
            ++count;
            CommandDataVersions data0 = command.generateCustomCommandData(this);
            data.put(command.getName(), data0);
        }
        if (count > 0) {
            pk.commands = data;
            this.dataPacket(pk);
        }
    }

    @Override
    public Map<String, PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    private static InetSocketAddress uncheckedNewInetSocketAddress(String ip, int port) {
        try {
            return new InetSocketAddress(InetAddress.getByName(ip), port);
        }
        catch (UnknownHostException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public Player(SourceInterface interfaz, Long clientID, String ip, int port) {
        this(interfaz, clientID, Player.uncheckedNewInetSocketAddress(ip, port));
    }

    @PowerNukkitOnly
    public Player(SourceInterface interfaz, Long clientID, InetSocketAddress socketAddress) {
        super(null, new CompoundTag());
        this.interfaz = interfaz;
        this.perm = new PermissibleBase(this);
        this.server = Server.getInstance();
        this.lastBreak = -1L;
        this.socketAddress = socketAddress;
        this.clientID = clientID;
        this.loaderId = Level.generateChunkLoaderId(this);
        this.chunksPerTick = this.server.getConfig("chunk-sending.per-tick", 4);
        this.spawnThreshold = this.server.getConfig("chunk-sending.spawn-threshold", 56);
        this.spawnPosition = null;
        this.gamemode = this.server.getGamemode();
        this.setLevel(this.server.getDefaultLevel());
        this.chunkRadius = this.viewDistance = this.server.getViewDistance();
        this.boundingBox = new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.lastSkinChange = -1L;
        this.uuid = null;
        this.rawUUID = null;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.addDefaultWindows();
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    public void removeAchievement(String achievementId) {
        this.achievements.remove(achievementId);
    }

    public boolean hasAchievement(String achievementId) {
        return this.achievements.contains(achievementId);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        if (this.spawned) {
            this.server.updatePlayerListData(this.getUniqueId(), this.getId(), this.getDisplayName(), this.getSkin(), this.getLoginChainData().getXUID());
        }
    }

    @Override
    public void setSkin(Skin skin) {
        super.setSkin(skin);
        if (this.spawned) {
            this.server.updatePlayerListData(this.getUniqueId(), this.getId(), this.getDisplayName(), skin, this.getLoginChainData().getXUID());
        }
    }

    public String getAddress() {
        return this.socketAddress.getAddress().getHostAddress();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public Position getNextPosition() {
        return this.newPosition != null ? new Position(this.newPosition.x, this.newPosition.y, this.newPosition.z, this.level) : this.getPosition();
    }

    public boolean isSleeping() {
        return this.sleeping != null;
    }

    public int getInAirTicks() {
        return this.inAirTicks;
    }

    public boolean isUsingItem() {
        return this.getDataFlag(0, 4) && this.startAction > -1;
    }

    public void setUsingItem(boolean value) {
        this.startAction = value ? this.server.getTick() : -1;
        this.setDataFlag(0, 4, value);
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String text) {
        this.buttonText = text;
        this.setDataProperty(new StringEntityData(99, this.buttonText));
    }

    public void unloadChunk(int x, int z) {
        this.unloadChunk(x, z, null);
    }

    public void unloadChunk(int x, int z, Level level) {
        level = level == null ? this.level : level;
        long index = Level.chunkHash(x, z);
        if (this.usedChunks.containsKey(index)) {
            for (Entity entity : level.getChunkEntities(x, z).values()) {
                if (entity == this) continue;
                entity.despawnFrom(this);
            }
            this.usedChunks.remove(index);
        }
        level.unregisterChunkLoader(this, x, z);
        this.loadQueue.remove(index);
    }

    public Position getSpawn() {
        if (this.spawnPosition != null && this.spawnPosition.getLevel() != null) {
            return this.spawnPosition;
        }
        return this.server.getDefaultLevel().getSafeSpawn();
    }

    public void sendChunk(int x, int z, DataPacket packet) {
        if (!this.connected) {
            return;
        }
        this.usedChunks.put(Level.chunkHash(x, z), Boolean.TRUE);
        ++this.chunkLoadCount;
        this.dataPacket(packet);
        if (this.spawned) {
            for (Entity entity : this.level.getChunkEntities(x, z).values()) {
                if (this == entity || entity.closed || !entity.isAlive()) continue;
                entity.spawnTo(this);
            }
        }
    }

    public void sendChunk(int x, int z, int subChunkCount, byte[] payload) {
        if (!this.connected) {
            return;
        }
        this.usedChunks.put(Level.chunkHash(x, z), true);
        ++this.chunkLoadCount;
        LevelChunkPacket pk = new LevelChunkPacket();
        pk.chunkX = x;
        pk.chunkZ = z;
        pk.subChunkCount = subChunkCount;
        pk.data = payload;
        this.batchDataPacket(pk);
        if (this.spawned) {
            for (Entity entity : this.level.getChunkEntities(x, z).values()) {
                if (this == entity || entity.closed || !entity.isAlive()) continue;
                entity.spawnTo(this);
            }
        }
    }

    protected void sendNextChunk() {
        if (!this.connected) {
            return;
        }
        Timings.playerChunkSendTimer.startTiming();
        if (!this.loadQueue.isEmpty()) {
            int count = 0;
            ObjectIterator iter = this.loadQueue.long2ObjectEntrySet().fastIterator();
            while (iter.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iter.next();
                long index = entry.getLongKey();
                if (count >= this.chunksPerTick) break;
                int chunkX = Level.getHashX(index);
                int chunkZ = Level.getHashZ(index);
                ++count;
                this.usedChunks.put(index, false);
                this.level.registerChunkLoader(this, chunkX, chunkZ, false);
                if (!this.level.populateChunk(chunkX, chunkZ)) {
                    if (!this.spawned || this.teleportPosition != null) break;
                    continue;
                }
                iter.remove();
                PlayerChunkRequestEvent ev = new PlayerChunkRequestEvent(this, chunkX, chunkZ);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) continue;
                this.level.requestChunk(chunkX, chunkZ, this);
            }
        }
        if (this.chunkLoadCount >= this.spawnThreshold && !this.spawned && this.teleportPosition == null) {
            this.doFirstSpawn();
        }
        Timings.playerChunkSendTimer.stopTiming();
    }

    protected void doFirstSpawn() {
        int level;
        Location pos;
        this.spawned = true;
        this.inventory.sendContents(this);
        this.inventory.sendHeldItem(this);
        this.inventory.sendArmorContents(this);
        this.offhandInventory.sendContents(this);
        this.setEnableClientCommand(true);
        SetTimePacket setTimePacket = new SetTimePacket();
        setTimePacket.time = this.level.getTime();
        this.dataPacket(setTimePacket);
        if (this.server.isSafeSpawn()) {
            pos = this.level.getSafeSpawn(this).getLocation();
            pos.yaw = this.yaw;
            pos.pitch = this.pitch;
        } else {
            pos = new Location(this.forceMovement.x, this.forceMovement.y, this.forceMovement.z, this.yaw, this.pitch, this.level);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent(this, pos, true);
        this.server.getPluginManager().callEvent(respawnEvent);
        Position fromEvent = respawnEvent.getRespawnPosition();
        if (fromEvent instanceof Location) {
            pos = fromEvent.getLocation();
        } else {
            pos = fromEvent.getLocation();
            pos.yaw = this.yaw;
            pos.pitch = this.pitch;
        }
        this.teleport(pos, null);
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.sendPlayStatus(3);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent(this, new TranslationContainer((Object)((Object)TextFormat.YELLOW) + "%multiplayer.player.joined", new String[]{this.getDisplayName()}));
        this.server.getPluginManager().callEvent(playerJoinEvent);
        if (playerJoinEvent.getJoinMessage().toString().trim().length() > 0) {
            this.server.broadcastMessage(playerJoinEvent.getJoinMessage());
        }
        this.noDamageTicks = 60;
        this.getServer().sendRecipeList(this);
        for (long index : this.usedChunks.keySet()) {
            int chunkX = Level.getHashX(index);
            int chunkZ = Level.getHashZ(index);
            for (Entity entity : this.level.getChunkEntities(chunkX, chunkZ).values()) {
                if (this == entity || entity.closed || !entity.isAlive()) continue;
                entity.spawnTo(this);
            }
        }
        int experience = this.getExperience();
        if (experience != 0) {
            this.sendExperience(experience);
        }
        if ((level = this.getExperienceLevel()) != 0) {
            this.sendExperienceLevel(this.getExperienceLevel());
        }
        if (!this.isSpectator()) {
            this.spawnToAll();
        }
        this.getLevel().sendWeather(this);
        PlayerFood food = this.getFoodData();
        if (food.getLevel() != food.getMaxLevel()) {
            food.sendFoodLevel();
        }
        if (this.getHealth() < 1.0f) {
            this.respawn();
        } else {
            this.updateTrackingPositions(false);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void updateTrackingPositions() {
        this.updateTrackingPositions(false);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void updateTrackingPositions(boolean delayed) {
        Server server = this.getServer();
        if (delayed) {
            if (this.delayedPosTrackingUpdate != null) {
                this.delayedPosTrackingUpdate.cancel();
            }
            this.delayedPosTrackingUpdate = server.getScheduler().scheduleDelayedTask(null, this::updateTrackingPositions, 10);
            return;
        }
        PositionTrackingService positionTrackingService = server.getPositionTrackingService();
        positionTrackingService.forceRecheck(this);
    }

    protected boolean orderChunks() {
        long index;
        if (!this.connected) {
            return false;
        }
        Timings.playerChunkOrderTimer.startTiming();
        this.nextChunkOrderRun = 200;
        this.loadQueue.clear();
        Long2ObjectOpenHashMap<Boolean> lastChunk = new Long2ObjectOpenHashMap<Boolean>(this.usedChunks);
        int centerX = (int)this.x >> 4;
        int centerZ = (int)this.z >> 4;
        int radius = this.spawned ? this.chunkRadius : (int)Math.ceil(Math.sqrt(this.spawnThreshold));
        int radiusSqr = radius * radius;
        for (int x = 0; x <= radius; ++x) {
            int xx = x * x;
            for (int z = 0; z <= x; ++z) {
                int distanceSqr = xx + z * z;
                if (distanceSqr > radiusSqr) continue;
                index = Level.chunkHash(centerX + x, centerZ + z);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - x - 1, centerZ + z);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX + x, centerZ - z - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - x - 1, centerZ - z - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                if (x == z) continue;
                index = Level.chunkHash(centerX + z, centerZ + x);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - z - 1, centerZ + x);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX + z, centerZ - x - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
                index = Level.chunkHash(centerX - z - 1, centerZ - x - 1);
                if (this.usedChunks.get(index) != Boolean.TRUE) {
                    this.loadQueue.put(index, Boolean.TRUE);
                }
                lastChunk.remove(index);
            }
        }
        LongIterator keys = lastChunk.keySet().iterator();
        while (keys.hasNext()) {
            index = keys.nextLong();
            this.unloadChunk(Level.getHashX(index), Level.getHashZ(index));
        }
        if (!this.loadQueue.isEmpty()) {
            NetworkChunkPublisherUpdatePacket packet = new NetworkChunkPublisherUpdatePacket();
            packet.position = this.asBlockVector3();
            packet.radius = this.viewDistance << 4;
            this.dataPacket(packet);
        }
        Timings.playerChunkOrderTimer.stopTiming();
        return true;
    }

    public boolean batchDataPacket(DataPacket packet) {
        if (packet instanceof BatchPacket) {
            this.directDataPacket(packet);
        }
        if (!this.connected) {
            return false;
        }
        try (Timing timing = Timings.getSendDataPacketTiming(packet);){
            DataPacketSendEvent event = new DataPacketSendEvent(this, packet);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            if (log.isTraceEnabled() && !this.server.isIgnoredPacket(packet.getClass())) {
                log.trace("Outbound {}: {}", (Object)this.getName(), (Object)packet);
            }
            this.packetQueue.offer(packet);
        }
        return true;
    }

    public boolean dataPacket(DataPacket packet) {
        return this.batchDataPacket(packet);
    }

    @Deprecated
    public int dataPacket(DataPacket packet, boolean needACK) {
        return this.dataPacket(packet) ? 0 : -1;
    }

    public boolean directDataPacket(DataPacket packet) {
        if (!this.connected) {
            return false;
        }
        try (Timing timing = Timings.getSendDataPacketTiming(packet);){
            DataPacketSendEvent ev = new DataPacketSendEvent(this, packet);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            this.interfaz.putPacket(this, packet, false, true);
        }
        return true;
    }

    @Deprecated
    public int directDataPacket(DataPacket packet, boolean needACK) {
        return this.directDataPacket(packet) ? 0 : -1;
    }

    public int getPing() {
        return this.interfaz.getNetworkLatency(this);
    }

    public boolean sleepOn(Vector3 pos) {
        if (!this.isOnline()) {
            return false;
        }
        for (Entity p : this.level.getNearbyEntities(this.boundingBox.grow(2.0, 1.0, 2.0), this)) {
            if (!(p instanceof Player) || ((Player)p).sleeping == null || !(pos.distance(((Player)p).sleeping) <= 0.1)) continue;
            return false;
        }
        PlayerBedEnterEvent ev = new PlayerBedEnterEvent(this, this.level.getBlock(pos));
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.sleeping = pos.clone();
        this.teleport(new Location(pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, this.yaw, this.pitch, this.level), null);
        this.setDataProperty(new IntPositionEntityData(28, (int)pos.x, (int)pos.y, (int)pos.z));
        this.setDataFlag(26, 1, true);
        this.setSpawn(pos);
        this.level.sleepTicks = 60;
        this.timeSinceRest = 0;
        return true;
    }

    public void setSpawn(Vector3 pos) {
        Level level = !(pos instanceof Position) ? this.level : ((Position)pos).getLevel();
        this.spawnPosition = new Position(pos.x, pos.y, pos.z, level);
        SetSpawnPositionPacket pk = new SetSpawnPositionPacket();
        pk.spawnType = 0;
        pk.x = (int)this.spawnPosition.x;
        pk.y = (int)this.spawnPosition.y;
        pk.z = (int)this.spawnPosition.z;
        pk.dimension = this.getLevel().getDimension();
        this.dataPacket(pk);
    }

    public void stopSleep() {
        if (this.sleeping != null) {
            this.server.getPluginManager().callEvent(new PlayerBedLeaveEvent(this, this.level.getBlock(this.sleeping)));
            this.sleeping = null;
            this.setDataProperty(new IntPositionEntityData(28, 0, 0, 0));
            this.setDataFlag(26, 1, false);
            this.level.sleepTicks = 0;
            AnimatePacket pk = new AnimatePacket();
            pk.eid = this.id;
            pk.action = AnimatePacket.Action.WAKE_UP;
            this.dataPacket(pk);
        }
    }

    public boolean awardAchievement(String achievementId) {
        if (!Server.getInstance().getPropertyBoolean("achievements", true)) {
            return false;
        }
        Achievement achievement = Achievement.achievements.get(achievementId);
        if (achievement == null || this.hasAchievement(achievementId)) {
            return false;
        }
        for (String id : achievement.requires) {
            if (this.hasAchievement(id)) continue;
            return false;
        }
        PlayerAchievementAwardedEvent event = new PlayerAchievementAwardedEvent(this, achievementId);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.achievements.add(achievementId);
        achievement.broadcast(this);
        return true;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    private static int getClientFriendlyGamemode(int gamemode) {
        if ((gamemode &= 3) == 3) {
            return 1;
        }
        return gamemode;
    }

    public boolean setGamemode(int gamemode) {
        return this.setGamemode(gamemode, false, null);
    }

    public boolean setGamemode(int gamemode, boolean clientSide) {
        return this.setGamemode(gamemode, clientSide, null);
    }

    public boolean setGamemode(int gamemode, boolean clientSide, AdventureSettings newSettings) {
        if (gamemode < 0 || gamemode > 3 || this.gamemode == gamemode) {
            return false;
        }
        if (newSettings == null) {
            newSettings = this.getAdventureSettings().clone(this);
            newSettings.set(AdventureSettings.Type.WORLD_IMMUTABLE, (gamemode & 2) > 0);
            newSettings.set(AdventureSettings.Type.BUILD_AND_MINE, (gamemode & 2) <= 0);
            newSettings.set(AdventureSettings.Type.WORLD_BUILDER, (gamemode & 2) <= 0);
            newSettings.set(AdventureSettings.Type.ALLOW_FLIGHT, (gamemode & 1) > 0);
            newSettings.set(AdventureSettings.Type.NO_CLIP, gamemode == 3);
            newSettings.set(AdventureSettings.Type.FLYING, gamemode == 3);
        }
        PlayerGameModeChangeEvent ev = new PlayerGameModeChangeEvent(this, gamemode, newSettings);
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.gamemode = gamemode;
        if (this.isSpectator()) {
            this.keepMovement = true;
            this.despawnFromAll();
        } else {
            this.keepMovement = false;
            this.spawnToAll();
        }
        this.namedTag.putInt("playerGameType", this.gamemode);
        if (!clientSide) {
            SetPlayerGameTypePacket pk = new SetPlayerGameTypePacket();
            pk.gamemode = Player.getClientFriendlyGamemode(gamemode);
            this.dataPacket(pk);
        }
        this.setAdventureSettings(ev.getNewAdventureSettings());
        if (this.isSpectator()) {
            this.getAdventureSettings().set(AdventureSettings.Type.FLYING, true);
            this.teleport(this.temporalVector.setComponents(this.x, this.y + 0.1, this.z));
        } else if (this.isSurvival()) {
            this.getAdventureSettings().set(AdventureSettings.Type.FLYING, false);
        }
        this.resetFallDistance();
        this.inventory.sendContents(this);
        this.inventory.sendContents(this.getViewers().values());
        this.inventory.sendHeldItem(this.hasSpawned.values());
        this.offhandInventory.sendContents(this);
        this.offhandInventory.sendContents(this.getViewers().values());
        this.inventory.sendCreativeContents();
        return true;
    }

    @Deprecated
    public void sendSettings() {
        this.getAdventureSettings().update();
    }

    public boolean isSurvival() {
        return this.gamemode == 0;
    }

    public boolean isCreative() {
        return this.gamemode == 1;
    }

    public boolean isSpectator() {
        return this.gamemode == 3;
    }

    public boolean isAdventure() {
        return this.gamemode == 2;
    }

    @Override
    public Item[] getDrops() {
        if (!this.isCreative() && !this.isSpectator()) {
            return super.getDrops();
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public boolean setDataProperty(EntityData data) {
        return this.setDataProperty(data, true);
    }

    @Override
    public boolean setDataProperty(EntityData data, boolean send) {
        if (super.setDataProperty(data, send)) {
            if (send) {
                this.sendData(this, new EntityMetadata().put(this.getDataProperty(data.getId())));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void checkGroundState(double movX, double movY, double movZ, double dx, double dy, double dz) {
        if (!this.onGround || movX != 0.0 || movY != 0.0 || movZ != 0.0) {
            boolean onGround = false;
            AxisAlignedBB bb = this.boundingBox.clone();
            bb.setMaxY(bb.getMinY() + 0.5);
            bb.setMinY(bb.getMinY() - 1.0);
            AxisAlignedBB realBB = this.boundingBox.clone();
            realBB.setMaxY(realBB.getMinY() + 0.1);
            realBB.setMinY(realBB.getMinY() - 0.2);
            int minX = NukkitMath.floorDouble(bb.getMinX());
            int minY = NukkitMath.floorDouble(bb.getMinY());
            int minZ = NukkitMath.floorDouble(bb.getMinZ());
            int maxX = NukkitMath.ceilDouble(bb.getMaxX());
            int maxY = NukkitMath.ceilDouble(bb.getMaxY());
            int maxZ = NukkitMath.ceilDouble(bb.getMaxZ());
            for (int z = minZ; z <= maxZ; ++z) {
                block1: for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        Block block = this.level.getBlock(this.temporalVector.setComponents(x, y, z));
                        if (block.canPassThrough() || !block.collidesWithBB(realBB)) continue;
                        onGround = true;
                        continue block1;
                    }
                }
            }
            this.onGround = onGround;
        }
        this.isCollided = this.onGround;
    }

    @Override
    protected void checkBlockCollision() {
        boolean portal = false;
        boolean scaffolding = false;
        boolean endPortal = false;
        for (Block block : this.getCollisionBlocks()) {
            switch (block.getId()) {
                case 90: {
                    portal = true;
                    break;
                }
                case 420: {
                    scaffolding = true;
                    break;
                }
                case 119: {
                    endPortal = true;
                }
            }
            block.onEntityCollide(this);
            block.getLevelBlockAtLayer(1).onEntityCollide(this);
        }
        this.setDataFlag(91, 68, scaffolding);
        AxisAlignedBB scanBoundingBox = this.boundingBox.getOffsetBoundingBox(0.0, -0.125, 0.0);
        scanBoundingBox.setMaxY(this.boundingBox.getMinY());
        Block[] scaffoldingUnder = this.level.getCollisionBlocks(scanBoundingBox, true, true, b -> b.getId() == 420);
        this.setDataFlag(91, 69, scaffoldingUnder.length > 0);
        if (endPortal) {
            if (!this.inEndPortal) {
                this.inEndPortal = true;
                EntityPortalEnterEvent ev = new EntityPortalEnterEvent(this, EntityPortalEnterEvent.PortalType.END);
                this.getServer().getPluginManager().callEvent(ev);
            }
        } else {
            this.inEndPortal = false;
        }
        this.inPortalTicks = portal ? (this.isCreative() && this.inPortalTicks < 80 ? 80 : ++this.inPortalTicks) : 0;
    }

    protected void checkNearEntities() {
        for (Entity entity : this.level.getNearbyEntities(this.boundingBox.grow(1.0, 0.5, 1.0), this)) {
            entity.scheduleUpdate();
            if (!entity.isAlive() || !this.isAlive()) continue;
            this.pickupEntity(entity, true);
        }
    }

    protected void processMovement(int tickDiff) {
        int soulSpeedLevel;
        Enchantment frostWalker;
        if (!this.isAlive() || !this.spawned || this.newPosition == null || this.teleportPosition != null || this.isSleeping()) {
            this.positionChanged = false;
            return;
        }
        Vector3 newPos = this.newPosition;
        double distanceSquared = newPos.distanceSquared(this);
        boolean revert = false;
        if (distanceSquared / (double)(tickDiff * tickDiff) > 100.0 && newPos.y - this.y > -5.0) {
            revert = true;
        } else if (this.chunk == null || !this.chunk.isGenerated()) {
            BaseFullChunk chunk = this.level.getChunk((int)newPos.x >> 4, (int)newPos.z >> 4, false);
            if (chunk == null || !chunk.isGenerated()) {
                revert = true;
                this.nextChunkOrderRun = 0;
            } else {
                if (this.chunk != null) {
                    this.chunk.removeEntity(this);
                }
                this.chunk = chunk;
            }
        }
        double tdx = newPos.x - this.x;
        double tdz = newPos.z - this.z;
        double distance = Math.sqrt(tdx * tdx + tdz * tdz);
        if (!revert && distanceSquared != 0.0) {
            double dx = newPos.x - this.x;
            double dy = newPos.y - this.y;
            double dz = newPos.z - this.z;
            this.fastMove(dx, dy, dz);
            if (this.newPosition == null) {
                return;
            }
            double diffX = this.x - newPos.x;
            double diffY = this.y - newPos.y;
            double diffZ = this.z - newPos.z;
            double yS = 0.5 + (double)this.ySize;
            if (diffY >= -yS || diffY <= yS) {
                diffY = 0.0;
            }
            if (diffX != 0.0 || diffY != 0.0 || diffZ != 0.0) {
                double diffHorizontalSqr;
                if (this.checkMovement && !this.isOp() && !this.server.getAllowFlight() && (this.isSurvival() || this.isAdventure()) && !this.isSleeping() && this.riding == null && !this.hasEffect(24) && (diffHorizontalSqr = (diffX * diffX + diffZ * diffZ) / (double)(tickDiff * tickDiff)) > 0.5) {
                    PlayerInvalidMoveEvent ev = new PlayerInvalidMoveEvent(this, true);
                    this.getServer().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled() && (revert = ev.isRevert())) {
                        this.server.getLogger().warning(this.getServer().getLanguage().translateString("nukkit.player.invalidMove", this.getName()));
                    }
                }
                this.x = newPos.x;
                this.y = newPos.y;
                this.z = newPos.z;
                double radius = this.getWidth() / 2.0f;
                this.boundingBox.setBounds(this.x - radius, this.y, this.z - radius, this.x + radius, this.y + (double)this.getHeight(), this.z + radius);
            }
        }
        Location from = new Location(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch, this.level);
        Location to = this.getLocation();
        double delta = Math.pow(this.lastX - to.x, 2.0) + Math.pow(this.lastY - to.y, 2.0) + Math.pow(this.z - to.z, 2.0);
        double deltaAngle = Math.abs(this.lastYaw - to.yaw) + Math.abs(this.lastPitch - to.pitch);
        if (!revert && (delta > 1.0E-4 || deltaAngle > 1.0)) {
            boolean isFirst = this.firstMove;
            this.firstMove = false;
            this.lastX = to.x;
            this.lastY = to.y;
            this.lastZ = to.z;
            this.lastYaw = to.yaw;
            this.lastPitch = to.pitch;
            if (!isFirst) {
                ArrayList blocksAround = new ArrayList(this.blocksAround);
                ArrayList collidingBlocks = new ArrayList(this.collisionBlocks);
                PlayerMoveEvent ev = new PlayerMoveEvent(this, from, to);
                this.blocksAround = null;
                this.collisionBlocks = null;
                this.server.getPluginManager().callEvent(ev);
                revert = ev.isCancelled();
                if (!revert) {
                    if (!to.equals(ev.getTo())) {
                        this.teleport(ev.getTo(), null);
                    } else {
                        this.addMovement(this.x, this.y, this.z, this.yaw, this.pitch, this.yaw);
                    }
                } else {
                    this.blocksAround = blocksAround;
                    this.collisionBlocks = collidingBlocks;
                }
            }
            if (this.speed == null) {
                this.speed = new Vector3(from.x - to.x, from.y - to.y, from.z - to.z);
            } else {
                this.speed.setComponents(from.x - to.x, from.y - to.y, from.z - to.z);
            }
        } else if (this.speed == null) {
            this.speed = new Vector3(0.0, 0.0, 0.0);
        } else {
            this.speed.setComponents(0.0, 0.0, 0.0);
        }
        if (!revert && (this.isFoodEnabled() || this.getServer().getDifficulty() == 0) && (this.isSurvival() || this.isAdventure()) && distance >= 0.05) {
            double swimming;
            double jump = 0.0;
            double d = swimming = this.isInsideOfWater() ? 0.015 * distance : 0.0;
            if (swimming != 0.0) {
                distance = 0.0;
            }
            if (this.isSprinting()) {
                if (this.inAirTicks == 3 && swimming == 0.0) {
                    jump = 0.7;
                }
                this.getFoodData().updateFoodExpLevel(0.06 * distance + jump + swimming);
            } else {
                if (this.inAirTicks == 3 && swimming == 0.0) {
                    jump = 0.2;
                }
                this.getFoodData().updateFoodExpLevel(0.01 * distance + jump + swimming);
            }
        }
        if (!revert && delta > 1.0E-4 && (frostWalker = this.inventory.getBoots().getEnchantment(25)) != null && frostWalker.getLevel() > 0 && !this.isSpectator() && this.y >= 1.0 && this.y <= 255.0) {
            int radius = 2 + frostWalker.getLevel();
            for (int coordX = this.getFloorX() - radius; coordX < this.getFloorX() + radius + 1; ++coordX) {
                for (int coordZ = this.getFloorZ() - radius; coordZ < this.getFloorZ() + radius + 1; ++coordZ) {
                    Block block = this.level.getBlock(coordX, this.getFloorY() - 1, coordZ);
                    int layer = 0;
                    if (block.getId() != 9 && (block.getId() != 8 || block.getDamage() != 0) || block.up().getId() != 0) {
                        block = block.getLevelBlockAtLayer(1);
                        layer = 1;
                        if (block.getId() != 9 && (block.getId() != 8 || block.getDamage() != 0) || block.up().getId() != 0) continue;
                    }
                    WaterFrostEvent ev = new WaterFrostEvent(block, this);
                    this.server.getPluginManager().callEvent(ev);
                    if (ev.isCancelled()) continue;
                    this.level.setBlock(block, layer, Block.get(207), true, false);
                    this.level.scheduleUpdate(this.level.getBlock((Vector3)block, layer), ThreadLocalRandom.current().nextInt(20, 40));
                }
            }
        }
        if (!revert && (soulSpeedLevel = this.getInventory().getBoots().getEnchantmentLevel(36)) > 0) {
            Block downBlock = this.getLevelBlock().down();
            if (this.wasInSoulSandCompatible && !downBlock.isSoulSpeedCompatible()) {
                this.wasInSoulSandCompatible = false;
                this.soulSpeedMultiplier = 1.0f;
                this.sendMovementSpeed(this.movementSpeed);
            } else if (!this.wasInSoulSandCompatible && downBlock.isSoulSpeedCompatible()) {
                this.wasInSoulSandCompatible = true;
                this.soulSpeedMultiplier = (float)soulSpeedLevel * 0.105f + 1.3f;
                this.sendMovementSpeed(this.movementSpeed * this.soulSpeedMultiplier);
            }
        }
        if (revert) {
            this.lastX = from.x;
            this.lastY = from.y;
            this.lastZ = from.z;
            this.lastYaw = from.yaw;
            this.lastPitch = from.pitch;
            this.sendPosition(from.add(0.0, 1.0E-5, 0.0), from.yaw, from.pitch, 1);
            this.forceMovement = new Vector3(from.x, from.y + 1.0E-5, from.z);
        } else {
            this.forceMovement = null;
            if (distanceSquared != 0.0 && this.nextChunkOrderRun > 20) {
                this.nextChunkOrderRun = 20;
            }
        }
        this.newPosition = null;
    }

    @Override
    public void addMovement(double x, double y, double z, double yaw, double pitch, double headYaw) {
        this.sendPosition(new Vector3(x, y, z), yaw, pitch, 0, this.getViewers().values().toArray(EMPTY_ARRAY));
    }

    @Override
    public boolean setMotion(Vector3 motion) {
        if (super.setMotion(motion)) {
            if (this.chunk != null) {
                this.addMotion(this.motionX, this.motionY, this.motionZ);
                SetEntityMotionPacket pk = new SetEntityMotionPacket();
                pk.eid = this.id;
                pk.motionX = (float)motion.x;
                pk.motionY = (float)motion.y;
                pk.motionZ = (float)motion.z;
                this.dataPacket(pk);
            }
            if (this.motionY > 0.0) {
                this.startAirTicks = (int)(-Math.log((double)this.getGravity() / ((double)this.getGravity() + (double)this.getDrag() * this.motionY)) / (double)this.getDrag() * 2.0 + 5.0);
            }
            return true;
        }
        return false;
    }

    public void sendMovementSpeed(float movementSpeed) {
        Attribute attribute = Attribute.getAttribute(5).setValue(movementSpeed);
        this.setAttribute(attribute);
    }

    public void sendAttributes() {
        UpdateAttributesPacket pk = new UpdateAttributesPacket();
        pk.entityId = this.getId();
        Attribute[] attributeArray = new Attribute[5];
        attributeArray[0] = Attribute.getAttribute(4).setMaxValue(this.getMaxHealth()).setValue(this.health > 0.0f ? (this.health < (float)this.getMaxHealth() ? this.health : (float)this.getMaxHealth()) : 0.0f);
        attributeArray[1] = Attribute.getAttribute(7).setValue(this.getFoodData().getLevel());
        attributeArray[2] = Attribute.getAttribute(5).setValue(this.getMovementSpeed());
        attributeArray[3] = Attribute.getAttribute(9).setValue(this.getExperienceLevel());
        attributeArray[4] = Attribute.getAttribute(10).setValue((float)this.getExperience() / (float)Player.calculateRequireExperience(this.getExperienceLevel()));
        pk.entries = attributeArray;
        this.dataPacket(pk);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (!this.loggedIn) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0) {
            return true;
        }
        this.messageCounter = 2;
        this.lastUpdate = currentTick;
        if (this.fishing != null && this.server.getTick() % 20 == 0 && this.distance(this.fishing) > 33.0) {
            this.stopFishing(false);
        }
        if (!this.isAlive() && this.spawned) {
            ++this.deadTicks;
            if (this.deadTicks >= 10) {
                this.despawnFromAll();
            }
            return true;
        }
        if (this.spawned) {
            this.processMovement(tickDiff);
            if (!this.isSpectator()) {
                this.checkNearEntities();
            }
            this.entityBaseTick(tickDiff);
            if (this.getServer().getDifficulty() == 0 && this.level.getGameRules().getBoolean(GameRule.NATURAL_REGENERATION)) {
                PlayerFood foodData;
                if (this.getHealth() < (float)this.getMaxHealth() && this.ticksLived % 20 == 0) {
                    this.heal(1.0f);
                }
                if ((foodData = this.getFoodData()).getLevel() < 20 && this.ticksLived % 10 == 0) {
                    foodData.addFoodLevel(1, 0.0f);
                }
            }
            if (this.isOnFire() && this.lastUpdate % 10 == 0) {
                if (this.isCreative() && !this.isInsideOfFire()) {
                    this.extinguish();
                } else if (this.getLevel().isRaining() && this.getLevel().canBlockSeeSky(this)) {
                    this.extinguish();
                }
            }
            if (!this.isSpectator() && this.speed != null) {
                if (this.onGround) {
                    if (this.inAirTicks != 0) {
                        this.startAirTicks = 5;
                    }
                    this.inAirTicks = 0;
                    this.highestPosition = this.y;
                } else {
                    if (!(!this.checkMovement || this.isGliding() || this.server.getAllowFlight() || this.getAdventureSettings().get(AdventureSettings.Type.ALLOW_FLIGHT) || this.inAirTicks <= 20 || this.isSleeping() || this.isImmobile() || this.isSwimming() || this.riding != null || this.hasEffect(24))) {
                        boolean ignore;
                        double expectedVelocity = (double)(-this.getGravity()) / (double)this.getDrag() - (double)(-this.getGravity()) / (double)this.getDrag() * Math.exp(-((double)this.getDrag()) * (double)(this.inAirTicks - this.startAirTicks));
                        double diff = (this.speed.y - expectedVelocity) * (this.speed.y - expectedVelocity);
                        Block block = this.level.getBlock(this);
                        int blockId = block.getId();
                        boolean bl = ignore = blockId == 65 || blockId == 106 || blockId == 30 || blockId == 420;
                        if (!this.hasEffect(8) && diff > 0.6 && expectedVelocity < this.speed.y && !ignore) {
                            if (this.inAirTicks < 150) {
                                this.setMotion(new Vector3(0.0, expectedVelocity, 0.0));
                            } else if (this.kick(PlayerKickEvent.Reason.FLYING_DISABLED, "Flying is not enabled on this server")) {
                                return false;
                            }
                        }
                        if (ignore) {
                            this.resetFallDistance();
                        }
                    }
                    if (this.y > this.highestPosition) {
                        this.highestPosition = this.y;
                    }
                    if (this.isGliding()) {
                        this.resetFallDistance();
                    }
                    ++this.inAirTicks;
                }
                if ((this.isSurvival() || this.isAdventure()) && this.getFoodData() != null) {
                    this.getFoodData().update(tickDiff);
                }
            }
            if (!this.isSleeping()) {
                ++this.timeSinceRest;
            }
        }
        this.checkTeleportPosition();
        if (currentTick % 10 == 0) {
            this.checkInteractNearby();
        }
        if (this.spawned && this.dummyBossBars.size() > 0 && currentTick % 100 == 0) {
            this.dummyBossBars.values().forEach(DummyBossBar::updateBossEntityPosition);
        }
        this.updateBlockingFlag();
        return true;
    }

    @Override
    public boolean entityBaseTick(int tickDiff) {
        boolean hasUpdated = false;
        if (this.isUsingItem()) {
            if (this.noShieldTicks < 10) {
                this.noShieldTicks = 10;
                hasUpdated = true;
            }
        } else {
            if (this.noShieldTicks > 0) {
                this.noShieldTicks -= tickDiff;
                hasUpdated = true;
            }
            if (this.noShieldTicks < 0) {
                this.noShieldTicks = 0;
                hasUpdated = true;
            }
        }
        return super.entityBaseTick(tickDiff) || hasUpdated;
    }

    public void checkInteractNearby() {
        int interactDistance;
        int n = interactDistance = this.isCreative() ? 5 : 3;
        if (this.canInteract(this, interactDistance)) {
            if (this.getEntityPlayerLookingAt(interactDistance) != null) {
                EntityInteractable onInteract = this.getEntityPlayerLookingAt(interactDistance);
                this.setButtonText(onInteract.getInteractButtonText());
            } else {
                this.setButtonText("");
            }
        } else {
            this.setButtonText("");
        }
    }

    public EntityInteractable getEntityPlayerLookingAt(int maxDistance) {
        this.timing.startTiming();
        EntityInteractable entity = null;
        if (this.temporalVector != null) {
            Entity[] nearbyEntities = this.level.getNearbyEntities(this.boundingBox.grow(maxDistance, maxDistance, maxDistance), this);
            try {
                BlockIterator itr = new BlockIterator(this.level, this.getPosition(), this.getDirectionVector(), this.getEyeHeight(), maxDistance);
                if (itr.hasNext()) {
                    Block block;
                    while (itr.hasNext() && (entity = this.getEntityAtPosition(nearbyEntities, (block = itr.next()).getFloorX(), block.getFloorY(), block.getFloorZ())) == null) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.timing.stopTiming();
        return entity;
    }

    private EntityInteractable getEntityAtPosition(Entity[] nearbyEntities, int x, int y, int z) {
        for (Entity nearestEntity : nearbyEntities) {
            if (nearestEntity.getFloorX() != x || nearestEntity.getFloorY() != y || nearestEntity.getFloorZ() != z || !(nearestEntity instanceof EntityInteractable) || !((EntityInteractable)((Object)nearestEntity)).canDoInteraction()) continue;
            return (EntityInteractable)((Object)nearestEntity);
        }
        return null;
    }

    public void checkNetwork() {
        if (!this.packetQueue.isEmpty()) {
            DataPacket packet;
            Player[] pArr = new Player[]{this};
            ArrayList<DataPacket> toBatch = new ArrayList<DataPacket>();
            while ((packet = this.packetQueue.poll()) != null) {
                toBatch.add(packet);
            }
            DataPacket[] arr = toBatch.toArray(new DataPacket[0]);
            this.server.batchPackets(pArr, arr, false);
        }
        if (!this.isOnline()) {
            return;
        }
        if (this.nextChunkOrderRun-- <= 0 || this.chunk == null) {
            this.orderChunks();
        }
        if (!this.loadQueue.isEmpty() || !this.spawned) {
            this.sendNextChunk();
        }
    }

    public boolean canInteract(Vector3 pos, double maxDistance) {
        return this.canInteract(pos, maxDistance, 6.0);
    }

    public boolean canInteract(Vector3 pos, double maxDistance, double maxDiff) {
        if (this.distanceSquared(pos) > maxDistance * maxDistance) {
            return false;
        }
        Vector2 dV = this.getDirectionPlane();
        double dot = dV.dot(new Vector2(this.x, this.z));
        double dot1 = dV.dot(new Vector2(pos.x, pos.z));
        return dot1 - dot >= -maxDiff;
    }

    protected void processLogin() {
        CompoundTag nbt;
        if (!this.server.isWhitelisted(this.getName().toLowerCase())) {
            this.kick(PlayerKickEvent.Reason.NOT_WHITELISTED, "Server is white-listed");
            return;
        }
        if (this.isBanned()) {
            String reason = this.server.getNameBans().getEntires().get(this.getName().toLowerCase()).getReason();
            this.kick(PlayerKickEvent.Reason.NAME_BANNED, !reason.isEmpty() ? "You are banned. Reason: " + reason : "You are banned");
            return;
        }
        if (this.server.getIPBans().isBanned(this.getAddress())) {
            String reason = this.server.getIPBans().getEntires().get(this.getAddress()).getReason();
            this.kick(PlayerKickEvent.Reason.IP_BANNED, !reason.isEmpty() ? "You are banned. Reason: " + reason : "You are banned");
            return;
        }
        if (this.hasPermission("nukkit.broadcast.user")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.user", this);
        }
        if (this.hasPermission("nukkit.broadcast.admin")) {
            this.server.getPluginManager().subscribeToPermission("nukkit.broadcast.admin", this);
        }
        EntityHuman oldPlayer = null;
        for (Player p : new ArrayList<Player>(this.server.getOnlinePlayers().values())) {
            if ((p == this || p.getName() == null || !p.getName().equalsIgnoreCase(this.getName())) && !this.getUniqueId().equals(p.getUniqueId())) continue;
            oldPlayer = p;
            break;
        }
        if (oldPlayer != null) {
            oldPlayer.saveNBT();
            nbt = ((Player)oldPlayer).namedTag;
            ((Player)oldPlayer).close("", "disconnectionScreen.loggedinOtherLocation");
        } else {
            File legacyDataFile = new File(this.server.getDataPath() + "players/" + this.username.toLowerCase() + ".dat");
            File dataFile = new File(this.server.getDataPath() + "players/" + this.uuid.toString() + ".dat");
            if (legacyDataFile.exists() && !dataFile.exists()) {
                nbt = this.server.getOfflinePlayerData(this.username, false);
                if (!legacyDataFile.delete()) {
                    log.warn("Could not delete legacy player data for {}", (Object)this.username);
                }
            } else {
                nbt = this.server.getOfflinePlayerData(this.uuid, true);
            }
        }
        if (nbt == null) {
            this.close(this.getLeaveMessage(), "Invalid data");
            return;
        }
        if (this.loginChainData.isXboxAuthed() && this.server.getPropertyBoolean("xbox-auth") || !this.server.getPropertyBoolean("xbox-auth")) {
            this.server.updateName(this.uuid, this.username);
        }
        this.playedBefore = nbt.getLong("lastPlayed") - nbt.getLong("firstPlayed") > 1L;
        nbt.putString("NameTag", this.username);
        int exp = nbt.getInt("EXP");
        int expLevel = nbt.getInt("expLevel");
        this.setExperience(exp, expLevel);
        this.gamemode = nbt.getInt("playerGameType") & 3;
        if (this.server.getForceGamemode()) {
            this.gamemode = this.server.getGamemode();
            nbt.putInt("playerGameType", this.gamemode);
        }
        this.adventureSettings = new AdventureSettings(this).set(AdventureSettings.Type.WORLD_IMMUTABLE, this.isAdventure() || this.isSpectator()).set(AdventureSettings.Type.WORLD_BUILDER, !this.isAdventure() && !this.isSpectator()).set(AdventureSettings.Type.AUTO_JUMP, true).set(AdventureSettings.Type.ALLOW_FLIGHT, this.isCreative()).set(AdventureSettings.Type.NO_CLIP, this.isSpectator());
        Level level = this.server.getLevelByName(nbt.getString("Level"));
        if (level == null) {
            this.setLevel(this.server.getDefaultLevel());
            nbt.putString("Level", this.level.getName());
            Position spawnLocation = this.level.getSafeSpawn();
            nbt.getList("Pos", DoubleTag.class).add(new DoubleTag("0", spawnLocation.x)).add(new DoubleTag("1", spawnLocation.y)).add(new DoubleTag("2", spawnLocation.z));
        } else {
            this.setLevel(level);
        }
        for (Tag achievement : nbt.getCompound("Achievements").getAllTags()) {
            if (!(achievement instanceof ByteTag) || ((ByteTag)achievement).getData() <= 0) continue;
            this.achievements.add(achievement.getName());
        }
        nbt.putLong("lastPlayed", System.currentTimeMillis() / 1000L);
        UUID uuid = this.getUniqueId();
        nbt.putLong("UUIDLeast", uuid.getLeastSignificantBits());
        nbt.putLong("UUIDMost", uuid.getMostSignificantBits());
        if (this.server.getAutoSave()) {
            this.server.saveOfflinePlayerData(this.uuid, nbt, true);
        }
        this.sendPlayStatus(0);
        this.server.onPlayerLogin(this);
        ListTag<DoubleTag> posList = nbt.getList("Pos", DoubleTag.class);
        super.init(this.level.getChunk((int)posList.get((int)0).data >> 4, (int)posList.get((int)2).data >> 4, true), nbt);
        if (!this.namedTag.contains("foodLevel")) {
            this.namedTag.putInt("foodLevel", 20);
        }
        int foodLevel = this.namedTag.getInt("foodLevel");
        if (!this.namedTag.contains("FoodSaturationLevel")) {
            this.namedTag.putFloat("FoodSaturationLevel", 20.0f);
        }
        float foodSaturationLevel = this.namedTag.getFloat("foodSaturationLevel");
        this.foodData = new PlayerFood(this, foodLevel, foodSaturationLevel);
        if (this.isSpectator()) {
            this.keepMovement = true;
        }
        this.forceMovement = this.teleportPosition = this.getPosition();
        if (!this.namedTag.contains("TimeSinceRest")) {
            this.namedTag.putInt("TimeSinceRest", 0);
        }
        this.timeSinceRest = this.namedTag.getInt("TimeSinceRest");
        if (!this.server.isCheckMovement()) {
            this.checkMovement = false;
        }
        ResourcePacksInfoPacket infoPacket = new ResourcePacksInfoPacket();
        infoPacket.resourcePackEntries = this.server.getResourcePackManager().getResourceStack();
        infoPacket.mustAccept = this.server.getForceResources();
        this.dataPacket(infoPacket);
    }

    protected void completeLoginSequence() {
        PlayerLoginEvent ev = new PlayerLoginEvent(this, "Plugin reason");
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            this.close(this.getLeaveMessage(), ev.getKickMessage());
            return;
        }
        Level level = this.server.getLevelByName(this.namedTag.getString("SpawnLevel"));
        this.spawnPosition = level != null ? new Position(this.namedTag.getInt("SpawnX"), this.namedTag.getInt("SpawnY"), this.namedTag.getInt("SpawnZ"), level) : this.level.getSafeSpawn();
        this.spawnPosition = this.getSpawn();
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.entityUniqueId = this.id;
        startGamePacket.entityRuntimeId = this.id;
        startGamePacket.playerGamemode = Player.getClientFriendlyGamemode(this.gamemode);
        startGamePacket.x = (float)this.x;
        startGamePacket.y = (float)this.y;
        startGamePacket.z = (float)this.z;
        startGamePacket.yaw = (float)this.yaw;
        startGamePacket.pitch = (float)this.pitch;
        startGamePacket.seed = -1;
        startGamePacket.dimension = 0;
        startGamePacket.worldGamemode = Player.getClientFriendlyGamemode(this.gamemode);
        startGamePacket.difficulty = this.server.getDifficulty();
        startGamePacket.spawnX = this.spawnPosition.getFloorX();
        startGamePacket.spawnY = this.spawnPosition.getFloorY();
        startGamePacket.spawnZ = this.spawnPosition.getFloorZ();
        startGamePacket.hasAchievementsDisabled = true;
        startGamePacket.dayCycleStopTime = -1;
        startGamePacket.rainLevel = 0.0f;
        startGamePacket.lightningLevel = 0.0f;
        startGamePacket.commandsEnabled = this.isEnableClientCommand();
        startGamePacket.gameRules = this.getLevel().getGameRules();
        startGamePacket.levelId = "";
        startGamePacket.worldName = this.getServer().getNetwork().getName();
        startGamePacket.generator = 1;
        startGamePacket.dimension = (byte)this.getLevel().getDimension();
        this.dataPacket(startGamePacket);
        this.dataPacket(new BiomeDefinitionListPacket());
        this.dataPacket(new AvailableEntityIdentifiersPacket());
        this.inventory.sendCreativeContents();
        this.getAdventureSettings().update();
        this.sendAttributes();
        this.sendPotionEffects(this);
        this.sendData(this);
        this.loggedIn = true;
        this.level.sendTime(this);
        this.sendAttributes();
        this.setNameTagVisible(true);
        this.setNameTagAlwaysVisible(true);
        this.setCanClimb(true);
        this.server.getLogger().info(this.getServer().getLanguage().translateString("nukkit.player.logIn", (Object)((Object)TextFormat.AQUA) + this.username + (Object)((Object)TextFormat.WHITE), this.getAddress(), String.valueOf(this.getPort()), String.valueOf(this.id), this.level.getName(), String.valueOf(NukkitMath.round(this.x, 4)), String.valueOf(NukkitMath.round(this.y, 4)), String.valueOf(NukkitMath.round(this.z, 4))));
        if (this.isOp() || this.hasPermission("nukkit.textcolor")) {
            this.setRemoveFormat(false);
        }
        this.server.addOnlinePlayer(this);
        this.server.onPlayerCompleteLoginSequence(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleDataPacket(DataPacket packet) {
        if (!this.connected) {
            return;
        }
        timing = Timings.getReceiveDataPacketTiming(packet);
        var3_3 = null;
        try {
            ev = new DataPacketReceiveEvent(this, packet);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return;
            }
            if (packet.pid() == -1) {
                this.server.getNetwork().processBatch((BatchPacket)packet, this);
                return;
            }
            if (Player.log.isTraceEnabled() && !this.server.isIgnoredPacket(packet.getClass())) {
                Player.log.trace("Inbound {}: {}", (Object)this.getName(), (Object)packet);
            }
            switch (packet.pid()) {
                case 1: {
                    if (this.loggedIn) {
                        return;
                    }
                    loginPacket = (LoginPacket)packet;
                    if (!ProtocolInfo.SUPPORTED_PROTOCOLS.contains(loginPacket.getProtocol())) {
                        if (loginPacket.getProtocol() < ProtocolInfo.CURRENT_PROTOCOL) {
                            message = "disconnectionScreen.outdatedClient";
                            this.sendPlayStatus(1, true);
                        } else {
                            message = "disconnectionScreen.outdatedServer";
                            this.sendPlayStatus(2, true);
                        }
                        if (((LoginPacket)packet).protocol < 137) {
                            disconnectPacket = new DisconnectPacket();
                            disconnectPacket.message = message;
                            disconnectPacket.encode();
                            batch = new BatchPacket();
                            batch.payload = disconnectPacket.getBuffer();
                            this.directDataPacket(batch);
                        }
                        this.close("", message, false);
                        return;
                    }
                    this.displayName = this.username = TextFormat.clean(loginPacket.username);
                    this.iusername = this.username.toLowerCase();
                    this.setDataProperty(new StringEntityData(4, this.username), false);
                    this.loginChainData = ClientChainData.read(loginPacket);
                    if (!this.loginChainData.isXboxAuthed() && this.server.getPropertyBoolean("xbox-auth")) {
                        this.close("", "disconnectionScreen.notAuthenticated");
                        return;
                    }
                    if (this.server.getOnlinePlayers().size() >= this.server.getMaxPlayers() && this.kick(PlayerKickEvent.Reason.SERVER_FULL, "disconnectionScreen.serverFull", false)) {
                        return;
                    }
                    this.randomClientId = loginPacket.clientId;
                    this.uuid = loginPacket.clientUUID;
                    this.rawUUID = Binary.writeUUID(this.uuid);
                    valid = true;
                    len = loginPacket.username.length();
                    if (len > 16 || len < 3) {
                        valid = false;
                    }
                    for (i = 0; i < len && valid; ++i) {
                        c = loginPacket.username.charAt(i);
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ' ') continue;
                        valid = false;
                        break;
                    }
                    if (!valid || Objects.equals(this.iusername, "rcon") || Objects.equals(this.iusername, "console")) {
                        this.close("", "disconnectionScreen.invalidName");
                        return;
                    }
                    if (!loginPacket.skin.isValid()) {
                        this.close("", "disconnectionScreen.invalidSkin");
                        return;
                    }
                    skin = loginPacket.skin;
                    if (this.server.isForceSkinTrusted()) {
                        skin.setTrusted(true);
                    }
                    this.setSkin(skin);
                    playerPreLoginEvent = new PlayerPreLoginEvent(this, "Plugin reason");
                    this.server.getPluginManager().callEvent(playerPreLoginEvent);
                    if (playerPreLoginEvent.isCancelled()) {
                        this.close("", playerPreLoginEvent.getKickMessage());
                        return;
                    }
                    playerInstance = this;
                    this.preLoginEventTask = new AsyncTask(){
                        private PlayerAsyncPreLoginEvent e;

                        @Override
                        public void onRun() {
                            this.e = new PlayerAsyncPreLoginEvent(Player.this.username, Player.this.uuid, Player.this.loginChainData.getXUID(), Player.this.getAddress(), Player.this.getPort());
                            Player.this.server.getPluginManager().callEvent(this.e);
                        }

                        @Override
                        public void onCompletion(Server server) {
                            if (!playerInstance.closed) {
                                if (this.e.getLoginResult() == PlayerAsyncPreLoginEvent.LoginResult.KICK) {
                                    playerInstance.close(this.e.getKickMessage(), this.e.getKickMessage());
                                } else if (playerInstance.shouldLogin) {
                                    playerInstance.completeLoginSequence();
                                    for (Consumer<Server> action : this.e.getScheduledActions()) {
                                        action.accept(server);
                                    }
                                }
                            }
                        }
                    };
                    this.server.getScheduler().scheduleAsyncTask(this.preLoginEventTask);
                    this.processLogin();
                    return;
                }
                case 8: {
                    responsePacket = (ResourcePackClientResponsePacket)packet;
                    switch (responsePacket.responseStatus) {
                        case 1: {
                            this.close("", "disconnectionScreen.noReason");
                            return;
                        }
                        case 2: {
                            var12_20 = responsePacket.packEntries;
                            var13_23 = var12_20.length;
                            var14_25 = 0;
                            while (var14_25 < var13_23) {
                                entry = var12_20[var14_25];
                                resourcePack = this.server.getResourcePackManager().getPackById(entry.uuid);
                                if (resourcePack == null) {
                                    this.close("", "disconnectionScreen.resourcePack");
                                    return;
                                }
                                dataInfoPacket = new ResourcePackDataInfoPacket();
                                dataInfoPacket.packId = resourcePack.getPackId();
                                dataInfoPacket.maxChunkSize = 0x100000;
                                dataInfoPacket.chunkCount = resourcePack.getPackSize() / dataInfoPacket.maxChunkSize;
                                dataInfoPacket.compressedPackSize = resourcePack.getPackSize();
                                dataInfoPacket.sha256 = resourcePack.getSha256();
                                this.dataPacket(dataInfoPacket);
                                ++var14_25;
                            }
                            return;
                        }
                        case 3: {
                            stackPacket = new ResourcePackStackPacket();
                            stackPacket.mustAccept = this.server.getForceResources();
                            stackPacket.resourcePackStack = this.server.getResourcePackManager().getResourceStack();
                            this.dataPacket(stackPacket);
                            return;
                        }
                        case 4: {
                            this.shouldLogin = true;
                            if (this.preLoginEventTask.isFinished() == false) return;
                            this.preLoginEventTask.onCompletion(this.server);
                        }
                    }
                    return;
                }
                case 84: {
                    requestPacket = (ResourcePackChunkRequestPacket)packet;
                    resourcePack = this.server.getResourcePackManager().getPackById(requestPacket.packId);
                    if (resourcePack == null) {
                        this.close("", "disconnectionScreen.resourcePack");
                        return;
                    }
                    dataPacket = new ResourcePackChunkDataPacket();
                    dataPacket.packId = resourcePack.getPackId();
                    dataPacket.chunkIndex = requestPacket.chunkIndex;
                    dataPacket.data = resourcePack.getPackChunk(0x100000 * requestPacket.chunkIndex, 0x100000);
                    dataPacket.progress = 0x100000 * requestPacket.chunkIndex;
                    this.dataPacket(dataPacket);
                    return;
                }
                case 113: {
                    if (this.locallyInitialized) {
                        return;
                    }
                    this.locallyInitialized = true;
                    locallyInitializedEvent = new PlayerLocallyInitializedEvent(this);
                    this.server.getPluginManager().callEvent(locallyInitializedEvent);
                    return;
                }
                case 93: {
                    skinPacket = (PlayerSkinPacket)packet;
                    skin = skinPacket.skin;
                    if (!skin.isValid()) {
                        return;
                    }
                    if (this.server.isForceSkinTrusted()) {
                        skin.setTrusted(true);
                    }
                    playerChangeSkinEvent = new PlayerChangeSkinEvent(this, skin);
                    playerChangeSkinEvent.setCancelled(TimeUnit.SECONDS.toMillis(this.server.getPlayerSkinChangeCooldown()) > System.currentTimeMillis() - this.lastSkinChange);
                    this.server.getPluginManager().callEvent(playerChangeSkinEvent);
                    if (playerChangeSkinEvent.isCancelled() != false) return;
                    this.lastSkinChange = System.currentTimeMillis();
                    this.setSkin(skin);
                    return;
                }
                case -100: {
                    packetName = Arrays.stream(ProtocolInfo.class.getDeclaredFields()).filter((Predicate<Field>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleDataPacket$1(java.lang.reflect.Field ), (Ljava/lang/reflect/Field;)Z)()).filter((Predicate<Field>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handleDataPacket$2(cn.nukkit.network.protocol.DataPacket java.lang.reflect.Field ), (Ljava/lang/reflect/Field;)Z)((DataPacket)packet)).map((Function<Field, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Ljava/lang/reflect/Field;)Ljava/lang/String;)()).findFirst();
                    Player.log.warn("Received packet violation warning" + packetName.map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handleDataPacket$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).orElse("") + ": " + packet.toString());
                    return;
                }
                case -118: {
                    var20_35 = this.getViewers().values().iterator();
                    while (var20_35.hasNext() != false) {
                        viewer = var20_35.next();
                        viewer.dataPacket(packet);
                    }
                    return;
                }
                case 57: {
                    if (this.isAlive() == false) return;
                    if (!this.spawned) {
                        return;
                    }
                    ipk = (PlayerInputPacket)packet;
                    if (this.riding instanceof EntityMinecartAbstract == false) return;
                    ((EntityMinecartAbstract)this.riding).setCurrentSpeed(ipk.motionY);
                    return;
                }
                case 19: {
                    if (this.teleportPosition != null) {
                        return;
                    }
                    movePlayerPacket = (MovePlayerPacket)packet;
                    newPos = new Vector3(movePlayerPacket.x, movePlayerPacket.y - this.getEyeHeight(), movePlayerPacket.z);
                    if (newPos.distanceSquared(this) < 0.01 && (double)(movePlayerPacket.yaw % 360.0f) == this.yaw && (double)(movePlayerPacket.pitch % 360.0f) == this.pitch) {
                        return;
                    }
                    if (newPos.distanceSquared(this) > 100.0) {
                        this.sendPosition(this, movePlayerPacket.yaw, movePlayerPacket.pitch, 1);
                        return;
                    }
                    revert = false;
                    if (!this.isAlive() || !this.spawned) {
                        revert = true;
                        this.forceMovement = new Vector3(this.x, this.y, this.z);
                    }
                    if (this.forceMovement != null && (newPos.distanceSquared(this.forceMovement) > 0.1 || revert)) {
                        this.sendPosition(this.forceMovement, movePlayerPacket.yaw, movePlayerPacket.pitch, 1);
                    } else {
                        movePlayerPacket.yaw %= 360.0f;
                        movePlayerPacket.pitch %= 360.0f;
                        if (movePlayerPacket.yaw < 0.0f) {
                            movePlayerPacket.yaw += 360.0f;
                        }
                        this.setRotation(movePlayerPacket.yaw, movePlayerPacket.pitch);
                        this.newPosition = newPos;
                        this.positionChanged = true;
                        this.forceMovement = null;
                    }
                    if (this.riding == null) return;
                    if (this.riding instanceof EntityBoat == false) return;
                    this.riding.setPositionAndRotation(this.temporalVector.setComponents(movePlayerPacket.x, movePlayerPacket.y - 1.0f, movePlayerPacket.z), (movePlayerPacket.headYaw + 90.0f) % 360.0f, 0.0);
                    return;
                }
                case 55: {
                    adventureSettingsPacket = (AdventureSettingsPacket)packet;
                    if (!this.server.getAllowFlight() && adventureSettingsPacket.getFlag(512) && !this.getAdventureSettings().get(AdventureSettings.Type.ALLOW_FLIGHT)) {
                        this.kick(PlayerKickEvent.Reason.FLYING_DISABLED, "Flying is not enabled on this server");
                        return;
                    }
                    playerToggleFlightEvent = new PlayerToggleFlightEvent(this, adventureSettingsPacket.getFlag(512));
                    this.server.getPluginManager().callEvent(playerToggleFlightEvent);
                    if (playerToggleFlightEvent.isCancelled()) {
                        this.getAdventureSettings().update();
                        return;
                    }
                    this.getAdventureSettings().set(AdventureSettings.Type.FLYING, playerToggleFlightEvent.isFlying());
                    return;
                }
                case 31: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    mobEquipmentPacket = (MobEquipmentPacket)packet;
                    inv = this.getWindowById(mobEquipmentPacket.windowId);
                    if (inv == null) {
                        this.server.getLogger().debug("Player " + this.getName() + " has no open container with window ID " + mobEquipmentPacket.windowId);
                        return;
                    }
                    item = inv.getItem(mobEquipmentPacket.hotbarSlot);
                    if (!item.equals(mobEquipmentPacket.item)) {
                        this.server.getLogger().debug("Tried to equip " + mobEquipmentPacket.item + " but have " + item + " in target slot");
                        inv.sendContents(this);
                        return;
                    }
                    if (inv instanceof PlayerInventory) {
                        ((PlayerInventory)inv).equipItem(mobEquipmentPacket.hotbarSlot);
                    }
                    this.setDataFlag(0, 4, false);
                    return;
                }
                case 36: {
                    playerActionPacket = (PlayerActionPacket)packet;
                    if (this.spawned == false) return;
                    if (!this.isAlive() && playerActionPacket.action != 7 && playerActionPacket.action != 13) {
                        return;
                    }
                    playerActionPacket.entityId = this.id;
                    pos = new Vector3(playerActionPacket.x, playerActionPacket.y, playerActionPacket.z);
                    face = BlockFace.fromIndex(playerActionPacket.face);
                    block89 : switch (playerActionPacket.action) {
                        case 0: {
                            currentBreak = System.currentTimeMillis();
                            currentBreakPosition = new BlockVector3(playerActionPacket.x, playerActionPacket.y, playerActionPacket.z);
                            if (this.lastBreakPosition.equals(currentBreakPosition) && currentBreak - this.lastBreak < 10L || pos.distanceSquared(this) > 100.0) break;
                            target = this.level.getBlock(pos);
                            playerInteractEvent = new PlayerInteractEvent(this, this.inventory.getItemInHand(), target, face, target.getId() == 0 ? PlayerInteractEvent.Action.LEFT_CLICK_AIR : PlayerInteractEvent.Action.LEFT_CLICK_BLOCK);
                            this.getServer().getPluginManager().callEvent(playerInteractEvent);
                            if (playerInteractEvent.isCancelled()) {
                                this.inventory.sendHeldItem(new Player[]{this});
                                break;
                            }
                            switch (target.getId()) {
                                case 25: {
                                    ((BlockNoteblock)target).emitSound();
                                    break block89;
                                }
                                case 122: {
                                    ((BlockDragonEgg)target).teleport();
                                    break block89;
                                }
                                case 449: {
                                    ((BlockLectern)target).dropBook(this);
                                    break;
                                }
                            }
                            block = target.getSide(face);
                            if (block.getId() == 51 || block.getId() == 492) {
                                this.level.setBlock((Vector3)block, Block.get(0), true);
                                this.level.addLevelSoundEvent(block, 65);
                                break;
                            }
                            if (block.getId() == 462 && block.getDamage() == 0) {
                                oldItem = playerInteractEvent.getItem();
                                i = this.level.useBreakOn(block, oldItem, this, true);
                                if (!this.isSurvival()) break;
                                this.getFoodData().updateFoodExpLevel(0.025);
                                if (i.equals(oldItem) && i.getCount() == oldItem.getCount()) break;
                                this.inventory.setItemInHand(i);
                                this.inventory.sendHeldItem(this.getViewers().values());
                                break;
                            }
                            if (!block.isBlockChangeAllowed(this)) break;
                            if (!this.isCreative() && (breakTime = Math.ceil(target.calculateBreakTime(this.inventory.getItemInHand(), this) * 20.0)) > 0.0) {
                                pk = new LevelEventPacket();
                                pk.evid = 3600;
                                pk.x = (float)pos.x;
                                pk.y = (float)pos.y;
                                pk.z = (float)pos.z;
                                pk.data = (int)(65535.0 / breakTime);
                                this.getLevel().addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
                            }
                            this.breakingBlock = target;
                            this.lastBreak = currentBreak;
                            this.lastBreakPosition = currentBreakPosition;
                            break;
                        }
                        case 1: 
                        case 2: {
                            pk = new LevelEventPacket();
                            pk.evid = 3601;
                            pk.x = (float)pos.x;
                            pk.y = (float)pos.y;
                            pk.z = (float)pos.z;
                            pk.data = 0;
                            this.getLevel().addChunkPacket(pos.getFloorX() >> 4, pos.getFloorZ() >> 4, pk);
                            this.breakingBlock = null;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 6: {
                            this.stopSleep();
                            break;
                        }
                        case 7: {
                            if (!this.spawned || this.isAlive() || !this.isOnline()) break;
                            this.respawn();
                            break;
                        }
                        case 8: {
                            playerJumpEvent = new PlayerJumpEvent(this);
                            this.server.getPluginManager().callEvent(playerJumpEvent);
                            return;
                        }
                        case 9: {
                            playerToggleSprintEvent = new PlayerToggleSprintEvent(this, true);
                            this.server.getPluginManager().callEvent(playerToggleSprintEvent);
                            if (playerToggleSprintEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setSprinting(true);
                            return;
                        }
                        case 10: {
                            playerToggleSprintEvent = new PlayerToggleSprintEvent(this, false);
                            this.server.getPluginManager().callEvent(playerToggleSprintEvent);
                            if (playerToggleSprintEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setSprinting(false);
                            return;
                        }
                        case 11: {
                            playerToggleSneakEvent = new PlayerToggleSneakEvent(this, true);
                            this.server.getPluginManager().callEvent(playerToggleSneakEvent);
                            if (playerToggleSneakEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setSneaking(true);
                            return;
                        }
                        case 12: {
                            playerToggleSneakEvent = new PlayerToggleSneakEvent(this, false);
                            this.server.getPluginManager().callEvent(playerToggleSneakEvent);
                            if (playerToggleSneakEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setSneaking(false);
                            return;
                        }
                        case 14: {
                            this.sendPosition(this, this.yaw, this.pitch, 0);
                            break;
                        }
                        case 15: {
                            playerToggleGlideEvent = new PlayerToggleGlideEvent(this, true);
                            this.server.getPluginManager().callEvent(playerToggleGlideEvent);
                            if (playerToggleGlideEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setGliding(true);
                            return;
                        }
                        case 16: {
                            playerToggleGlideEvent = new PlayerToggleGlideEvent(this, false);
                            this.server.getPluginManager().callEvent(playerToggleGlideEvent);
                            if (playerToggleGlideEvent.isCancelled()) {
                                this.sendData(this);
                                return;
                            }
                            this.setGliding(false);
                            return;
                        }
                        case 18: {
                            if (!this.isBreakingBlock()) break;
                            block = this.level.getBlock(pos);
                            this.level.addParticle(new PunchBlockParticle(pos, block, face));
                            break;
                        }
                        case 21: {
                            ptse = new PlayerToggleSwimEvent(this, true);
                            this.server.getPluginManager().callEvent(ptse);
                            if (ptse.isCancelled()) {
                                this.sendData(this);
                                break;
                            }
                            this.setSwimming(true);
                            break;
                        }
                        case 22: {
                            ptse = new PlayerToggleSwimEvent(this, false);
                            this.server.getPluginManager().callEvent(ptse);
                            if (ptse.isCancelled()) {
                                this.sendData(this);
                                break;
                            }
                            this.setSwimming(false);
                            break;
                        }
                    }
                    this.setUsingItem(false);
                    return;
                }
                case 32: {
                    return;
                }
                case 101: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    modalFormPacket = (ModalFormResponsePacket)packet;
                    if (this.formWindows.containsKey(modalFormPacket.formId)) {
                        window = this.formWindows.remove(modalFormPacket.formId);
                        window.setResponse(modalFormPacket.data.trim());
                        event = new PlayerFormRespondedEvent(this, modalFormPacket.formId, window);
                        this.getServer().getPluginManager().callEvent(event);
                        return;
                    }
                    if (this.serverSettings.containsKey(modalFormPacket.formId) == false) return;
                    window = this.serverSettings.get(modalFormPacket.formId);
                    window.setResponse(modalFormPacket.data.trim());
                    event = new PlayerSettingsRespondedEvent(this, modalFormPacket.formId, window);
                    this.getServer().getPluginManager().callEvent(event);
                    if (event.isCancelled() != false) return;
                    if (window instanceof FormWindowCustom == false) return;
                    ((FormWindowCustom)window).setElementsFromResponse();
                    return;
                }
                case 33: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    interactPacket = (InteractPacket)packet;
                    if (interactPacket.action != 4 || interactPacket.target != 0L) {
                        this.craftingType = 0;
                    }
                    if ((targetEntity = this.level.getEntity(interactPacket.target)) == null) return;
                    if (this.isAlive() == false) return;
                    if (!targetEntity.isAlive()) {
                        return;
                    }
                    if (targetEntity instanceof EntityItem || targetEntity instanceof EntityArrow || targetEntity instanceof EntityXPOrb) {
                        this.kick(PlayerKickEvent.Reason.INVALID_PVE, "Attempting to interact with an invalid entity");
                        this.server.getLogger().warning(this.getServer().getLanguage().translateString("nukkit.player.invalidEntity", new String[]{this.getName()}));
                        return;
                    }
                    item = this.inventory.getItemInHand();
                    switch (interactPacket.action) {
                        case 4: {
                            if (interactPacket.target == 0L) {
                                return;
                            }
                            this.getServer().getPluginManager().callEvent(new PlayerMouseOverEntityEvent(this, targetEntity));
                            return;
                        }
                        case 3: {
                            if (targetEntity instanceof EntityRideable == false) return;
                            if (this.riding == null) {
                                return;
                            }
                            ((EntityRideable)this.riding).mountEntity(this);
                            return;
                        }
                        case 6: {
                            if (targetEntity.getId() != this.getId()) {
                                return;
                            }
                            if (this.inventoryOpen != false) return;
                            this.inventory.open(this);
                            this.inventoryOpen = true;
                        }
                    }
                    return;
                }
                case 34: {
                    pickRequestPacket = (BlockPickRequestPacket)packet;
                    block = this.level.getBlock(this.temporalVector.setComponents(pickRequestPacket.x, pickRequestPacket.y, pickRequestPacket.z));
                    item = block.toItem();
                    if (pickRequestPacket.addUserData && (blockEntity = this.getLevel().getBlockEntity(new Vector3(pickRequestPacket.x, pickRequestPacket.y, pickRequestPacket.z))) != null && (nbt = blockEntity.getCleanedNBT()) != null) {
                        item.setCustomBlockData(nbt);
                        item.setLore(new String[]{"+(DATA)"});
                    }
                    pickEvent = new PlayerBlockPickEvent(this, block, item);
                    if (this.isSpectator()) {
                        Player.log.debug("Got block-pick request from " + this.getName() + " when in spectator mode");
                        pickEvent.setCancelled();
                    }
                    this.server.getPluginManager().callEvent(pickEvent);
                    if (pickEvent.isCancelled() != false) return;
                    itemExists = false;
                    itemSlot = -1;
                    for (slot = 0; slot < this.inventory.getSize(); ++slot) {
                        if (!this.inventory.getItem(slot).equals(pickEvent.getItem())) continue;
                        if (slot < this.inventory.getHotbarSize()) {
                            this.inventory.setHeldItemSlot(slot);
                        } else {
                            itemSlot = slot;
                        }
                        itemExists = true;
                        break;
                    }
                    for (slot = 0; slot < this.inventory.getHotbarSize(); ++slot) {
                        if (!this.inventory.getItem(slot).isNull()) continue;
                        if (!itemExists && this.isCreative()) {
                            this.inventory.setHeldItemSlot(slot);
                            this.inventory.setItemInHand(pickEvent.getItem());
                            return;
                        }
                        if (itemSlot <= -1) continue;
                        this.inventory.setHeldItemSlot(slot);
                        this.inventory.setItemInHand(this.inventory.getItem(itemSlot));
                        this.inventory.clear(itemSlot, true);
                        return;
                    }
                    if (!itemExists && this.isCreative()) {
                        itemInHand = this.inventory.getItemInHand();
                        this.inventory.setItemInHand(pickEvent.getItem());
                        if (this.inventory.isFull() != false) return;
                        slot = 0;
                        while (slot < this.inventory.getSize()) {
                            if (this.inventory.getItem(slot).isNull()) {
                                this.inventory.setItem(slot, itemInHand);
                                return;
                            }
                            ++slot;
                        }
                        return;
                    }
                    if (itemSlot <= -1) return;
                    itemInHand = this.inventory.getItemInHand();
                    this.inventory.setItemInHand(this.inventory.getItem(itemSlot));
                    this.inventory.setItem(itemSlot, itemInHand);
                    return;
                }
                case 44: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    animationEvent = new PlayerAnimationEvent(this, ((AnimatePacket)packet).action);
                    this.server.getPluginManager().callEvent(animationEvent);
                    if (animationEvent.isCancelled()) {
                        return;
                    }
                    animation = animationEvent.getAnimationType();
                    switch (2.$SwitchMap$cn$nukkit$network$protocol$AnimatePacket$Action[animation.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (!(this.riding instanceof EntityBoat)) break;
                            ((EntityBoat)this.riding).onPaddle(animation, ((AnimatePacket)packet).rowingTime);
                            break;
                        }
                    }
                    if (animationEvent.getAnimationType() == AnimatePacket.Action.SWING_ARM) {
                        this.setNoShieldTicks(10);
                    }
                    animatePacket = new AnimatePacket();
                    animatePacket.eid = this.getId();
                    animatePacket.action = animationEvent.getAnimationType();
                    Server.broadcastPacket(this.getViewers().values(), (DataPacket)animatePacket);
                    return;
                }
                case 42: {
                    return;
                }
                case 27: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    entityEventPacket = (EntityEventPacket)packet;
                    if (this.craftingType != 2 && entityEventPacket.event != 34) {
                        this.craftingType = 0;
                    }
                    if (entityEventPacket.event != 57) return;
                    if (entityEventPacket.data == 0) return;
                    if (entityEventPacket.eid != this.id) {
                        return;
                    }
                    entityEventPacket.eid = this.id;
                    entityEventPacket.isEncoded = false;
                    this.dataPacket(entityEventPacket);
                    Server.broadcastPacket(this.getViewers().values(), (DataPacket)entityEventPacket);
                    return;
                }
                case 77: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    this.craftingType = 0;
                    commandRequestPacket = (CommandRequestPacket)packet;
                    playerCommandPreprocessEvent = new PlayerCommandPreprocessEvent(this, commandRequestPacket.command);
                    this.server.getPluginManager().callEvent(playerCommandPreprocessEvent);
                    if (playerCommandPreprocessEvent.isCancelled()) {
                        return;
                    }
                    Timings.playerCommandTimer.startTiming();
                    this.server.dispatchCommand(playerCommandPreprocessEvent.getPlayer(), playerCommandPreprocessEvent.getMessage().substring(1));
                    Timings.playerCommandTimer.stopTiming();
                    return;
                }
                case 9: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    textPacket = (TextPacket)packet;
                    if (textPacket.type != 1) return;
                    chatMessage = textPacket.message;
                    breakLine = chatMessage.indexOf(10);
                    if (breakLine != -1) {
                        chatMessage = chatMessage.substring(0, breakLine);
                    }
                    this.chat(chatMessage);
                    return;
                }
                case 47: {
                    containerClosePacket = (ContainerClosePacket)packet;
                    if (this.spawned == false) return;
                    if (containerClosePacket.windowId == 0 && !this.inventoryOpen) {
                        return;
                    }
                    if (this.windowIndex.containsKey(containerClosePacket.windowId)) {
                        this.server.getPluginManager().callEvent(new InventoryCloseEvent((Inventory)this.windowIndex.get(containerClosePacket.windowId), this));
                        if (containerClosePacket.windowId == 0) {
                            this.inventoryOpen = false;
                        }
                        this.removeWindow((Inventory)this.windowIndex.get(containerClosePacket.windowId));
                    }
                    if (containerClosePacket.windowId != -1) return;
                    this.craftingType = 0;
                    this.resetCraftingGridType();
                    this.addWindow(this.craftingGrid, -1);
                    pk = new ContainerClosePacket();
                    pk.wasServerInitiated = false;
                    pk.windowId = -1;
                    this.dataPacket(pk);
                    return;
                }
                case 53: {
                    craftingEventPacket = (CraftingEventPacket)packet;
                    if (this.craftingType != 1 || craftingEventPacket.type != 2) {
                        if (this.craftingType != 0) return;
                        if (craftingEventPacket.type != 0) return;
                    }
                    if (this.craftingTransaction == null) return;
                    this.craftingTransaction.setReadyToExecute(true);
                    if (this.craftingTransaction.getPrimaryOutput() != null) return;
                    this.craftingTransaction.setPrimaryOutput(craftingEventPacket.output[0]);
                    return;
                }
                case 56: {
                    if (this.spawned == false) return;
                    if (!this.isAlive()) {
                        return;
                    }
                    blockEntityDataPacket = (BlockEntityDataPacket)packet;
                    this.craftingType = 0;
                    this.resetCraftingGridType();
                    pos = new Vector3(blockEntityDataPacket.x, blockEntityDataPacket.y, blockEntityDataPacket.z);
                    if (pos.distanceSquared(this) > 10000.0) {
                        return;
                    }
                    t = this.level.getBlockEntity(pos);
                    if (t instanceof BlockEntitySpawnable == false) return;
                    try {
                        nbt = NBTIO.read(blockEntityDataPacket.namedTag, ByteOrder.LITTLE_ENDIAN, true);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (((BlockEntitySpawnable)t).updateCompoundTag(nbt, this) != false) return;
                    ((BlockEntitySpawnable)t).spawnTo(this);
                    return;
                }
                case 69: {
                    requestChunkRadiusPacket = (RequestChunkRadiusPacket)packet;
                    chunkRadiusUpdatePacket = new ChunkRadiusUpdatedPacket();
                    chunkRadiusUpdatePacket.radius = this.chunkRadius = Math.max(3, Math.min(requestChunkRadiusPacket.radius, this.viewDistance));
                    this.dataPacket(chunkRadiusUpdatePacket);
                    return;
                }
                case 62: {
                    setPlayerGameTypePacket = (SetPlayerGameTypePacket)packet;
                    if (setPlayerGameTypePacket.gamemode == this.gamemode) return;
                    if (!this.hasPermission("nukkit.command.gamemode")) {
                        setPlayerGameTypePacket1 = new SetPlayerGameTypePacket();
                        setPlayerGameTypePacket1.gamemode = this.gamemode & 1;
                        this.dataPacket(setPlayerGameTypePacket1);
                        this.getAdventureSettings().update();
                        return;
                    }
                    this.setGamemode(setPlayerGameTypePacket.gamemode, true);
                    Command.broadcastCommandMessage((CommandSender)this, new TranslationContainer("commands.gamemode.success.self", Server.getGamemodeString(this.gamemode)));
                    return;
                }
                case 71: {
                    itemFrameDropItemPacket = (ItemFrameDropItemPacket)packet;
                    vector3 = this.temporalVector.setComponents(itemFrameDropItemPacket.x, itemFrameDropItemPacket.y, itemFrameDropItemPacket.z);
                    blockEntityItemFrame = this.level.getBlockEntity(vector3);
                    itemFrame = (BlockEntityItemFrame)blockEntityItemFrame;
                    if (itemFrame == null) return;
                    block = itemFrame.getBlock();
                    itemDrop = itemFrame.getItem();
                    itemFrameDropItemEvent = new ItemFrameDropItemEvent(this, block, itemFrame, itemDrop);
                    this.server.getPluginManager().callEvent(itemFrameDropItemEvent);
                    if (!itemFrameDropItemEvent.isCancelled()) {
                        if (itemDrop.getId() == 0) return;
                        vector3 = this.temporalVector.setComponents(itemFrame.x + 0.5, itemFrame.y, itemFrame.z + 0.5);
                        this.level.dropItem(vector3, itemDrop);
                        itemFrame.setItem(new ItemBlock(Block.get(0)));
                        itemFrame.setItemRotation(0);
                        this.getLevel().addLevelEvent(this, 1043);
                        return;
                    }
                    itemFrame.spawnTo(this);
                    return;
                }
                case 125: {
                    lecternUpdatePacket = (LecternUpdatePacket)packet;
                    blockPosition = lecternUpdatePacket.blockPosition;
                    this.temporalVector.setComponents(blockPosition.x, blockPosition.y, blockPosition.z);
                    if (lecternUpdatePacket.dropBook) {
                        blockLectern = this.getLevel().getBlock(this.temporalVector);
                        if (blockLectern instanceof BlockLectern == false) return;
                        ((BlockLectern)blockLectern).dropBook(this);
                        return;
                    }
                    blockEntityLectern = this.level.getBlockEntity(this.temporalVector);
                    if (blockEntityLectern instanceof BlockEntityLectern == false) return;
                    lectern = (BlockEntityLectern)blockEntityLectern;
                    lecternPageChangeEvent = new LecternPageChangeEvent(this, lectern, lecternUpdatePacket.page);
                    this.server.getPluginManager().callEvent(lecternPageChangeEvent);
                    if (lecternPageChangeEvent.isCancelled() != false) return;
                    lectern.setRawPage(lecternPageChangeEvent.getNewRawPage());
                    lectern.spawnToAll();
                    blockLectern = lectern.getBlock();
                    if (blockLectern instanceof BlockLectern == false) return;
                    ((BlockLectern)blockLectern).executeRedstonePulse();
                    return;
                }
                case 68: {
                    pk = (MapInfoRequestPacket)packet;
                    mapItem = null;
                    for (Item item1 : this.inventory.getContents().values()) {
                        if (!(item1 instanceof ItemMap) || ((ItemMap)item1).getMapId() != pk.mapId) continue;
                        mapItem = item1;
                    }
                    if (mapItem == null) {
                        for (BlockEntity be : this.level.getBlockEntities().values()) {
                            if (!(be instanceof BlockEntityItemFrame) || !((itemFrame1 = (BlockEntityItemFrame)be).getItem() instanceof ItemMap) || ((ItemMap)itemFrame1.getItem()).getMapId() != pk.mapId) continue;
                            ((ItemMap)itemFrame1.getItem()).sendImage(this);
                            break;
                        }
                    }
                    if (mapItem == null) return;
                    event = new PlayerMapInfoRequestEvent(this, mapItem);
                    this.getServer().getPluginManager().callEvent(event);
                    if (event.isCancelled() != false) return;
                    ((ItemMap)mapItem).sendImage(this);
                    return;
                }
                case 24: 
                case 120: 
                case 123: {
                    if (this.isSpectator()) {
                        if (((LevelSoundEventPacket)packet).sound == 1) return;
                        if (((LevelSoundEventPacket)packet).sound == 42) return;
                    }
                    this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), packet);
                    return;
                }
                case 30: {
                    if (this.isSpectator()) {
                        this.sendAllInventories();
                        return;
                    }
                    transactionPacket = (InventoryTransactionPacket)packet;
                    actions = new ArrayList<InventoryAction>();
                    for (NetworkInventoryAction networkInventoryAction : transactionPacket.actions) {
                        if (this.craftingType == 1001 && this.craftingTransaction != null && networkInventoryAction.sourceType == 99999) {
                            networkInventoryAction.windowId = -4;
                        } else if (this.craftingType == 1002 && this.craftingTransaction != null && transactionPacket.actions.length == 2 && transactionPacket.actions[1].windowId == 124 && networkInventoryAction.inventorySlot == 0) {
                            slot = transactionPacket.actions[1].inventorySlot;
                            if (slot == 50) {
                                networkInventoryAction.windowId = -4;
                            } else {
                                networkInventoryAction.inventorySlot = slot - 12;
                            }
                        }
                        a = networkInventoryAction.createInventoryAction(this);
                        if (a == null) {
                            this.getServer().getLogger().debug("Unmatched inventory action from " + this.getName() + ": " + networkInventoryAction);
                            this.sendAllInventories();
                            return;
                        }
                        actions.add(a);
                    }
                    if (transactionPacket.isCraftingPart) {
                        if (this.craftingTransaction == null) {
                            this.craftingTransaction = new CraftingTransaction(this, actions);
                        } else {
                            for (InventoryAction action : actions) {
                                this.craftingTransaction.addAction(action);
                            }
                        }
                        if (this.craftingTransaction.getPrimaryOutput() == null) return;
                        if (!this.craftingTransaction.isReadyToExecute()) {
                            if (this.craftingTransaction.canExecute() == false) return;
                        }
                        if (this.craftingTransaction.execute()) {
                            sound /* !! */  = null;
                            switch (this.craftingType) {
                                case 1001: {
                                    sound /* !! */  = Sound.BLOCK_STONECUTTER_USE;
                                    break;
                                }
                                case 1000: {
                                    sound /* !! */  = Sound.BLOCK_GRINDSTONE_USE;
                                    break;
                                }
                                case 1002: {
                                    sound /* !! */  = Sound.BLOCK_CARTOGRAPHY_TABLE_USE;
                                    break;
                                }
                            }
                            if (sound /* !! */  != null) {
                                players = this.level.getChunkPlayers(this.getChunkX(), this.getChunkZ()).values();
                                players.remove(this);
                                if (!players.isEmpty()) {
                                    this.level.addSound((Vector3)this, (Sound)sound /* !! */ , 1.0f, 1.0f, players);
                                }
                            }
                        }
                        this.craftingTransaction = null;
                        return;
                    }
                    if (transactionPacket.isEnchantingPart) {
                        if (this.enchantTransaction == null) {
                            this.enchantTransaction = new EnchantTransaction(this, actions);
                        } else {
                            for (InventoryAction action : actions) {
                                this.enchantTransaction.addAction(action);
                            }
                        }
                        if (this.enchantTransaction.canExecute() == false) return;
                        this.enchantTransaction.execute();
                        this.enchantTransaction = null;
                        return;
                    }
                    if (this.craftingTransaction != null) {
                        if (this.craftingTransaction.checkForCraftingPart(actions)) {
                            sound /* !! */  = actions.iterator();
                            while (sound /* !! */ .hasNext() != false) {
                                action = (InventoryAction)sound /* !! */ .next();
                                this.craftingTransaction.addAction(action);
                            }
                            return;
                        }
                        this.server.getLogger().debug("Got unexpected normal inventory action with incomplete crafting transaction from " + this.getName() + ", refusing to execute crafting");
                        this.removeAllWindows(false);
                        this.sendAllInventories();
                        this.craftingTransaction = null;
                    } else if (this.enchantTransaction != null) {
                        if (this.enchantTransaction.checkForEnchantPart(actions)) {
                            sound /* !! */  = actions.iterator();
                            while (sound /* !! */ .hasNext() != false) {
                                action = (InventoryAction)sound /* !! */ .next();
                                this.enchantTransaction.addAction(action);
                            }
                            return;
                        }
                        this.server.getLogger().debug("Got unexpected normal inventory action with incomplete enchanting transaction from " + this.getName() + ", refusing to execute enchant " + transactionPacket.toString());
                        this.removeAllWindows(false);
                        this.sendAllInventories();
                        this.enchantTransaction = null;
                    }
                    switch (transactionPacket.transactionType) {
                        case 0: {
                            transaction = new InventoryTransaction(this, actions);
                            if (transaction.execute() != false) return;
                            this.server.getLogger().debug("Failed to execute inventory transaction from " + this.getName() + " with actions: " + Arrays.toString(transactionPacket.actions));
                            return;
                        }
                        case 1: {
                            if (transactionPacket.actions.length > 0) {
                                this.server.getLogger().debug("Expected 0 actions for mismatch, got " + transactionPacket.actions.length + ", " + Arrays.toString(transactionPacket.actions));
                            }
                            this.sendAllInventories();
                            return;
                        }
                        case 2: {
                            useItemData = (UseItemData)transactionPacket.transactionData;
                            blockVector = useItemData.blockPos;
                            face = useItemData.face;
                            type = useItemData.actionType;
                            switch (type) {
                                case 0: {
                                    spamBug = this.lastRightClickPos != null && (double)System.currentTimeMillis() - this.lastRightClickTime < 100.0 && blockVector.distanceSquared(this.lastRightClickPos) < 1.0E-5;
                                    this.lastRightClickPos = blockVector.asVector3();
                                    this.lastRightClickTime = System.currentTimeMillis();
                                    if (spamBug && this.getInventory().getItemInHand().getBlockId() == 0) {
                                        return;
                                    }
                                    this.setDataFlag(0, 4, false);
                                    if (this.canInteract(blockVector.add(0.5, 0.5, 0.5), this.isCreative() != false ? 13.0 : 7.0)) {
                                        if (this.isCreative()) {
                                            i = this.inventory.getItemInHand();
                                            if (this.level.useItemOn(blockVector.asVector3(), i, face, useItemData.clickPos.x, useItemData.clickPos.y, useItemData.clickPos.z, this) != null) {
                                                return;
                                            }
                                        } else if (this.inventory.getItemInHand().equals(useItemData.itemInHand)) {
                                            i = this.inventory.getItemInHand();
                                            oldItem = i.clone();
                                            i = this.level.useItemOn(blockVector.asVector3(), i, face, useItemData.clickPos.x, useItemData.clickPos.y, useItemData.clickPos.z, this);
                                            if (i != null) {
                                                if (i.equals(oldItem)) {
                                                    if (i.getCount() == oldItem.getCount()) return;
                                                }
                                                this.inventory.setItemInHand(i);
                                                this.inventory.sendHeldItem(this.getViewers().values());
                                                return;
                                            }
                                        }
                                    }
                                    this.inventory.sendHeldItem(new Player[]{this});
                                    if (blockVector.distanceSquared(this) > 10000.0) {
                                        return;
                                    }
                                    target = this.level.getBlock(blockVector.asVector3());
                                    block = target.getSide(face);
                                    this.level.sendBlocks(new Player[]{this}, new Block[]{target, block}, 4);
                                    this.level.sendBlocks(new Player[]{this}, (Vector3[])new Block[]{target.getLevelBlockAtLayer(1), block.getLevelBlockAtLayer(1)}, 4, 1);
                                    return;
                                }
                                case 2: {
                                    if (this.spawned == false) return;
                                    if (!this.isAlive()) {
                                        return;
                                    }
                                    this.resetCraftingGridType();
                                    i = this.getInventory().getItemInHand();
                                    oldItem = i.clone();
                                    if (this.canInteract(blockVector.add(0.5, 0.5, 0.5), this.isCreative() != false ? 13.0 : 7.0) && (i = this.level.useBreakOn(blockVector.asVector3(), face, i, this, true)) != null) {
                                        if (this.isSurvival() == false) return;
                                        this.getFoodData().updateFoodExpLevel(0.025);
                                        if (i.equals(oldItem)) {
                                            if (i.getCount() == oldItem.getCount()) return;
                                        }
                                        this.inventory.setItemInHand(i);
                                        this.inventory.sendHeldItem(this.getViewers().values());
                                        return;
                                    }
                                    this.inventory.sendContents(this);
                                    target = this.level.getBlock(blockVector.asVector3());
                                    blockEntity = this.level.getBlockEntity(blockVector.asVector3());
                                    this.level.sendBlocks(new Player[]{this}, new Block[]{target}, 11);
                                    this.inventory.sendHeldItem(new Player[]{this});
                                    if (blockEntity instanceof BlockEntitySpawnable == false) return;
                                    ((BlockEntitySpawnable)blockEntity).spawnTo(this);
                                    return;
                                }
                                case 1: {
                                    directionVector = this.getDirectionVector();
                                    if (this.isCreative()) {
                                        item = this.inventory.getItemInHand();
                                    } else {
                                        if (!this.inventory.getItemInHand().equals(useItemData.itemInHand)) {
                                            this.inventory.sendHeldItem(new Player[]{this});
                                            return;
                                        }
                                        item = this.inventory.getItemInHand();
                                    }
                                    interactEvent = new PlayerInteractEvent(this, item, directionVector, face, PlayerInteractEvent.Action.RIGHT_CLICK_AIR);
                                    this.server.getPluginManager().callEvent(interactEvent);
                                    if (interactEvent.isCancelled()) {
                                        this.inventory.sendHeldItem(new Player[]{this});
                                        return;
                                    }
                                    if (item.onClickAir(this, directionVector) == false) return;
                                    if (!this.isCreative()) {
                                        this.inventory.setItemInHand(item);
                                    }
                                    if (!this.isUsingItem()) {
                                        this.setUsingItem(true);
                                        return;
                                    }
                                    ticksUsed = this.server.getTick() - this.startAction;
                                    this.setUsingItem(false);
                                    if (item.onUse(this, ticksUsed) != false) return;
                                    this.inventory.sendContents(this);
                                    return;
                                }
                            }
                            return;
                        }
                        case 3: {
                            useItemOnEntityData = (UseItemOnEntityData)transactionPacket.transactionData;
                            target = this.level.getEntity(useItemOnEntityData.entityRuntimeId);
                            if (target == null) {
                                return;
                            }
                            type = useItemOnEntityData.actionType;
                            if (!useItemOnEntityData.itemInHand.equalsExact(this.inventory.getItemInHand())) {
                                this.inventory.sendHeldItem(new Player[]{this});
                            }
                            item = this.inventory.getItemInHand();
                            switch (type) {
                                case 0: {
                                    playerInteractEntityEvent = new PlayerInteractEntityEvent(this, target, item, useItemOnEntityData.clickPos);
                                    if (this.isSpectator()) {
                                        playerInteractEntityEvent.setCancelled();
                                    }
                                    this.getServer().getPluginManager().callEvent(playerInteractEntityEvent);
                                    if (playerInteractEntityEvent.isCancelled()) {
                                        return;
                                    }
                                    if (target.onInteract(this, item, useItemOnEntityData.clickPos) == false) return;
                                    if (this.isSurvival() == false) return;
                                    if (item.isTool()) {
                                        if (item.useOn(target) && item.getDamage() >= item.getMaxDurability()) {
                                            this.level.addSound(this, Sound.RANDOM_BREAK);
                                            item = new ItemBlock(Block.get(0));
                                        }
                                    } else if (item.count > 1) {
                                        --item.count;
                                    } else {
                                        item = new ItemBlock(Block.get(0));
                                    }
                                    this.inventory.setItemInHand(item);
                                    return;
                                }
                                case 1: {
                                    itemDamage = item.getAttackDamage();
                                    for (Enchantment enchantment : item.getEnchantments()) {
                                        itemDamage = (float)((double)itemDamage + enchantment.getDamageBonus(target));
                                    }
                                    damage = new EnumMap<EntityDamageEvent.DamageModifier, Float>(EntityDamageEvent.DamageModifier.class);
                                    damage.put(EntityDamageEvent.DamageModifier.BASE, Float.valueOf(itemDamage));
                                    if (!this.canInteract(target, this.isCreative() != false ? 8.0 : 5.0)) {
                                        return;
                                    }
                                    if (target instanceof Player) {
                                        if ((((Player)target).getGamemode() & 1) > 0) {
                                            return;
                                        }
                                        if (this.server.getPropertyBoolean("pvp") == false) return;
                                        if (this.server.getDifficulty() == 0) {
                                            return;
                                        }
                                    }
                                    entityDamageByEntityEvent = new EntityDamageByEntityEvent((Entity)this, target, EntityDamageEvent.DamageCause.ENTITY_ATTACK, damage);
                                    if (this.isSpectator()) {
                                        entityDamageByEntityEvent.setCancelled();
                                    }
                                    if (target instanceof Player && !this.level.getGameRules().getBoolean(GameRule.PVP)) {
                                        entityDamageByEntityEvent.setCancelled();
                                    }
                                    if (target instanceof EntityLiving) {
                                        ((EntityLiving)target).preAttack(this);
                                    }
                                    try {
                                        if (!target.attack(entityDamageByEntityEvent)) {
                                            if (item.isTool() && this.isSurvival()) {
                                                this.inventory.sendContents(this);
                                            }
                                        }
                                        ** GOTO lbl979
                                    }
                                    catch (Throwable var74_201) {
                                        if (target instanceof EntityLiving == false) throw var74_201;
                                        ((EntityLiving)target).postAttack(this);
                                        throw var74_201;
                                    }
                                    if (target instanceof EntityLiving == false) return;
                                    ((EntityLiving)target).postAttack(this);
                                    return;
lbl979:
                                    // 1 sources

                                    if (target instanceof EntityLiving) {
                                        ((EntityLiving)target).postAttack(this);
                                    }
                                    for (Enchantment enchantment : item.getEnchantments()) {
                                        enchantment.doPostAttack(this, target);
                                    }
                                    if (item.isTool() == false) return;
                                    if (this.isSurvival() == false) return;
                                    if (item.useOn(target) && item.getDamage() >= item.getMaxDurability()) {
                                        this.level.addSound(this, Sound.RANDOM_BREAK);
                                        this.inventory.setItemInHand(new ItemBlock(Block.get(0)));
                                        return;
                                    }
                                    this.inventory.setItemInHand(item);
                                    return;
                                }
                            }
                            return;
                        }
                        case 4: {
                            if (this.isSpectator()) {
                                this.sendAllInventories();
                                return;
                            }
                            releaseItemData = (ReleaseItemData)transactionPacket.transactionData;
                            try {
                                type = releaseItemData.actionType;
                                switch (type) {
                                    case 0: {
                                        if (!this.isUsingItem()) {
                                            this.inventory.sendContents(this);
                                            return;
                                        }
                                        item = this.inventory.getItemInHand();
                                        if (!item.onRelease(this, ticksUsed = this.server.getTick() - this.startAction)) {
                                            this.inventory.sendContents(this);
                                        }
                                        this.setUsingItem(false);
                                        return;
                                    }
                                    case 1: {
                                        Player.log.debug("Unexpected release item action consume from {}", new Supplier[]{(Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((Player)this)});
                                        return;
                                    }
                                }
                                return;
                            }
                            finally {
                                this.setUsingItem(false);
                            }
                        }
                    }
                    this.inventory.sendContents(this);
                    return;
                }
                case 48: {
                    hotbarPacket = (PlayerHotbarPacket)packet;
                    if (hotbarPacket.windowId != 0) {
                        return;
                    }
                    this.inventory.equipItem(hotbarPacket.selectedHotbarSlot);
                    return;
                }
                case 102: {
                    settingsRequestEvent = new PlayerServerSettingsRequestEvent(this, new HashMap<Integer, FormWindow>(this.serverSettings));
                    this.getServer().getPluginManager().callEvent(settingsRequestEvent);
                    if (settingsRequestEvent.isCancelled() != false) return;
                    settingsRequestEvent.getSettings().forEach((BiConsumer<Integer, FormWindow>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handleDataPacket$4(java.lang.Integer cn.nukkit.form.window.FormWindow ), (Ljava/lang/Integer;Lcn/nukkit/form/window/FormWindow;)V)((Player)this));
                    return;
                }
                case 45: {
                    if (this.isAlive()) {
                        return;
                    }
                    respawnPacket = (RespawnPacket)packet;
                    if (respawnPacket.respawnState != 2) return;
                    respawn1 = new RespawnPacket();
                    respawn1.x = (float)this.getX();
                    respawn1.y = (float)this.getY();
                    respawn1.z = (float)this.getZ();
                    respawn1.respawnState = 1;
                    this.dataPacket(respawn1);
                    return;
                }
                case 97: {
                    bookEditPacket = (BookEditPacket)packet;
                    oldBook = this.inventory.getItem(bookEditPacket.inventorySlot);
                    if (oldBook.getId() != 386) {
                        return;
                    }
                    if (bookEditPacket.text.length() > 256) {
                        return;
                    }
                    newBook = oldBook.clone();
                    switch (2.$SwitchMap$cn$nukkit$network$protocol$BookEditPacket$Action[bookEditPacket.action.ordinal()]) {
                        case 1: {
                            success = ((ItemBookAndQuill)newBook).setPageText(bookEditPacket.pageNumber, bookEditPacket.text);
                            break;
                        }
                        case 2: {
                            success = ((ItemBookAndQuill)newBook).insertPage(bookEditPacket.pageNumber, bookEditPacket.text);
                            break;
                        }
                        case 3: {
                            success = ((ItemBookAndQuill)newBook).deletePage(bookEditPacket.pageNumber);
                            break;
                        }
                        case 4: {
                            success = ((ItemBookAndQuill)newBook).swapPages(bookEditPacket.pageNumber, bookEditPacket.secondaryPageNumber);
                            break;
                        }
                        case 5: {
                            newBook = Item.get(387, 0, 1, oldBook.getCompoundTag());
                            success = ((ItemBookWritten)newBook).signBook(bookEditPacket.title, bookEditPacket.author, bookEditPacket.xuid, 0);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    if (success == false) return;
                    editBookEvent = new PlayerEditBookEvent(this, oldBook, newBook, bookEditPacket.action);
                    this.server.getPluginManager().callEvent(editBookEvent);
                    if (editBookEvent.isCancelled() != false) return;
                    this.inventory.setItem(bookEditPacket.inventorySlot, editBookEvent.getNewBook());
                    return;
                }
                case -102: {
                    posTrackReq = (PositionTrackingDBClientRequestPacket)packet;
                    try {
                        positionTracking = this.server.getPositionTrackingService().startTracking(this, posTrackReq.getTrackingId(), true);
                        if (positionTracking != null) {
                            return;
                        }
                    }
                    catch (IOException e) {
                        Player.log.warn("Failed to track the trackingHandler " + posTrackReq.getTrackingId(), (Throwable)e);
                    }
                    notFound = new PositionTrackingDBServerBroadcastPacket();
                    notFound.setAction(PositionTrackingDBServerBroadcastPacket.Action.NOT_FOUND);
                    notFound.setTrackingId(posTrackReq.getTrackingId());
                    this.dataPacket(notFound);
                    return;
                }
            }
            return;
        }
        catch (Throwable var4_6) {
            var3_3 = var4_6;
            throw var4_6;
        }
        finally {
            if (timing != null) {
                if (var3_3 != null) {
                    try {
                        timing.close();
                    }
                    catch (Throwable var5_7) {
                        var3_3.addSuppressed(var5_7);
                    }
                } else {
                    timing.close();
                }
            }
        }
    }

    public boolean chat(String message) {
        if (!this.spawned || !this.isAlive()) {
            return false;
        }
        this.resetCraftingGridType();
        this.craftingType = 0;
        if (this.removeFormat) {
            message = TextFormat.clean(message, true);
        }
        for (String msg : message.split("\n")) {
            if (msg.trim().isEmpty() || msg.length() > 255 || this.messageCounter-- <= 0) continue;
            PlayerChatEvent chatEvent = new PlayerChatEvent(this, msg);
            this.server.getPluginManager().callEvent(chatEvent);
            if (chatEvent.isCancelled()) continue;
            this.server.broadcastMessage(this.getServer().getLanguage().translateString(chatEvent.getFormat(), new String[]{chatEvent.getPlayer().getDisplayName(), chatEvent.getMessage()}), chatEvent.getRecipients());
        }
        return true;
    }

    public boolean kick() {
        return this.kick("");
    }

    public boolean kick(String reason, boolean isAdmin) {
        return this.kick(PlayerKickEvent.Reason.UNKNOWN, reason, isAdmin);
    }

    public boolean kick(String reason) {
        return this.kick(PlayerKickEvent.Reason.UNKNOWN, reason);
    }

    public boolean kick(PlayerKickEvent.Reason reason) {
        return this.kick(reason, true);
    }

    public boolean kick(PlayerKickEvent.Reason reason, String reasonString) {
        return this.kick(reason, reasonString, true);
    }

    public boolean kick(PlayerKickEvent.Reason reason, boolean isAdmin) {
        return this.kick(reason, reason.toString(), isAdmin);
    }

    public boolean kick(PlayerKickEvent.Reason reason, String reasonString, boolean isAdmin) {
        PlayerKickEvent ev = new PlayerKickEvent(this, reason, (TextContainer)this.getLeaveMessage());
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            String message = isAdmin ? (!this.isBanned() ? "Kicked by admin." + (!reasonString.isEmpty() ? " Reason: " + reasonString : "") : reasonString) : (reasonString.isEmpty() ? "disconnectionScreen.noReason" : reasonString);
            this.close(ev.getQuitMessage(), message);
            return true;
        }
        return false;
    }

    public void setViewDistance(int distance) {
        this.chunkRadius = distance;
        ChunkRadiusUpdatedPacket pk = new ChunkRadiusUpdatedPacket();
        pk.radius = distance;
        this.dataPacket(pk);
    }

    public int getViewDistance() {
        return this.chunkRadius;
    }

    @Override
    public void sendMessage(String message) {
        TextPacket pk = new TextPacket();
        pk.type = 0;
        pk.message = this.server.getLanguage().translateString(message);
        this.dataPacket(pk);
    }

    @Override
    public void sendMessage(TextContainer message) {
        if (message instanceof TranslationContainer) {
            this.sendTranslation(message.getText(), ((TranslationContainer)message).getParameters());
            return;
        }
        this.sendMessage(message.getText());
    }

    public void sendTranslation(String message) {
        this.sendTranslation(message, EmptyArrays.EMPTY_STRINGS);
    }

    public void sendTranslation(String message, String[] parameters) {
        TextPacket pk = new TextPacket();
        if (!this.server.isLanguageForced()) {
            pk.type = (byte)2;
            pk.message = this.server.getLanguage().translateString(message, parameters, "nukkit.");
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.server.getLanguage().translateString(parameters[i], parameters, "nukkit.");
            }
            pk.parameters = parameters;
        } else {
            pk.type = 0;
            pk.message = this.server.getLanguage().translateString(message, parameters);
        }
        this.dataPacket(pk);
    }

    public void sendChat(String message) {
        this.sendChat("", message);
    }

    public void sendChat(String source, String message) {
        TextPacket pk = new TextPacket();
        pk.type = 1;
        pk.source = source;
        pk.message = this.server.getLanguage().translateString(message);
        this.dataPacket(pk);
    }

    public void sendPopup(String message) {
        this.sendPopup(message, "");
    }

    public void sendPopup(String message, String subtitle) {
        TextPacket pk = new TextPacket();
        pk.type = (byte)3;
        pk.message = message;
        this.dataPacket(pk);
    }

    public void sendTip(String message) {
        TextPacket pk = new TextPacket();
        pk.type = (byte)5;
        pk.message = message;
        this.dataPacket(pk);
    }

    public void clearTitle() {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 0;
        this.dataPacket(pk);
    }

    public void resetTitleSettings() {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 1;
        this.dataPacket(pk);
    }

    public void setSubtitle(String subtitle) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 3;
        pk.text = subtitle;
        this.dataPacket(pk);
    }

    public void setTitleAnimationTimes(int fadein, int duration, int fadeout) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 5;
        pk.fadeInTime = fadein;
        pk.stayTime = duration;
        pk.fadeOutTime = fadeout;
        this.dataPacket(pk);
    }

    private void setTitle(String text) {
        SetTitlePacket packet = new SetTitlePacket();
        packet.text = text;
        packet.type = 2;
        this.dataPacket(packet);
    }

    public void sendTitle(String title) {
        this.sendTitle(title, null, 20, 20, 5);
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 20, 20, 5);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.setTitleAnimationTimes(fadeIn, stay, fadeOut);
        if (!Strings.isNullOrEmpty(subtitle)) {
            this.setSubtitle(subtitle);
        }
        this.setTitle(Strings.isNullOrEmpty(title) ? " " : title);
    }

    public void sendActionBar(String title) {
        this.sendActionBar(title, 1, 0, 1);
    }

    public void sendActionBar(String title, int fadein, int duration, int fadeout) {
        SetTitlePacket pk = new SetTitlePacket();
        pk.type = 4;
        pk.text = title;
        pk.fadeInTime = fadein;
        pk.stayTime = duration;
        pk.fadeOutTime = fadeout;
        this.dataPacket(pk);
    }

    @Override
    public void close() {
        this.close("");
    }

    public void close(String message) {
        this.close(message, "generic");
    }

    public void close(String message, String reason) {
        this.close(message, reason, true);
    }

    public void close(String message, String reason, boolean notify) {
        this.close(new TextContainer(message), reason, notify);
    }

    public void close(TextContainer message) {
        this.close(message, "generic");
    }

    public void close(TextContainer message, String reason) {
        this.close(message, reason, true);
    }

    public void close(TextContainer message, String reason, boolean notify) {
        if (this.connected && !this.closed) {
            if (notify && reason.length() > 0) {
                DisconnectPacket pk = new DisconnectPacket();
                pk.message = reason;
                this.directDataPacket(pk);
            }
            this.connected = false;
            PlayerQuitEvent ev = null;
            if (this.getName() != null && this.getName().length() > 0) {
                ev = new PlayerQuitEvent(this, message, true, reason);
                this.server.getPluginManager().callEvent(ev);
                if (this.fishing != null) {
                    this.stopFishing(false);
                }
            }
            this.removeAllWindows(false);
            this.resetCraftingGridType();
            if (ev != null && this.loggedIn && ev.getAutoSave()) {
                this.save();
            }
            for (Player player : new ArrayList<Player>(this.server.getOnlinePlayers().values())) {
                if (player.canSee(this)) continue;
                player.showPlayer(this);
            }
            this.hiddenPlayers.clear();
            this.removeAllWindows(true);
            Iterator<Object> iterator = new ArrayList<Long>(this.usedChunks.keySet()).iterator();
            while (iterator.hasNext()) {
                long index = (Long)iterator.next();
                int chunkX = Level.getHashX(index);
                int chunkZ = Level.getHashZ(index);
                this.level.unregisterChunkLoader(this, chunkX, chunkZ);
                this.usedChunks.remove(index);
                for (Entity entity : this.level.getChunkEntities(chunkX, chunkZ).values()) {
                    if (entity == this) continue;
                    entity.getViewers().remove(this.getLoaderId());
                }
            }
            super.close();
            this.interfaz.close(this, notify ? reason : "");
            if (this.loggedIn) {
                this.server.removeOnlinePlayer(this);
            }
            this.loggedIn = false;
            if (ev != null && !Objects.equals(this.username, "") && this.spawned && !Objects.equals(ev.getQuitMessage().toString(), "")) {
                this.server.broadcastMessage(ev.getQuitMessage());
            }
            this.server.getPluginManager().unsubscribeFromPermission("nukkit.broadcast.user", this);
            this.spawned = false;
            this.server.getLogger().info(this.getServer().getLanguage().translateString("nukkit.player.logOut", (Object)((Object)TextFormat.AQUA) + (this.getName() == null ? "" : this.getName()) + (Object)((Object)TextFormat.WHITE), this.getAddress(), String.valueOf(this.getPort()), this.getServer().getLanguage().translateString(reason)));
            this.windows.clear();
            this.usedChunks.clear();
            this.loadQueue.clear();
            this.hasSpawned.clear();
            this.spawnPosition = null;
            if (this.riding instanceof EntityRideable) {
                this.riding.passengers.remove(this);
            }
            this.riding = null;
        }
        if (this.perm != null) {
            this.perm.clearPermissions();
            this.perm = null;
        }
        if (this.inventory != null) {
            this.inventory = null;
        }
        this.chunk = null;
        this.server.removePlayer(this);
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean async) {
        if (this.closed) {
            throw new IllegalStateException("Tried to save closed player");
        }
        super.saveNBT();
        if (this.level != null) {
            this.namedTag.putString("Level", this.level.getFolderName());
            if (this.spawnPosition != null && this.spawnPosition.getLevel() != null) {
                this.namedTag.putString("SpawnLevel", this.spawnPosition.getLevel().getFolderName());
                this.namedTag.putInt("SpawnX", (int)this.spawnPosition.x);
                this.namedTag.putInt("SpawnY", (int)this.spawnPosition.y);
                this.namedTag.putInt("SpawnZ", (int)this.spawnPosition.z);
            }
            CompoundTag achievements = new CompoundTag();
            for (String achievement : this.achievements) {
                achievements.putByte(achievement, 1);
            }
            this.namedTag.putCompound("Achievements", achievements);
            this.namedTag.putInt("playerGameType", this.gamemode);
            this.namedTag.putLong("lastPlayed", System.currentTimeMillis() / 1000L);
            this.namedTag.putString("lastIP", this.getAddress());
            this.namedTag.putInt("EXP", this.getExperience());
            this.namedTag.putInt("expLevel", this.getExperienceLevel());
            this.namedTag.putInt("foodLevel", this.getFoodData().getLevel());
            this.namedTag.putFloat("foodSaturationLevel", this.getFoodData().getFoodSaturationLevel());
            this.namedTag.putInt("TimeSinceRest", this.timeSinceRest);
            if (!this.username.isEmpty() && this.namedTag != null) {
                this.server.saveOfflinePlayerData(this.uuid, this.namedTag, async);
            }
        }
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public void kill() {
        if (!this.spawned) {
            return;
        }
        boolean showMessages = this.level.getGameRules().getBoolean(GameRule.SHOW_DEATH_MESSAGE);
        String message = "";
        ArrayList<String> params = new ArrayList<String>();
        EntityDamageEvent cause = this.getLastDamageCause();
        if (showMessages) {
            params.add(this.getDisplayName());
            switch (cause == null ? EntityDamageEvent.DamageCause.CUSTOM : cause.getCause()) {
                case ENTITY_ATTACK: {
                    Entity e;
                    if (!(cause instanceof EntityDamageByEntityEvent)) break;
                    this.killer = e = ((EntityDamageByEntityEvent)cause).getDamager();
                    if (e instanceof Player) {
                        message = "death.attack.player";
                        params.add(((Player)e).getDisplayName());
                        break;
                    }
                    if (e instanceof EntityLiving) {
                        message = "death.attack.mob";
                        params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                        break;
                    }
                    params.add("Unknown");
                    break;
                }
                case PROJECTILE: {
                    Entity e;
                    if (!(cause instanceof EntityDamageByEntityEvent)) break;
                    this.killer = e = ((EntityDamageByEntityEvent)cause).getDamager();
                    if (e instanceof Player) {
                        message = "death.attack.arrow";
                        params.add(((Player)e).getDisplayName());
                        break;
                    }
                    if (e instanceof EntityLiving) {
                        message = "death.attack.arrow";
                        params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                        break;
                    }
                    params.add("Unknown");
                    break;
                }
                case VOID: {
                    message = "death.attack.outOfWorld";
                    break;
                }
                case FALL: {
                    if (cause.getFinalDamage() > 2.0f) {
                        message = "death.fell.accident.generic";
                        break;
                    }
                    message = "death.attack.fall";
                    break;
                }
                case SUFFOCATION: {
                    message = "death.attack.inWall";
                    break;
                }
                case LAVA: {
                    Block block = this.level.getBlock(new Vector3(this.x, this.y - 1.0, this.z));
                    if (block.getId() == 213) {
                        message = "death.attack.lava.magma";
                        break;
                    }
                    message = "death.attack.lava";
                    break;
                }
                case FIRE: {
                    message = "death.attack.onFire";
                    break;
                }
                case FIRE_TICK: {
                    message = "death.attack.inFire";
                    break;
                }
                case DROWNING: {
                    message = "death.attack.drown";
                    break;
                }
                case CONTACT: {
                    if (!(cause instanceof EntityDamageByBlockEvent) || ((EntityDamageByBlockEvent)cause).getDamager().getId() != 81) break;
                    message = "death.attack.cactus";
                    break;
                }
                case BLOCK_EXPLOSION: 
                case ENTITY_EXPLOSION: {
                    if (cause instanceof EntityDamageByEntityEvent) {
                        Item[] e = ((EntityDamageByEntityEvent)cause).getDamager();
                        this.killer = e;
                        if (e instanceof Player) {
                            message = "death.attack.explosion.player";
                            params.add(((Player)e).getDisplayName());
                            break;
                        }
                        if (e instanceof EntityLiving) {
                            message = "death.attack.explosion.player";
                            params.add(!Objects.equals(e.getNameTag(), "") ? e.getNameTag() : e.getName());
                            break;
                        }
                        message = "death.attack.explosion";
                        break;
                    }
                    message = "death.attack.explosion";
                    break;
                }
                case MAGIC: {
                    message = "death.attack.magic";
                    break;
                }
                case LIGHTNING: {
                    message = "death.attack.lightningBolt";
                    break;
                }
                case HUNGER: {
                    message = "death.attack.starve";
                    break;
                }
                default: {
                    message = "death.attack.generic";
                }
            }
        }
        PlayerDeathEvent ev = new PlayerDeathEvent(this, this.getDrops(), new TranslationContainer(message, params.toArray(EmptyArrays.EMPTY_STRINGS)), this.expLevel);
        ev.setKeepExperience(this.level.gameRules.getBoolean(GameRule.KEEP_INVENTORY));
        ev.setKeepInventory(ev.getKeepExperience());
        this.server.getPluginManager().callEvent(ev);
        if (!ev.isCancelled()) {
            if (this.fishing != null) {
                this.stopFishing(false);
            }
            this.health = 0.0f;
            this.extinguish();
            this.scheduleUpdate();
            if (!ev.getKeepInventory() && this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                for (Item item : ev.getDrops()) {
                    if (item.hasEnchantment(28)) continue;
                    this.level.dropItem(this, item, null, true, 40);
                }
                if (this.inventory != null) {
                    this.inventory.clearAll();
                }
                if (this.offhandInventory != null) {
                    this.offhandInventory.clearAll();
                }
            }
            if (!ev.getKeepExperience() && this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                if (this.isSurvival() || this.isAdventure()) {
                    int exp = ev.getExperience() * 7;
                    if (exp > 100) {
                        exp = 100;
                    }
                    this.getLevel().dropExpOrb(this, exp);
                }
                this.setExperience(0, 0);
            }
            this.timeSinceRest = 0;
            if (showMessages && !ev.getDeathMessage().toString().isEmpty()) {
                this.server.broadcast(ev.getDeathMessage(), "nukkit.broadcast.user");
            }
            RespawnPacket pk = new RespawnPacket();
            Position pos = this.getSpawn();
            pk.x = (float)pos.x;
            pk.y = (float)pos.y;
            pk.z = (float)pos.z;
            pk.respawnState = 0;
            this.dataPacket(pk);
        }
    }

    protected void respawn() {
        if (this.server.isHardcore()) {
            this.setBanned(true);
            return;
        }
        this.craftingType = 0;
        this.resetCraftingGridType();
        PlayerRespawnEvent playerRespawnEvent = new PlayerRespawnEvent(this, this.getSpawn());
        this.server.getPluginManager().callEvent(playerRespawnEvent);
        Position respawnPos = playerRespawnEvent.getRespawnPosition();
        this.sendExperience();
        this.sendExperienceLevel();
        this.setSprinting(false);
        this.setSneaking(false);
        this.setDataProperty(new ShortEntityData(7, 400), false);
        this.deadTicks = 0;
        this.noDamageTicks = 60;
        this.removeAllEffects();
        this.setHealth(this.getMaxHealth());
        this.getFoodData().setLevel(20, 20.0f);
        this.sendData(this);
        this.setMovementSpeed(0.1f);
        this.getAdventureSettings().update();
        this.inventory.sendContents(this);
        this.inventory.sendArmorContents(this);
        this.offhandInventory.sendContents(this);
        this.teleport(respawnPos, null);
        this.spawnToAll();
        this.scheduleUpdate();
    }

    @Override
    public void setHealth(float health) {
        if (health < 1.0f) {
            health = 0.0f;
        }
        super.setHealth(health);
        Attribute attr = Attribute.getAttribute(4).setMaxValue(this.getAbsorption() % 2.0f != 0.0f ? (float)(this.getMaxHealth() + 1) : (float)this.getMaxHealth()).setValue(health > 0.0f ? (health < (float)this.getMaxHealth() ? health : (float)this.getMaxHealth()) : 0.0f);
        if (this.spawned) {
            UpdateAttributesPacket pk = new UpdateAttributesPacket();
            pk.entries = new Attribute[]{attr};
            pk.entityId = this.id;
            this.dataPacket(pk);
        }
    }

    @Override
    public void setMaxHealth(int maxHealth) {
        super.setMaxHealth(maxHealth);
        Attribute attr = Attribute.getAttribute(4).setMaxValue(this.getAbsorption() % 2.0f != 0.0f ? (float)(this.getMaxHealth() + 1) : (float)this.getMaxHealth()).setValue(this.health > 0.0f ? (this.health < (float)this.getMaxHealth() ? this.health : (float)this.getMaxHealth()) : 0.0f);
        if (this.spawned) {
            UpdateAttributesPacket pk = new UpdateAttributesPacket();
            pk.entries = new Attribute[]{attr};
            pk.entityId = this.id;
            this.dataPacket(pk);
        }
    }

    public int getExperience() {
        return this.exp;
    }

    public int getExperienceLevel() {
        return this.expLevel;
    }

    public void addExperience(int add) {
        this.addExperience(add, false);
    }

    public void addExperience(int add, boolean playLevelUpSound) {
        int added;
        if (add == 0) {
            return;
        }
        int now = this.getExperience();
        int level = this.getExperienceLevel();
        int most = Player.calculateRequireExperience(level);
        for (added = now + add; added >= most; added -= most) {
            most = Player.calculateRequireExperience(++level);
        }
        this.setExperience(added, level, playLevelUpSound);
    }

    public static int calculateRequireExperience(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public void setExperience(int exp) {
        this.setExperience(exp, this.getExperienceLevel());
    }

    public void setExperience(int exp, int level) {
        this.setExperience(exp, level, false);
    }

    public void setExperience(int exp, int level, boolean playLevelUpSound) {
        int levelBefore = this.expLevel;
        this.exp = exp;
        this.expLevel = level;
        this.sendExperienceLevel(level);
        this.sendExperience(exp);
        if (playLevelUpSound && levelBefore < level && levelBefore / 5 != level / 5 && this.lastPlayerdLevelUpSoundTime < this.age - 100) {
            this.lastPlayerdLevelUpSoundTime = this.age;
            this.level.addLevelSoundEvent((Vector3)this, 62, Math.min(7, level / 5) << 28, "", false, false);
        }
    }

    public void sendExperience() {
        this.sendExperience(this.getExperience());
    }

    public void sendExperience(int exp) {
        if (this.spawned) {
            float percent = (float)exp / (float)Player.calculateRequireExperience(this.getExperienceLevel());
            percent = Math.max(0.0f, Math.min(1.0f, percent));
            this.setAttribute(Attribute.getAttribute(10).setValue(percent));
        }
    }

    public void sendExperienceLevel() {
        this.sendExperienceLevel(this.getExperienceLevel());
    }

    public void sendExperienceLevel(int level) {
        if (this.spawned) {
            this.setAttribute(Attribute.getAttribute(9).setValue(level));
        }
    }

    public void setAttribute(Attribute attribute) {
        UpdateAttributesPacket pk = new UpdateAttributesPacket();
        pk.entries = new Attribute[]{attribute};
        pk.entityId = this.id;
        this.dataPacket(pk);
    }

    @Override
    public void setMovementSpeed(float speed) {
        this.setMovementSpeed(speed, true);
    }

    public void setMovementSpeed(float speed, boolean send) {
        super.setMovementSpeed(speed);
        if (this.spawned && send) {
            Attribute attribute = Attribute.getAttribute(5).setValue(speed);
            this.setAttribute(attribute);
        }
    }

    public Entity getKiller() {
        return this.killer;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (!this.isAlive()) {
            return false;
        }
        if (this.isSpectator() || this.isCreative() && source.getCause() != EntityDamageEvent.DamageCause.SUICIDE) {
            return false;
        }
        if (this.getAdventureSettings().get(AdventureSettings.Type.ALLOW_FLIGHT) && source.getCause() == EntityDamageEvent.DamageCause.FALL) {
            return false;
        }
        if (source.getCause() == EntityDamageEvent.DamageCause.FALL && this.getLevel().getBlock(this.getPosition().floor().add(0.5, -1.0, 0.5)).getId() == 165 && !this.isSneaking()) {
            this.resetFallDistance();
            return false;
        }
        if (super.attack(source)) {
            if (this.getLastDamageCause() == source && this.spawned) {
                Entity damager;
                if (source instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)source).getDamager()) instanceof Player) {
                    ((Player)damager).getFoodData().updateFoodExpLevel(0.3);
                }
                EntityEventPacket pk = new EntityEventPacket();
                pk.eid = this.id;
                pk.event = 2;
                this.dataPacket(pk);
            }
            return true;
        }
        return false;
    }

    public boolean dropItem(Item item) {
        if (!this.spawned || !this.isAlive()) {
            return false;
        }
        if (item.isNull()) {
            this.server.getLogger().debug(this.getName() + " attempted to drop a null item (" + item + ")");
            return true;
        }
        Vector3 motion = this.getDirectionVector().multiply(0.4);
        this.level.dropItem(this.add(0.0, 1.3, 0.0), item, motion, 40);
        this.setDataFlag(0, 4, false);
        return true;
    }

    @Nullable
    @Since(value="1.3.2.0-PN")
    public EntityItem dropAndGetItem(@Nonnull Item item) {
        if (!this.spawned || !this.isAlive()) {
            return null;
        }
        if (item.isNull()) {
            this.server.getLogger().debug(this.getName() + " attempted to drop a null item (" + item + ")");
            return null;
        }
        Vector3 motion = this.getDirectionVector().multiply(0.4);
        this.setDataFlag(0, 4, false);
        return this.level.dropAndGetItem(this.add(0.0, 1.3, 0.0), item, motion, 40);
    }

    public void sendPosition(Vector3 pos) {
        this.sendPosition(pos, this.yaw);
    }

    public void sendPosition(Vector3 pos, double yaw) {
        this.sendPosition(pos, yaw, this.pitch);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch) {
        this.sendPosition(pos, yaw, pitch, 0);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch, int mode) {
        this.sendPosition(pos, yaw, pitch, mode, null);
    }

    public void sendPosition(Vector3 pos, double yaw, double pitch, int mode, Player[] targets) {
        MovePlayerPacket pk = new MovePlayerPacket();
        pk.eid = this.getId();
        pk.x = (float)pos.x;
        pk.y = (float)(pos.y + (double)this.getEyeHeight());
        pk.z = (float)pos.z;
        pk.headYaw = (float)yaw;
        pk.pitch = (float)pitch;
        pk.yaw = (float)yaw;
        pk.mode = mode;
        if (targets != null) {
            Server.broadcastPacket(targets, (DataPacket)pk);
        } else {
            pk.eid = this.id;
            this.dataPacket(pk);
        }
    }

    @Override
    protected void checkChunks() {
        if (this.chunk == null || this.chunk.getX() != (int)this.x >> 4 || this.chunk.getZ() != (int)this.z >> 4) {
            if (this.chunk != null) {
                this.chunk.removeEntity(this);
            }
            this.chunk = this.level.getChunk((int)this.x >> 4, (int)this.z >> 4, true);
            if (!this.justCreated) {
                Map<Integer, Player> newChunk = this.level.getChunkPlayers((int)this.x >> 4, (int)this.z >> 4);
                newChunk.remove(this.getLoaderId());
                for (Player player : new ArrayList(this.hasSpawned.values())) {
                    if (!newChunk.containsKey(player.getLoaderId())) {
                        this.despawnFrom(player);
                        continue;
                    }
                    newChunk.remove(player.getLoaderId());
                }
                for (Player player : newChunk.values()) {
                    this.spawnTo(player);
                }
            }
            if (this.chunk == null) {
                return;
            }
            this.chunk.addEntity(this);
        }
    }

    protected boolean checkTeleportPosition() {
        if (this.teleportPosition != null) {
            int chunkX = (int)this.teleportPosition.x >> 4;
            int chunkZ = (int)this.teleportPosition.z >> 4;
            for (int X = -1; X <= 1; ++X) {
                for (int Z = -1; Z <= 1; ++Z) {
                    long index = Level.chunkHash(chunkX + X, chunkZ + Z);
                    if (this.usedChunks.containsKey(index) && this.usedChunks.get(index).booleanValue()) continue;
                    return false;
                }
            }
            this.spawnToAll();
            this.forceMovement = this.teleportPosition;
            this.teleportPosition = null;
            return true;
        }
        return false;
    }

    protected void sendPlayStatus(int status) {
        this.sendPlayStatus(status, false);
    }

    protected void sendPlayStatus(int status, boolean immediate) {
        PlayStatusPacket pk = new PlayStatusPacket();
        pk.status = status;
        if (immediate) {
            this.directDataPacket(pk);
        } else {
            this.dataPacket(pk);
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!this.isOnline()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        if (cause != null) {
            PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return false;
            }
            to = event.getTo();
        }
        if (super.teleport(to.getY() == (double)to.getFloorY() ? to.add(0.0, 1.0E-5, 0.0) : to, null)) {
            this.removeAllWindows();
            this.forceMovement = this.teleportPosition = new Vector3(this.x, this.y, this.z);
            this.yaw = to.yaw;
            this.pitch = to.pitch;
            this.sendPosition(this, to.yaw, to.pitch, 2);
            this.checkTeleportPosition();
            this.resetFallDistance();
            this.nextChunkOrderRun = 0;
            this.newPosition = null;
            this.getDummyBossBars().values().forEach(DummyBossBar::reshow);
            this.getLevel().sendWeather(this);
            this.getLevel().sendTime(this);
            this.updateTrackingPositions(true);
            return true;
        }
        return false;
    }

    protected void forceSendEmptyChunks() {
        int chunkPositionX = this.getFloorX() >> 4;
        int chunkPositionZ = this.getFloorZ() >> 4;
        for (int x = -this.chunkRadius; x < this.chunkRadius; ++x) {
            for (int z = -this.chunkRadius; z < this.chunkRadius; ++z) {
                LevelChunkPacket chunk = new LevelChunkPacket();
                chunk.chunkX = chunkPositionX + x;
                chunk.chunkZ = chunkPositionZ + z;
                chunk.data = EmptyArrays.EMPTY_BYTES;
                this.dataPacket(chunk);
            }
        }
    }

    public void teleportImmediate(Location location) {
        this.teleportImmediate(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void teleportImmediate(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Location from = this.getLocation();
        if (super.teleport(location, cause)) {
            for (Inventory window : new ArrayList(this.windows.keySet())) {
                if (window == this.inventory) continue;
                this.removeWindow(window);
            }
            if (from.getLevel().getId() != location.getLevel().getId()) {
                SetSpawnPositionPacket pk = new SetSpawnPositionPacket();
                pk.spawnType = 1;
                Position spawn = location.getLevel().getSpawnLocation();
                pk.x = spawn.getFloorX();
                pk.y = spawn.getFloorY();
                pk.z = spawn.getFloorZ();
                pk.dimension = spawn.getLevel().getDimension();
                this.dataPacket(pk);
            }
            this.forceMovement = new Vector3(this.x, this.y, this.z);
            this.sendPosition(this, this.yaw, this.pitch, 1);
            this.resetFallDistance();
            this.orderChunks();
            this.nextChunkOrderRun = 0;
            this.newPosition = null;
            this.getLevel().sendWeather(this);
            this.getLevel().sendTime(this);
            this.updateTrackingPositions(true);
        }
    }

    public int showFormWindow(FormWindow window) {
        return this.showFormWindow(window, this.formWindowCount++);
    }

    public int showFormWindow(FormWindow window, int id) {
        ModalFormRequestPacket packet = new ModalFormRequestPacket();
        packet.formId = id;
        packet.data = window.getJSONData();
        this.formWindows.put(packet.formId, window);
        this.dataPacket(packet);
        return id;
    }

    public int addServerSettings(FormWindow window) {
        int id = this.formWindowCount++;
        this.serverSettings.put(id, window);
        return id;
    }

    @Deprecated
    public long createBossBar(String text, int length) {
        DummyBossBar bossBar = new DummyBossBar.Builder(this).text(text).length(length).build();
        return this.createBossBar(bossBar);
    }

    public long createBossBar(DummyBossBar dummyBossBar) {
        this.dummyBossBars.put(dummyBossBar.getBossBarId(), dummyBossBar);
        dummyBossBar.create();
        return dummyBossBar.getBossBarId();
    }

    public DummyBossBar getDummyBossBar(long bossBarId) {
        return this.dummyBossBars.getOrDefault(bossBarId, null);
    }

    public Map<Long, DummyBossBar> getDummyBossBars() {
        return this.dummyBossBars;
    }

    @Deprecated
    public void updateBossBar(String text, int length, long bossBarId) {
        if (this.dummyBossBars.containsKey(bossBarId)) {
            DummyBossBar bossBar = this.dummyBossBars.get(bossBarId);
            bossBar.setText(text);
            bossBar.setLength(length);
        }
    }

    public void removeBossBar(long bossBarId) {
        if (this.dummyBossBars.containsKey(bossBarId)) {
            this.dummyBossBars.get(bossBarId).destroy();
            this.dummyBossBars.remove(bossBarId);
        }
    }

    public int getWindowId(Inventory inventory) {
        if (this.windows.containsKey(inventory)) {
            return (Integer)this.windows.get(inventory);
        }
        return -1;
    }

    public Inventory getWindowById(int id) {
        return (Inventory)this.windowIndex.get(id);
    }

    public int addWindow(Inventory inventory) {
        return this.addWindow(inventory, null);
    }

    public int addWindow(Inventory inventory, Integer forceId) {
        return this.addWindow(inventory, forceId, false);
    }

    public int addWindow(Inventory inventory, Integer forceId, boolean isPermanent) {
        return this.addWindow(inventory, forceId, isPermanent, false);
    }

    public int addWindow(Inventory inventory, Integer forceId, boolean isPermanent, boolean alwaysOpen) {
        int cnt;
        if (this.windows.containsKey(inventory)) {
            return (Integer)this.windows.get(inventory);
        }
        if (forceId == null) {
            this.windowCnt = cnt = Math.max(4, ++this.windowCnt % 99);
        } else {
            cnt = forceId;
        }
        this.windows.forcePut(inventory, cnt);
        if (isPermanent) {
            this.permanentWindows.add(cnt);
        }
        if (this.spawned && inventory.open(this)) {
            if (!isPermanent) {
                this.updateTrackingPositions(true);
            }
            return cnt;
        }
        if (!alwaysOpen) {
            this.removeWindow(inventory);
            return -1;
        }
        inventory.getViewers().add(this);
        if (!isPermanent) {
            this.updateTrackingPositions(true);
        }
        return cnt;
    }

    public Optional<Inventory> getTopWindow() {
        for (Map.Entry entry : this.windows.entrySet()) {
            if (this.permanentWindows.contains(entry.getValue())) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public void removeWindow(Inventory inventory) {
        inventory.close(this);
        if (!this.permanentWindows.contains(this.getWindowId(inventory))) {
            this.windows.remove(inventory);
            this.updateTrackingPositions(true);
        }
    }

    public void sendAllInventories() {
        for (Inventory inv : this.windows.keySet()) {
            inv.sendContents(this);
            if (!(inv instanceof PlayerInventory)) continue;
            ((PlayerInventory)inv).sendArmorContents(this);
        }
    }

    protected void addDefaultWindows() {
        this.addWindow(this.getInventory(), 0, true, true);
        this.playerUIInventory = new PlayerUIInventory(this);
        this.addWindow(this.playerUIInventory, 124, true);
        this.addWindow(this.offhandInventory, 119, true, true);
        this.craftingGrid = this.playerUIInventory.getCraftingGrid();
        this.addWindow(this.craftingGrid, -1);
    }

    public PlayerUIInventory getUIInventory() {
        return this.playerUIInventory;
    }

    public PlayerCursorInventory getCursorInventory() {
        return this.playerUIInventory.getCursorInventory();
    }

    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    public void setCraftingGrid(CraftingGrid grid) {
        this.craftingGrid = grid;
        this.addWindow(grid, -1);
    }

    public void resetCraftingGridType() {
        if (this.craftingGrid != null) {
            Item[] drops = this.inventory.addItem(this.craftingGrid.getContents().values().toArray(Item.EMPTY_ARRAY));
            if (drops.length > 0) {
                for (Item drop : drops) {
                    this.dropItem(drop);
                }
            }
            if ((drops = this.inventory.addItem(this.getCursorInventory().getItem(0))).length > 0) {
                for (Item drop : drops) {
                    this.dropItem(drop);
                }
            }
            this.playerUIInventory.clearAll();
            if (this.craftingGrid instanceof BigCraftingGrid) {
                this.craftingGrid = this.playerUIInventory.getCraftingGrid();
                this.addWindow(this.craftingGrid, -1);
            }
            this.craftingType = 0;
        }
    }

    public void removeAllWindows() {
        this.removeAllWindows(false);
    }

    public void removeAllWindows(boolean permanent) {
        for (Map.Entry entry : new ArrayList(this.windowIndex.entrySet())) {
            if (!permanent && this.permanentWindows.contains(entry.getKey())) continue;
            this.removeWindow((Inventory)entry.getValue());
        }
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public void onChunkChanged(FullChunk chunk) {
        this.usedChunks.remove(Level.chunkHash(chunk.getX(), chunk.getZ()));
    }

    @Override
    public void onChunkLoaded(FullChunk chunk) {
    }

    @Override
    public void onChunkPopulated(FullChunk chunk) {
    }

    @Override
    public void onChunkUnloaded(FullChunk chunk) {
    }

    @Override
    public void onBlockChanged(Vector3 block) {
    }

    @Override
    public int getLoaderId() {
        return this.loaderId;
    }

    @Override
    public boolean isLoaderActive() {
        return this.isConnected();
    }

    public static BatchPacket getChunkCacheFromData(int chunkX, int chunkZ, int subChunkCount, byte[] payload) {
        LevelChunkPacket pk = new LevelChunkPacket();
        pk.chunkX = chunkX;
        pk.chunkZ = chunkZ;
        pk.subChunkCount = subChunkCount;
        pk.data = payload;
        pk.encode();
        BatchPacket batch = new BatchPacket();
        byte[][] batchPayload = new byte[2][];
        byte[] buf = pk.getBuffer();
        batchPayload[0] = Binary.writeUnsignedVarInt(buf.length);
        batchPayload[1] = buf;
        byte[] data = Binary.appendBytes(batchPayload);
        try {
            batch.payload = Network.deflateRaw(data, Server.getInstance().networkCompressionLevel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return batch;
    }

    public boolean isFoodEnabled() {
        return !this.isCreative() && !this.isSpectator() && this.foodEnabled;
    }

    public void setFoodEnabled(boolean foodEnabled) {
        this.foodEnabled = foodEnabled;
    }

    public PlayerFood getFoodData() {
        return this.foodData;
    }

    private void setDimension(int dimension) {
        ChangeDimensionPacket pk = new ChangeDimensionPacket();
        pk.dimension = dimension;
        pk.x = (float)this.x;
        pk.y = (float)this.y;
        pk.z = (float)this.z;
        this.dataPacket(pk);
    }

    @Override
    public boolean switchLevel(Level level) {
        Level oldLevel = this.level;
        if (super.switchLevel(level)) {
            SetSpawnPositionPacket spawnPosition = new SetSpawnPositionPacket();
            spawnPosition.spawnType = 1;
            Position spawn = level.getSpawnLocation();
            spawnPosition.x = spawn.getFloorX();
            spawnPosition.y = spawn.getFloorY();
            spawnPosition.z = spawn.getFloorZ();
            spawnPosition.dimension = spawn.getLevel().getDimension();
            this.dataPacket(spawnPosition);
            for (long index : new ArrayList<Long>(this.usedChunks.keySet())) {
                int chunkX = Level.getHashX(index);
                int chunkZ = Level.getHashZ(index);
                this.unloadChunk(chunkX, chunkZ, oldLevel);
            }
            this.usedChunks.clear();
            SetTimePacket setTime = new SetTimePacket();
            setTime.time = level.getTime();
            this.dataPacket(setTime);
            GameRulesChangedPacket gameRulesChanged = new GameRulesChangedPacket();
            gameRulesChanged.gameRules = level.getGameRules();
            this.dataPacket(gameRulesChanged);
            if (oldLevel.getDimension() != level.getDimension()) {
                this.setDimension(level.getDimension());
            }
            this.updateTrackingPositions(true);
            return true;
        }
        return false;
    }

    public void setCheckMovement(boolean checkMovement) {
        this.checkMovement = checkMovement;
    }

    public boolean isCheckingMovement() {
        return this.checkMovement;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public synchronized Locale getLocale() {
        return this.locale.get();
    }

    @Override
    public void setSprinting(boolean value) {
        if (this.isSprinting() != value) {
            super.setSprinting(value);
        }
    }

    public void transfer(InetSocketAddress address) {
        String hostName = address.getAddress().getHostAddress();
        int port = address.getPort();
        TransferPacket pk = new TransferPacket();
        pk.address = hostName;
        pk.port = port;
        this.dataPacket(pk);
    }

    public LoginChainData getLoginChainData() {
        return this.loginChainData;
    }

    public boolean pickupEntity(Entity entity, boolean near) {
        EntityXPOrb xpOrb;
        int tick;
        if (!this.spawned || !this.isAlive() || !this.isOnline() || this.getGamemode() == 3 || entity.isClosed()) {
            return false;
        }
        if (near) {
            Item item;
            BaseInventory inventory = this.inventory;
            if (entity instanceof EntityArrow && ((EntityArrow)entity).hadCollision) {
                ItemArrow item2 = new ItemArrow();
                if (this.isSurvival()) {
                    if (this.offhandInventory.getItem(0).getId() == item2.getId() && this.offhandInventory.canAddItem(item2)) {
                        inventory = this.offhandInventory;
                    } else if (!inventory.canAddItem(item2)) {
                        return false;
                    }
                }
                InventoryPickupArrowEvent ev = new InventoryPickupArrowEvent(inventory, (EntityArrow)entity);
                int pickupMode = ((EntityArrow)entity).getPickupMode();
                if (pickupMode == 0 || pickupMode == 2 && !this.isCreative()) {
                    ev.setCancelled();
                }
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                if (!this.isCreative()) {
                    inventory.addItem(item2.clone());
                }
                entity.close();
                return true;
            }
            if (entity instanceof EntityThrownTrident && ((EntityThrownTrident)entity).hadCollision) {
                Item item3 = ((EntityThrownTrident)entity).getItem();
                if (this.isSurvival() && !inventory.canAddItem(item3)) {
                    return false;
                }
                InventoryPickupTridentEvent ev = new InventoryPickupTridentEvent(this.inventory, (EntityThrownTrident)entity);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                if (!this.isCreative()) {
                    inventory.addItem(item3.clone());
                }
                entity.close();
                return true;
            }
            if (entity instanceof EntityItem && ((EntityItem)entity).getPickupDelay() <= 0 && (item = ((EntityItem)entity).getItem()) != null) {
                if (this.isSurvival() && !inventory.canAddItem(item)) {
                    return false;
                }
                InventoryPickupItemEvent ev = new InventoryPickupItemEvent(inventory, (EntityItem)entity);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                switch (item.getId()) {
                    case 17: 
                    case 162: {
                        this.awardAchievement("mineWood");
                        break;
                    }
                    case 264: {
                        this.awardAchievement("diamond");
                    }
                }
                TakeItemEntityPacket pk = new TakeItemEntityPacket();
                pk.entityId = this.getId();
                pk.target = entity.getId();
                Server.broadcastPacket(entity.getViewers().values(), (DataPacket)pk);
                this.dataPacket(pk);
                entity.close();
                inventory.addItem(item.clone());
                return true;
            }
        }
        if (this.pickedXPOrb < (tick = this.getServer().getTick()) && entity instanceof EntityXPOrb && this.boundingBox.isVectorInside(entity) && (xpOrb = (EntityXPOrb)entity).getPickupDelay() <= 0) {
            Random rand;
            Integer itemToRepair;
            Item toRepair;
            int exp = xpOrb.getExp();
            entity.kill();
            this.getLevel().addLevelEvent(1051, 0, this);
            this.pickedXPOrb = tick;
            ArrayList<Integer> itemsWithMending = new ArrayList<Integer>();
            for (int i = 0; i < 4; ++i) {
                if (this.inventory.getArmorItem(i).getEnchantment((short)26) == null) continue;
                itemsWithMending.add(this.inventory.getSize() + i);
            }
            if (this.inventory.getItemInHand().getEnchantment((short)26) != null) {
                itemsWithMending.add(this.inventory.getHeldItemIndex());
            }
            if (itemsWithMending.size() > 0 && ((toRepair = this.inventory.getItem(itemToRepair = (Integer)itemsWithMending.get((rand = new Random()).nextInt(itemsWithMending.size())))) instanceof ItemTool || toRepair instanceof ItemArmor) && toRepair.getDamage() > 0) {
                int dmg = toRepair.getDamage() - 2;
                if (dmg < 0) {
                    dmg = 0;
                }
                toRepair.setDamage(dmg);
                this.inventory.setItem(itemToRepair, toRepair);
                return true;
            }
            this.addExperience(exp, true);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Player)) {
            return false;
        }
        Player other = (Player)obj;
        return Objects.equals(this.getUniqueId(), other.getUniqueId()) && this.getId() == other.getId();
    }

    public boolean isBreakingBlock() {
        return this.breakingBlock != null;
    }

    public void showXboxProfile(String xuid) {
        ShowProfilePacket pk = new ShowProfilePacket();
        pk.xuid = xuid;
        this.dataPacket(pk);
    }

    public void startFishing(Item fishingRod) {
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", this.x)).add(new DoubleTag("", this.y + (double)this.getEyeHeight())).add(new DoubleTag("", this.z))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(this.yaw / 180.0 + Math.PI) * Math.cos(this.pitch / 180.0 * Math.PI))).add(new DoubleTag("", -Math.sin(this.pitch / 180.0 * Math.PI))).add(new DoubleTag("", Math.cos(this.yaw / 180.0 * Math.PI) * Math.cos(this.pitch / 180.0 * Math.PI)))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", (float)this.yaw)).add(new FloatTag("", (float)this.pitch)));
        double f = 1.0;
        EntityFishingHook fishingHook = new EntityFishingHook(this.chunk, nbt, this);
        fishingHook.setMotion(new Vector3(-Math.sin(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * f * f, -Math.sin(Math.toRadians(this.pitch)) * f * f, Math.cos(Math.toRadians(this.yaw)) * Math.cos(Math.toRadians(this.pitch)) * f * f));
        ProjectileLaunchEvent ev = new ProjectileLaunchEvent(fishingHook);
        this.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            fishingHook.kill();
        } else {
            fishingHook.spawnToAll();
            this.fishing = fishingHook;
            fishingHook.rod = fishingRod;
        }
    }

    public void stopFishing(boolean click) {
        if (click) {
            this.fishing.reelLine();
        } else if (this.fishing != null) {
            this.fishing.kill();
            this.fishing.close();
        }
        this.fishing = null;
    }

    @Override
    public boolean doesTriggerPressurePlate() {
        return this.gamemode != 3;
    }

    private void updateBlockingFlag() {
        boolean shouldBlock;
        boolean bl = shouldBlock = !(this.getNoShieldTicks() != 0 || !this.isSneaking() && this.getRiding() == null || this.getInventory().getItemInHand().getId() != 513 && this.getOffhandInventory().getItem(0).getId() != 513);
        if (this.isBlocking() != shouldBlock) {
            this.setBlocking(shouldBlock);
        }
    }

    @Override
    protected void onBlock(Entity entity, boolean animate) {
        super.onBlock(entity, animate);
        if (animate) {
            this.setDataFlag(0, 74, true);
            this.getServer().getScheduler().scheduleTask(null, () -> {
                if (this.isOnline()) {
                    this.setDataFlag(0, 74, false);
                }
            });
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getNoShieldTicks() {
        return this.noShieldTicks;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setNoShieldTicks(int noShieldTicks) {
        this.noShieldTicks = noShieldTicks;
    }

    @Override
    public String toString() {
        return "Player(name='" + this.getName() + "', location=" + super.toString() + ')';
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void giveItem(Item ... items) {
        for (Item failed : this.getInventory().addItem(items)) {
            this.getLevel().dropItem(this, failed);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getTimeSinceRest() {
        return this.timeSinceRest;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTimeSinceRest(int timeSinceRest) {
        this.timeSinceRest = timeSinceRest;
    }

    private /* synthetic */ void lambda$handleDataPacket$4(Integer id, FormWindow window) {
        ServerSettingsResponsePacket re = new ServerSettingsResponsePacket();
        re.formId = id;
        re.data = window.getJSONData();
        this.dataPacket(re);
    }

    private static /* synthetic */ String lambda$handleDataPacket$3(String name) {
        return " for packet " + name;
    }

    private static /* synthetic */ boolean lambda$handleDataPacket$2(DataPacket packet, Field field) {
        try {
            return field.getByte(null) == ((PacketViolationWarningPacket)packet).packetId;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$handleDataPacket$1(Field field) {
        return field.getType() == Byte.TYPE;
    }
}

