/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBanner;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.MainLogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockBanner
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntityBanner> {
    public BlockBanner() {
        this(0);
    }

    public BlockBanner(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 176;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Banner";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBanner> getBlockEntityClass() {
        return BlockEntityBanner.class;
    }

    @Override
    public double getHardness() {
        return 1.0;
    }

    @Override
    public double getResistance() {
        return 5.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public String getName() {
        return "Banner";
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return null;
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Tag patterns;
        if (face == BlockFace.DOWN) {
            return false;
        }
        Block layer0 = this.level.getBlock((Vector3)this, 0);
        Block layer1 = this.level.getBlock((Vector3)this, 1);
        if (face == BlockFace.UP) {
            this.setDamage(NukkitMath.floorDouble((player.yaw + 180.0) * 16.0 / 360.0 + 0.5) & 0xF);
            if (!this.getLevel().setBlock((Vector3)block, this, true)) {
                return false;
            }
        } else {
            this.setDamage(face.getIndex());
            if (!this.getLevel().setBlock((Vector3)block, Block.get(177, this.getDamage()), true)) {
                return false;
            }
        }
        CompoundTag nbt = BlockEntity.getDefaultCompound(this, "Banner").putInt("Base", item.getDamage() & 0xF);
        Tag type = item.getNamedTagEntry("Type");
        if (type instanceof IntTag) {
            nbt.put("Type", type);
        }
        if ((patterns = item.getNamedTagEntry("Patterns")) instanceof ListTag) {
            nbt.put("Patterns", patterns);
        }
        try {
            this.createBlockEntity(nbt, new Object[0]);
            return true;
        }
        catch (Exception e) {
            MainLogger.getLogger().warning("Failed to create the block entity " + this.getBlockEntityType() + " at " + this.getLocation(), e);
            this.level.setBlock((Vector3)layer0, 0, layer0, true);
            this.level.setBlock((Vector3)layer0, 1, layer1, true);
            return false;
        }
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1 && this.down().getId() == 0) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public Item toItem() {
        BlockEntityBanner banner = (BlockEntityBanner)this.getBlockEntity();
        Item item = Item.get(446);
        if (banner != null) {
            ListTag<CompoundTag> patterns;
            item.setDamage(banner.getBaseColor() & 0xF);
            int type = banner.namedTag.getInt("Type");
            if (type > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putInt("Type", type));
            }
            if ((patterns = banner.namedTag.getList("Patterns", CompoundTag.class)).size() > 0) {
                item.setNamedTag((item.hasCompoundTag() ? item.getNamedTag() : new CompoundTag()).putList(patterns));
            }
        }
        return item;
    }

    @Override
    public BlockFace getBlockFace() {
        return BlockFace.fromHorizontalIndex(this.getDamage() & 7);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntityBanner blockEntity;
        if (this.level != null && (blockEntity = (BlockEntityBanner)this.getBlockEntity()) != null) {
            return blockEntity.getDyeColor();
        }
        return DyeColor.WHITE;
    }
}

