/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockLever;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockentity.BlockEntityBed;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityPrimedTNT;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBed;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.level.Location;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.TextFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockBed
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntityBed> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty HEAD_PIECE = new BooleanBlockProperty("head_piece_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty OCCUPIED = new BooleanBlockProperty("occupied_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, OCCUPIED, HEAD_PIECE);

    public BlockBed() {
        this(0);
    }

    public BlockBed(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 26;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBed> getBlockEntityClass() {
        return BlockEntityBed.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Bed";
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public double getResistance() {
        return 1.0;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public String getName() {
        return this.getDyeColor().getName() + " Bed Block";
    }

    @Override
    public double getMaxY() {
        return this.y + 0.5625;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean onActivate(@Nonnull Item item) {
        return this.onActivate(item, null);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        int time;
        boolean isNight;
        Block b;
        if (this.level.getDimension() != 0) {
            CompoundTag tag = EntityPrimedTNT.getDefaultNBT(this).putShort("Fuse", 0);
            new EntityPrimedTNT(this.level.getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), tag);
            return true;
        }
        BlockFace dir = this.getBlockFace();
        if (this.isHeadPiece()) {
            b = this;
        } else {
            b = this.getSide(dir);
            if (b.getId() != this.getId() || !((BlockBed)b).isHeadPiece() || !((BlockBed)b).getBlockFace().equals((Object)dir)) {
                if (player != null) {
                    player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.notValid"));
                }
                return true;
            }
        }
        BlockFace footPart = dir.getOpposite();
        if (player != null) {
            AxisAlignedBB accessArea = new SimpleAxisAlignedBB(b.x - 2.0, b.y - 5.5, b.z - 2.0, b.x + 3.0, b.y + 2.5, b.z + 3.0).addCoord(footPart.getXOffset(), 0.0, footPart.getZOffset());
            if (!accessArea.isVectorInside(player)) {
                player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.tooFar"));
                return true;
            }
            Location spawn = Location.fromObject(b.add(0.5, 0.5, 0.5), player.getLevel(), player.getYaw(), player.getPitch());
            if (!player.getSpawn().equals(spawn)) {
                player.setSpawn(spawn);
            }
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.respawnSet"));
        }
        boolean bl = isNight = (time = this.getLevel().getTime() % 24000) >= 14000 && time < 23000;
        if (player != null && !isNight) {
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.noSleep"));
            return true;
        }
        if (player != null && !player.isCreative()) {
            AxisAlignedBB checkMonsterArea = new SimpleAxisAlignedBB(b.x - 8.0, b.y - 6.5, b.z - 8.0, b.x + 9.0, b.y + 5.5, b.z + 9.0).addCoord(footPart.getXOffset(), 0.0, footPart.getZOffset());
            for (Entity entity : this.level.getCollidingEntities(checkMonsterArea)) {
                if (entity.isClosed() || !entity.isPreventingSleep(player)) continue;
                player.sendTranslation((Object)((Object)TextFormat.GRAY) + "%tile.bed.notSafe");
                return true;
            }
        }
        if (player != null && !player.sleepOn(b)) {
            player.sendMessage(new TranslationContainer((Object)((Object)TextFormat.GRAY) + "%tile.bed.occupied"));
        }
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Block down = this.down();
        if (!BlockLever.isSupportValid(down, BlockFace.UP) && !(down instanceof BlockCauldron)) {
            return false;
        }
        BlockFace direction = player == null ? BlockFace.NORTH : player.getDirection();
        Block next = this.getSide(direction);
        Block downNext = next.down();
        if (!next.canBeReplaced() || !BlockLever.isSupportValid(downNext, BlockFace.UP) && !(downNext instanceof BlockCauldron)) {
            return false;
        }
        Block thisLayer0 = this.level.getBlock((Vector3)this, 0);
        Block thisLayer1 = this.level.getBlock((Vector3)this, 1);
        Block nextLayer0 = this.level.getBlock((Vector3)next, 0);
        Block nextLayer1 = this.level.getBlock((Vector3)next, 1);
        this.setBlockFace(direction);
        this.level.setBlock((Vector3)block, this, true, true);
        if (next instanceof BlockLiquid && ((BlockLiquid)next).usesWaterLogging()) {
            this.level.setBlock(next, 1, next, true, false);
        }
        BlockBed head = this.clone();
        head.setHeadPiece(true);
        this.level.setBlock((Vector3)next, head, true, true);
        BlockEntityBed thisBed = null;
        try {
            thisBed = (BlockEntityBed)this.createBlockEntity(new CompoundTag().putByte("color", item.getDamage()), new Object[0]);
            BlockEntityHolder nextBlock = (BlockEntityHolder)((Object)next.getLevelBlock());
            nextBlock.createBlockEntity(new CompoundTag().putByte("color", item.getDamage()), new Object[0]);
        }
        catch (Exception e) {
            MainLogger.getLogger().warning("Failed to create the block entity " + this.getBlockEntityType() + " at " + this.getLocation() + " and " + next.getLocation(), e);
            if (thisBed != null) {
                thisBed.close();
            }
            this.level.setBlock((Vector3)thisLayer0, 0, thisLayer0, true);
            this.level.setBlock((Vector3)thisLayer1, 1, thisLayer1, true);
            this.level.setBlock((Vector3)nextLayer0, 0, nextLayer0, true);
            this.level.setBlock((Vector3)nextLayer1, 1, nextLayer1, true);
            return false;
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        BlockFace direction = this.getBlockFace();
        if (this.isHeadPiece()) {
            Block other = this.getSide(direction.getOpposite());
            if (other.getId() == this.getId() && !((BlockBed)other).isHeadPiece() && direction.equals((Object)((BlockBed)other).getBlockFace())) {
                this.getLevel().setBlock((Vector3)other, Block.get(0), true, true);
            }
        } else {
            Block other = this.getSide(direction);
            if (other.getId() == this.getId() && ((BlockBed)other).isHeadPiece() && direction.equals((Object)((BlockBed)other).getBlockFace())) {
                this.getLevel().setBlock((Vector3)other, Block.get(0), true, true);
            }
        }
        this.getLevel().setBlock((Vector3)this, Block.get(0), true, false);
        return true;
    }

    @Override
    public Item toItem() {
        return new ItemBed((Integer)this.getDyeColor().getWoolData());
    }

    @Override
    public BlockColor getColor() {
        return this.getDyeColor().getColor();
    }

    public DyeColor getDyeColor() {
        BlockEntityBed blockEntity;
        if (this.level != null && (blockEntity = (BlockEntityBed)this.getBlockEntity()) != null) {
            return blockEntity.getDyeColor();
        }
        return DyeColor.WHITE;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isHeadPiece() {
        return this.getBooleanValue(HEAD_PIECE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setHeadPiece(boolean headPiece) {
        this.setBooleanValue(HEAD_PIECE, headPiece);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isOccupied() {
        return this.getBooleanValue(OCCUPIED);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOccupied(boolean occupied) {
        this.setBooleanValue(OCCUPIED, occupied);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    public BlockBed clone() {
        return (BlockBed)super.clone();
    }
}

