/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockentity.BlockEntityBeehive;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.util.List;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockBeehive
extends BlockSolidMeta
implements Faceable,
BlockEntityHolder<BlockEntityBeehive> {
    public static final IntBlockProperty HONEY_LEVEL = new IntBlockProperty("honey_level", false, 5);
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, HONEY_LEVEL);

    public BlockBeehive() {
        this(0);
    }

    protected BlockBeehive(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 474;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Beehive";
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Beehive";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityBeehive> getBlockEntityClass() {
        return BlockEntityBeehive.class;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    @Override
    public double getHardness() {
        return 0.6;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (player == null) {
            this.setBlockFace(BlockFace.SOUTH);
        } else {
            this.setBlockFace(player.getDirection().getOpposite());
        }
        int honeyLevel = item.hasCustomBlockData() ? item.getCustomBlockData().getByte("HoneyLevel") : 0;
        this.setHoneyLevel(honeyLevel);
        BlockEntityBeehive beehive = (BlockEntityBeehive)BlockEntityHolder.setBlockAndCreateEntity(this, true, true, item.getCustomBlockData(), new Object[0]);
        if (beehive == null) {
            return false;
        }
        if (beehive.namedTag.getByte("ShouldSpawnBees") > 0) {
            List<BlockFace> validSpawnFaces = beehive.scanValidSpawnFaces(true);
            for (BlockEntityBeehive.Occupant occupant : beehive.getOccupants()) {
                beehive.spawnOccupant(occupant, validSpawnFaces);
            }
            beehive.namedTag.putByte("ShouldSpawnBees", 0);
        }
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.getId() == 359 && this.isFull()) {
            this.honeyCollected(player);
            this.level.addSound(this.add(0.5, 0.5, 0.5), Sound.BLOCK_BEEHIVE_SHEAR);
            item.useOn(this);
            for (int i = 0; i < 3; ++i) {
                this.level.dropItem(this, Item.get(736));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    public void honeyCollected(Player player) {
        this.honeyCollected(player, this.level.getServer().getDifficulty() > 0 && !player.isCreative());
    }

    public void honeyCollected(Player player, boolean angerBees) {
        this.setHoneyLevel(0);
        if (this.down().getId() != 464 && angerBees) {
            this.angerBees(player);
        }
    }

    public void angerBees(Player player) {
        BlockEntityBeehive beehive = (BlockEntityBeehive)this.getBlockEntity();
        if (beehive != null) {
            beehive.angerBees(player);
        }
    }

    @Override
    public Item toItem() {
        BlockEntityBeehive beehive;
        Item item = Item.get(this.getItemId(), 0, 1);
        if (this.level != null && (beehive = (BlockEntityBeehive)this.getBlockEntity()) != null) {
            beehive.saveNBT();
            if (!beehive.isHoneyEmpty() || !beehive.isEmpty()) {
                CompoundTag copy = beehive.namedTag.copy();
                copy.putByte("HoneyLevel", this.getHoneyLevel());
                item.setCustomBlockData(copy);
            }
        }
        return item;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    @Since(value="1.2.1.0-PN")
    @PowerNukkitOnly
    public boolean mustSilkTouch(Vector3 vector, int layer, BlockFace face, Item item, Player player) {
        BlockEntityBeehive beehive;
        if (player != null && (beehive = (BlockEntityBeehive)this.getBlockEntity()) != null && !beehive.isEmpty()) {
            return true;
        }
        return super.mustSilkTouch(vector, layer, face, item, player);
    }

    @Override
    @Since(value="1.2.1.0-PN")
    @PowerNukkitOnly
    public boolean mustDrop(Vector3 vector, int layer, BlockFace face, Item item, Player player) {
        return this.mustSilkTouch(vector, layer, face, item, player) || super.mustDrop(vector, layer, face, item, player);
    }

    @Override
    public boolean canHarvestWithHand() {
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.getBlock(474)};
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    public void setHoneyLevel(int honeyLevel) {
        this.setPropertyValue(HONEY_LEVEL, honeyLevel);
    }

    public int getHoneyLevel() {
        return this.getPropertyValue(HONEY_LEVEL);
    }

    public boolean isEmpty() {
        return this.getHoneyLevel() == HONEY_LEVEL.getMinValue();
    }

    public boolean isFull() {
        return this.getPropertyValue(HONEY_LEVEL).intValue() == HONEY_LEVEL.getMaxValue();
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.getHoneyLevel();
    }
}

