/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockCactus
extends BlockTransparentMeta {
    public BlockCactus(int meta) {
        super(meta);
    }

    public BlockCactus() {
        this(0);
    }

    @Override
    public int getId() {
        return 81;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public double getMinX() {
        return this.x + 0.0625;
    }

    @Override
    public double getMinY() {
        return this.y;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.0625;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.9375;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.9375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.9375;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.CONTACT, 1.0f));
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block down = this.down();
            if (down.getId() != 12 && down.getId() != 81) {
                this.getLevel().useBreakOn(this);
            } else {
                for (int side = 2; side <= 5; ++side) {
                    Block block = this.getSide(BlockFace.fromIndex(side));
                    if (block.canBeFlowedInto()) continue;
                    this.getLevel().useBreakOn(this);
                }
            }
        } else if (type == 2 && this.down().getId() != 81) {
            if (this.getDamage() == 15) {
                for (int y = 1; y < 3; ++y) {
                    Block b = this.getLevel().getBlock(new Vector3(this.x, this.y + (double)y, this.z));
                    if (b.getId() != 0) continue;
                    BlockGrowEvent event = new BlockGrowEvent(b, Block.get(81));
                    Server.getInstance().getPluginManager().callEvent(event);
                    if (event.isCancelled()) continue;
                    this.getLevel().setBlock((Vector3)b, event.getNewState(), true);
                }
                this.setDamage(0);
                this.getLevel().setBlock(this, this);
            } else {
                this.setDamage(this.getDamage() + 1);
                this.getLevel().setBlock(this, this);
            }
        }
        return 0;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        Block down = this.down();
        if (down.getId() == 12 || down.getId() == 81) {
            Block block0 = this.north();
            Block block1 = this.south();
            Block block2 = this.west();
            Block block3 = this.east();
            if (block0.canBeFlowedInto() && block1.canBeFlowedInto() && block2.canBeFlowedInto() && block3.canBeFlowedInto()) {
                this.getLevel().setBlock((Vector3)this, this, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "Cactus";
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.getBlock(81, 0, 1)};
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

