/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockentity.BlockEntityCampfire;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.CampfireInventory;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemCampfire;
import cn.nukkit.item.ItemCoal;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import cn.nukkit.utils.MainLogger;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
public class BlockCampfire
extends BlockTransparentMeta
implements Faceable,
BlockEntityHolder<BlockEntityCampfire> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty EXTINGUISHED = new BooleanBlockProperty("extinguished", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.DIRECTION, EXTINGUISHED);

    @PowerNukkitOnly
    public BlockCampfire() {
        this(0);
    }

    @PowerNukkitOnly
    public BlockCampfire(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 464;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "Campfire";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityCampfire> getBlockEntityClass() {
        return BlockEntityCampfire.class;
    }

    @Override
    public int getLightLevel() {
        return this.isExtinguished() ? 0 : 15;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public boolean canHarvestWithHand() {
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{new ItemCoal((Integer)0, 1 + ThreadLocalRandom.current().nextInt(1))};
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        boolean layer1Check;
        if (this.down().getId() == 464) {
            return false;
        }
        Block layer0 = this.level.getBlock((Vector3)this, 0);
        Block layer1 = this.level.getBlock((Vector3)this, 1);
        this.setBlockFace(player != null ? player.getDirection().getOpposite() : null);
        boolean defaultLayerCheck = block instanceof BlockWater && ((BlockWater)block).isSourceOrFlowingDown() || block instanceof BlockIceFrosted;
        boolean bl = layer1Check = layer1 instanceof BlockWater && ((BlockWater)layer1).isSourceOrFlowingDown() || layer1 instanceof BlockIceFrosted;
        if (defaultLayerCheck || layer1Check) {
            this.setExtinguished(true);
            this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
            this.level.setBlock(this, 1, defaultLayerCheck ? block : layer1, false, false);
        } else {
            this.level.setBlock(this, 1, Block.get(0), false, false);
        }
        this.level.setBlock((Vector3)block, this, true, true);
        try {
            CompoundTag nbt = new CompoundTag();
            if (item.hasCustomBlockData()) {
                Map<String, Tag> customData = item.getCustomBlockData().getTags();
                for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                    nbt.put(tag.getKey(), tag.getValue());
                }
            }
            this.createBlockEntity(nbt, new Object[0]);
        }
        catch (Exception e) {
            MainLogger.getLogger().warning("Failed to create the block entity " + this.getBlockEntityType() + " at " + this.getLocation(), e);
            this.level.setBlock((Vector3)layer0, 0, layer0, true);
            this.level.setBlock((Vector3)layer1, 0, layer1, true);
            return false;
        }
        this.level.updateAround(this);
        return true;
    }

    @Override
    public boolean hasEntityCollision() {
        return true;
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!this.isExtinguished() && !entity.isSneaking()) {
            entity.attack(new EntityDamageByBlockEvent(this, entity, EntityDamageEvent.DamageCause.FIRE, 1.0f));
        }
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block layer1;
            if (!this.isExtinguished() && ((layer1 = this.getLevelBlockAtLayer(1)) instanceof BlockWater || layer1 instanceof BlockIceFrosted)) {
                this.setExtinguished(true);
                this.level.setBlock((Vector3)this, this, true, true);
                this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
            }
            return type;
        }
        return 0;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        CampfireRecipe recipe;
        if (item.getId() == 0 || item.getCount() <= 0) {
            return false;
        }
        BlockEntityCampfire campfire = (BlockEntityCampfire)this.getOrCreateBlockEntity();
        boolean itemUsed = false;
        if (item.isShovel() && !this.isExtinguished()) {
            this.setExtinguished(true);
            this.level.setBlock((Vector3)this, this, true, true);
            this.level.addSound(this, Sound.RANDOM_FIZZ, 0.5f, 2.2f);
            itemUsed = true;
        } else if (item.getId() == 259) {
            item.useOn(this);
            this.setExtinguished(false);
            this.level.setBlock((Vector3)this, this, true, true);
            campfire.scheduleUpdate();
            this.level.addSound(this, Sound.FIRE_IGNITE);
            itemUsed = true;
        }
        Item cloned = item.clone();
        cloned.setCount(1);
        CampfireInventory inventory = campfire.getInventory();
        if (inventory.canAddItem(cloned) && (recipe = this.level.getServer().getCraftingManager().matchCampfireRecipe(cloned)) != null) {
            inventory.addItem(cloned);
            item.setCount(item.getCount() - 1);
            return true;
        }
        return itemUsed;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean onProjectileHit(@Nonnull Entity projectile, @Nonnull Position position, @Nonnull Vector3 motion) {
        if (projectile.isOnFire() && projectile instanceof EntityArrow && this.isExtinguished()) {
            this.setExtinguished(false);
            this.level.setBlock((Vector3)this, this, true);
            return true;
        }
        return false;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.4371948;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.SPRUCE_BLOCK_COLOR;
    }

    public boolean isExtinguished() {
        return this.getBooleanValue(EXTINGUISHED);
    }

    public void setExtinguished(boolean extinguished) {
        this.setBooleanValue(EXTINGUISHED, extinguished);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.DIRECTION, face);
    }

    @Override
    public String getName() {
        return "Campfire";
    }

    @Override
    public Item toItem() {
        return new ItemCampfire();
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityCampfire blockEntity = (BlockEntityCampfire)this.getBlockEntity();
        if (blockEntity != null) {
            return ContainerInventory.calculateRedstone(blockEntity.getInventory());
        }
        return super.getComparatorInputOverride();
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

