/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLog;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemChain;
import cn.nukkit.math.BlockFace;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockChain
extends BlockTransparent {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockChain() {
    }

    @Override
    public String getName() {
        return "Chain";
    }

    @Override
    public int getId() {
        return 541;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return BlockLog.PILLAR_PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockFace.Axis getPillarAxis() {
        return this.getPropertyValue(CommonBlockProperties.PILLAR_AXIS);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPillarAxis(BlockFace.Axis axis) {
        this.setPropertyValue(CommonBlockProperties.PILLAR_AXIS, axis);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        this.setPillarAxis(face.getAxis());
        return super.place(item, block, target, face, fx, fy, fz, player);
    }

    @Override
    public double getHardness() {
        return 5.0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getMinX() {
        return this.x + 0.4375;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.5625;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.4375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.5625;
    }

    @Override
    public Item toItem() {
        return new ItemChain();
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

