/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCrops;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockCropsStem
extends BlockCrops
implements Faceable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(GROWTH, CommonBlockProperties.FACING_DIRECTION);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected BlockCropsStem(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract int getFruitId();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract int getSeedsId();

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(CommonBlockProperties.FACING_DIRECTION);
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(CommonBlockProperties.FACING_DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getGrowth() {
        return this.getIntValue(GROWTH);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setGrowth(int growth) {
        this.setIntValue(GROWTH, growth);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            if (this.down().getId() != 60) {
                this.getLevel().useBreakOn(this);
                return 1;
            }
            BlockFace blockFace = this.getBlockFace();
            if (blockFace.getAxis().isHorizontal() && this.getSide(blockFace).getId() != this.getFruitId()) {
                this.setBlockFace(null);
                this.getLevel().setBlock(this, this);
                return 1;
            }
            return 0;
        }
        if (type != 2) {
            return 0;
        }
        if (ThreadLocalRandom.current().nextInt(1, 3) != 1 || this.getLevel().getFullLight(this) < 9) {
            return 2;
        }
        int growth = this.getGrowth();
        if (growth < GROWTH.getMaxValue()) {
            BlockCropsStem block = this.clone();
            block.setGrowth(growth + 1);
            BlockGrowEvent ev = new BlockGrowEvent(this, block);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.getLevel().setBlock((Vector3)this, ev.getNewState(), true);
            }
            return 2;
        }
        this.growFruit();
        return 2;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean growFruit() {
        int fruitId = this.getFruitId();
        for (BlockFace face : BlockFace.Plane.HORIZONTAL) {
            Block b = this.getSide(face);
            if (b.getId() != fruitId) continue;
            return false;
        }
        BlockFace sideFace = BlockFace.Plane.HORIZONTAL.random();
        Block side = this.getSide(sideFace);
        Block d = side.down();
        if (side.getId() == 0 && (d.getId() == 60 || d.getId() == 2 || d.getId() == 3)) {
            BlockGrowEvent ev = new BlockGrowEvent(side, Block.get(fruitId));
            Server.getInstance().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.getLevel().setBlock((Vector3)side, ev.getNewState(), true);
                this.setBlockFace(sideFace);
                this.getLevel().setBlock((Vector3)this, this, true);
            }
        }
        return true;
    }

    @Override
    public Item toItem() {
        return Item.get(this.getSeedsId());
    }

    @Override
    public Item[] getDrops(Item item) {
        return new Item[]{Item.get(this.getSeedsId(), 0, ThreadLocalRandom.current().nextInt(4))};
    }

    @Override
    public BlockCropsStem clone() {
        return (BlockCropsStem)super.clone();
    }
}

