/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockCauldron;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BlockDoor
extends BlockTransparentMeta
implements Faceable {
    private static final double THICKNESS = 0.1875;
    public static final BooleanBlockProperty UPPER_BLOCK = new BooleanBlockProperty("upper_block_bit", false);
    public static final BooleanBlockProperty DOOR_HINGE = new BooleanBlockProperty("door_hinge_bit", false);
    public static final BlockProperty<BlockFace> DOOR_DIRECTION = new ArrayBlockProperty("direction", false, (Serializable[])new BlockFace[]{BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH}).ordinal(true);
    protected static final BlockProperties PROPERTIES = new BlockProperties(DOOR_DIRECTION, CommonBlockProperties.OPEN, UPPER_BLOCK, DOOR_HINGE);
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="CommonBlockProperties.OPEN")
    public static final int DOOR_OPEN_BIT = PROPERTIES.getOffset(CommonBlockProperties.OPEN.getName());
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="UPPER_BLOCK")
    public static final int DOOR_TOP_BIT = PROPERTIES.getOffset(UPPER_BLOCK.getName());
    @Deprecated
    @DeprecationDetails(reason="Use the accessors or properties instead", since="1.4.0.0-PN", replaceWith="DOOR_HINGE")
    public static final int DOOR_HINGE_BIT = PROPERTIES.getOffset(DOOR_HINGE.getName());
    @Deprecated
    @DeprecationDetails(reason="Was removed from the game", since="1.4.0.0-PN", replaceWith="Level.isBlockPowered(block.getLocation())")
    public static final int DOOR_POWERED_BIT = PROPERTIES.getBitSize();

    protected BlockDoor(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Deprecated
    @DeprecationDetails(reason="Limited amount of state data", since="1.4.0.0-PN", replaceWith="getCurrentState()")
    public int getFullDamage() {
        return this.getSignedBigDamage();
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        BlockFace position = this.getBlockFace().getOpposite();
        boolean isOpen = this.isOpen();
        boolean isRight = this.isRightHinged();
        if (isOpen) {
            return this.recalculateBoundingBoxWithPos(isRight ? position.rotateYCCW() : position.rotateY());
        }
        return this.recalculateBoundingBoxWithPos(position);
    }

    private AxisAlignedBB recalculateBoundingBoxWithPos(BlockFace pos) {
        if (pos.getAxisDirection() == BlockFace.AxisDirection.NEGATIVE) {
            return new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0 + (double)pos.getXOffset() - 0.1875 * (double)pos.getXOffset(), this.y + 1.0, this.z + 1.0 + (double)pos.getZOffset() - 0.1875 * (double)pos.getZOffset());
        }
        return new SimpleAxisAlignedBB(this.x + (double)pos.getXOffset() - 0.1875 * (double)pos.getXOffset(), this.y, this.z + (double)pos.getZOffset() - 0.1875 * (double)pos.getZOffset(), this.x + 1.0, this.y + 1.0, this.z + 1.0);
    }

    @Override
    @PowerNukkitDifference(info="Will drop the iron door item if the support is broken", since="1.3.1.2-PN")
    public int onUpdate(int type) {
        if (type == 1) {
            this.onNormalUpdate();
            return type;
        }
        if (type == 6 && this.level.getServer().isRedstoneEnabled()) {
            this.onRedstoneUpdate();
            return type;
        }
        return 0;
    }

    private void onNormalUpdate() {
        Block down = this.down();
        if (this.isTop()) {
            boolean downIsOpen;
            if (down.getId() != this.getId() || down.getBooleanValue(UPPER_BLOCK)) {
                this.level.setBlock((Vector3)this, Block.get(0), false);
            }
            if ((downIsOpen = down.getBooleanValue(CommonBlockProperties.OPEN)) != this.isOpen()) {
                this.setOpen(downIsOpen);
                this.level.setBlock((Vector3)this, this, false, true);
            }
            return;
        }
        if (down.getId() == 0) {
            this.level.useBreakOn(this, this.getToolType() == 3 ? Item.get(278) : null);
        }
    }

    private void onRedstoneUpdate() {
        boolean isPowered = this.level.isBlockPowered(this.getLocation());
        if (this.isOpen() != isPowered) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
            this.toggle(null);
            this.playOpenCloseSound();
        }
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (this.y > 254.0 || face != BlockFace.UP) {
            return false;
        }
        Block blockUp = this.up();
        Block blockDown = this.down();
        if (!blockUp.canBeReplaced() || !blockDown.isSolid(BlockFace.UP) && !(blockDown instanceof BlockCauldron)) {
            return false;
        }
        BlockFace direction = player.getDirection();
        this.setBlockFace(direction);
        Block left = this.getSide(direction.rotateYCCW());
        Block right = this.getSide(direction.rotateY());
        if (left.getId() == this.getId() || !right.isTransparent() && left.isTransparent()) {
            this.setRightHinged(true);
        }
        this.setTop(false);
        this.level.setBlock((Vector3)block, this, true, false);
        if (blockUp instanceof BlockLiquid && ((BlockLiquid)blockUp).usesWaterLogging()) {
            this.level.setBlock(blockUp, 1, blockUp, true, false);
        }
        BlockDoor doorTop = (BlockDoor)this.clone();
        doorTop.y += 1.0;
        doorTop.setTop(true);
        this.level.setBlock((Vector3)doorTop, doorTop, true, true);
        this.level.updateAround(block);
        if (this.level.getServer().isRedstoneEnabled() && !this.isOpen() && this.level.isBlockPowered(this.getLocation())) {
            this.toggle(null);
        }
        return true;
    }

    @Override
    public boolean onBreak(Item item) {
        if (this.isTop()) {
            Block down = this.down();
            if (down.getId() == this.getId() && !down.getBooleanValue(UPPER_BLOCK)) {
                this.level.setBlock((Vector3)down, Block.get(0), true);
            }
        } else {
            Block up = this.up();
            if (up.getId() == this.getId() && up.getBooleanValue(UPPER_BLOCK)) {
                this.level.setBlock((Vector3)up, Block.get(0), true);
            }
        }
        this.getLevel().setBlock((Vector3)this, Block.get(0), true);
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (!this.toggle(player)) {
            return false;
        }
        this.playOpenCloseSound();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenCloseSound() {
        if (this.isOpen()) {
            this.playOpenSound();
        } else {
            this.playCloseSound();
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playCloseSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
    }

    public boolean toggle(Player player) {
        Block up;
        Block down;
        DoorToggleEvent event = new DoorToggleEvent(this, player);
        this.level.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (this.isTop()) {
            down = this.down();
            up = this;
        } else {
            down = this;
            up = this.up();
        }
        if (down.getId() == this.getId() && !down.getBooleanValue(UPPER_BLOCK) && up.getId() == this.getId() && up.getBooleanValue(UPPER_BLOCK)) {
            down.toggleBooleanProperty(CommonBlockProperties.OPEN);
            this.level.setBlock((Vector3)down, down, true, true);
        } else {
            this.toggleBooleanProperty(CommonBlockProperties.OPEN);
            this.level.setBlock((Vector3)this, this, true, true);
        }
        return true;
    }

    public boolean isOpen() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOpen(boolean open) {
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
    }

    public boolean isTop() {
        return this.getBooleanValue(UPPER_BLOCK);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTop(boolean top) {
        this.setBooleanValue(UPPER_BLOCK, top);
    }

    @Deprecated
    @DeprecationDetails(reason="Use the properties API instead", since="1.4.0.0-PN")
    public boolean isTop(int meta) {
        return PROPERTIES.getBooleanValue(meta, UPPER_BLOCK.getName());
    }

    public boolean isRightHinged() {
        return this.getBooleanValue(DOOR_HINGE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setRightHinged(boolean rightHinged) {
        this.setBooleanValue(DOOR_HINGE, rightHinged);
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getPropertyValue(DOOR_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(DOOR_DIRECTION, face);
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

