/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockDoubleSlabBase;
import cn.nukkit.block.BlockSlabWood;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitDifference(info="Extends BlockDoubleSlabBase only in PowerNukkit")
public class BlockDoubleSlabWood
extends BlockDoubleSlabBase {
    public BlockDoubleSlabWood() {
        this(0);
    }

    public BlockDoubleSlabWood(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 157;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return BlockSlabWood.PROPERTIES;
    }

    public WoodType getWoodType() {
        return this.getPropertyValue(WoodType.PROPERTY);
    }

    public void setWoodType(WoodType type) {
        this.setPropertyValue(WoodType.PROPERTY, type);
    }

    @Override
    public String getSlabName() {
        return this.getWoodType().getEnglishName();
    }

    @Override
    public String getName() {
        return "Double " + this.getSlabName() + " Wood Slab";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public int getSingleSlabId() {
        return 158;
    }

    @Override
    protected boolean isCorrectTool(Item item) {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return this.getWoodType().getColor();
    }
}

