/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.LevelException;
import cn.nukkit.utils.MainLogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jdk.nashorn.internal.objects.annotations.Getter;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public interface BlockEntityHolder<E extends BlockEntity> {
    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public E getBlockEntity() {
        Level level = this.getLevel();
        if (level == null) {
            throw new LevelException("Undefined Level reference");
        }
        BlockEntity blockEntity = this instanceof Vector3 ? level.getBlockEntity((Vector3)((Object)this)) : (this instanceof BlockVector3 ? level.getBlockEntity((BlockVector3)((Object)this)) : level.getBlockEntity(new BlockVector3(this.getFloorX(), this.getFloorY(), this.getFloorZ())));
        Class<E> blockEntityClass = this.getBlockEntityClass();
        if (blockEntityClass.isInstance(blockEntity)) {
            return (E)((BlockEntity)blockEntityClass.cast(blockEntity));
        }
        return null;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public E createBlockEntity() {
        return this.createBlockEntity(null, new Object[0]);
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public E createBlockEntity(@Nullable CompoundTag initialData, Object ... args) {
        String typeName = this.getBlockEntityType();
        FullChunk chunk = this.getChunk();
        if (chunk == null) {
            throw new LevelException("Undefined Level or chunk reference");
        }
        initialData = initialData == null ? new CompoundTag() : initialData.copy();
        BlockEntity created = BlockEntity.createBlockEntity(typeName, chunk, initialData.putString("id", typeName).putInt("x", this.getFloorX()).putInt("y", this.getFloorY()).putInt("z", this.getFloorZ()), args);
        Class<E> entityClass = this.getBlockEntityClass();
        if (!entityClass.isInstance(created)) {
            String error = "Failed to create the block entity " + typeName + " of class " + entityClass + " at " + this.getLocation() + ", the created type is not an instance of the requested class. Created: " + created;
            if (created != null) {
                created.close();
            }
            throw new IllegalStateException(error);
        }
        return (E)((BlockEntity)entityClass.cast(created));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public E getOrCreateBlockEntity() {
        E blockEntity = this.getBlockEntity();
        if (blockEntity != null) {
            return blockEntity;
        }
        return this.createBlockEntity();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Class<? extends E> getBlockEntityClass();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType();

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public FullChunk getChunk();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getFloorX();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getFloorY();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getFloorZ();

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Location getLocation();

    @Getter
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Level getLevel();

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static <E extends BlockEntity, H extends BlockEntityHolder<E>> E setBlockAndCreateEntity(@Nonnull H holder) {
        return BlockEntityHolder.setBlockAndCreateEntity(holder, true, true);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static <E extends BlockEntity, H extends BlockEntityHolder<E>> E setBlockAndCreateEntity(@Nonnull H holder, boolean direct, boolean update) {
        return BlockEntityHolder.setBlockAndCreateEntity(holder, direct, update, null, new Object[0]);
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static <E extends BlockEntity, H extends BlockEntityHolder<E>> E setBlockAndCreateEntity(@Nonnull H holder, boolean direct, boolean update, @Nullable CompoundTag initialData, Object ... args) {
        Block block = holder.getBlock();
        Level level = block.getLevel();
        Block layer0 = level.getBlock((Vector3)block, 0);
        Block layer1 = level.getBlock((Vector3)block, 1);
        if (level.setBlock((Vector3)block, block, direct, update)) {
            try {
                return holder.createBlockEntity(initialData, args);
            }
            catch (Exception e) {
                MainLogger.getLogger().warning("Failed to create block entity " + holder.getBlockEntityType() + " at " + holder.getLocation(), e);
                level.setBlock(layer0, 0, layer0, direct, update);
                level.setBlock(layer1, 1, layer1, direct, update);
                throw e;
            }
        }
        return null;
    }

    default public Block getBlock() {
        if (this instanceof Position) {
            return ((Position)((Object)this)).getLevelBlock();
        }
        if (this instanceof Vector3) {
            return this.getLevel().getBlock((Vector3)((Object)this));
        }
        return this.getLevel().getBlock(this.getFloorX(), this.getFloorY(), this.getFloorZ());
    }
}

