/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class BlockFlower
extends BlockFlowable {
    public static final int TYPE_POPPY = 0;
    public static final int TYPE_BLUE_ORCHID = 1;
    public static final int TYPE_ALLIUM = 2;
    public static final int TYPE_AZURE_BLUET = 3;
    public static final int TYPE_RED_TULIP = 4;
    public static final int TYPE_ORANGE_TULIP = 5;
    public static final int TYPE_WHITE_TULIP = 6;
    public static final int TYPE_PINK_TULIP = 7;
    public static final int TYPE_OXEYE_DAISY = 8;

    public BlockFlower() {
        this(0);
    }

    public BlockFlower(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 38;
    }

    @Override
    public String getName() {
        String[] names = new String[]{"Poppy", "Blue Orchid", "Allium", "Azure Bluet", "Red Tulip", "Orange Tulip", "White Tulip", "Pink Tulip", "Oxeye Daisy", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"};
        return names[this.getDamage() & 0xF];
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static boolean isSupportValid(Block block) {
        switch (block.getId()) {
            case 2: 
            case 3: 
            case 60: 
            case 243: {
                return true;
            }
        }
        return false;
    }

    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean canPlantOn(Block block) {
        return BlockFlower.isSupportValid(block);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        if (this.canPlantOn(down)) {
            this.getLevel().setBlock((Vector3)block, this, true);
            return true;
        }
        return false;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will break on normal update if the supporting block is invalid")
    public int onUpdate(int type) {
        if (type == 1 && !this.canPlantOn(this.down())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            if (player != null && (player.gamemode & 1) == 0) {
                --item.count;
            }
            this.level.addParticle(new BoneMealParticle(this));
            for (int i = 0; i < 8; ++i) {
                Position vec = this.add(ThreadLocalRandom.current().nextInt(-3, 4), ThreadLocalRandom.current().nextInt(-1, 2), ThreadLocalRandom.current().nextInt(-3, 4));
                if (this.level.getBlock(vec).getId() != 0 || this.level.getBlock(vec.down()).getId() != 2 || !(vec.getY() >= 0.0) || !(vec.getY() < 256.0)) continue;
                if (ThreadLocalRandom.current().nextInt(10) == 0) {
                    this.level.setBlock((Vector3)vec, this.getUncommonFlower(), true);
                    continue;
                }
                this.level.setBlock((Vector3)vec, BlockFlower.get(this.getId()), true);
            }
            return true;
        }
        return false;
    }

    protected Block getUncommonFlower() {
        return BlockFlower.get(37);
    }
}

