/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLeaves;
import cn.nukkit.block.BlockLever;
import cn.nukkit.blockentity.BlockEntityFlowerPot;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemFlowerPot;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockFlowerPot
extends BlockFlowable
implements BlockEntityHolder<BlockEntityFlowerPot> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockProperties PROPERTIES = new BlockProperties(BlockLeaves.UPDATE);

    public BlockFlowerPot() {
        this(0);
    }

    public BlockFlowerPot(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    protected static boolean canPlaceIntoFlowerPot(int id) {
        switch (id) {
            case 6: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 81: 
            case 418: 
            case 471: 
            case 478: 
            case 479: 
            case 483: 
            case 484: {
                return true;
            }
        }
        return false;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public String getName() {
        return "Flower Pot";
    }

    @Override
    public int getId() {
        return 140;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityFlowerPot> getBlockEntityClass() {
        return BlockEntityFlowerPot.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "FlowerPot";
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public int onUpdate(int type) {
        if (type == 1 && !BlockLever.isSupportValid(this.down(), BlockFace.UP)) {
            this.level.useBreakOn(this);
            return type;
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockLever.isSupportValid(this.down(), BlockFace.UP)) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putShort("item", 0).putInt("data", 0);
        if (item.hasCustomBlockData()) {
            for (Tag aTag : item.getCustomBlockData().getAllTags()) {
                nbt.put(aTag.getName(), aTag);
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Item getFlower() {
        BlockEntityFlowerPot blockEntity = (BlockEntityFlowerPot)this.getBlockEntity();
        if (blockEntity == null) {
            return Item.get(0, 0, 0);
        }
        int id = blockEntity.namedTag.getShort("item");
        if (id == 0) {
            return Item.get(0, 0, 0);
        }
        int data = blockEntity.namedTag.getInt("data");
        return Item.get(id, data, 1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setFlower(@Nullable Item item) {
        if (item == null || item.getId() == 0) {
            this.removeFlower();
            return true;
        }
        BlockEntityFlowerPot blockEntity = (BlockEntityFlowerPot)this.getOrCreateBlockEntity();
        int contentId = item.getBlockId();
        if (!(contentId != -1 && BlockFlowerPot.canPlaceIntoFlowerPot(contentId) || BlockFlowerPot.canPlaceIntoFlowerPot(contentId = item.getId()))) {
            return false;
        }
        int itemMeta = item.getDamage();
        blockEntity.namedTag.putShort("item", contentId);
        blockEntity.namedTag.putInt("data", itemMeta);
        this.setBooleanValue(BlockLeaves.UPDATE, true);
        this.getLevel().setBlock((Vector3)this, this, true);
        blockEntity.spawnToAll();
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void removeFlower() {
        BlockEntityFlowerPot blockEntity = (BlockEntityFlowerPot)this.getOrCreateBlockEntity();
        blockEntity.namedTag.putShort("item", 0);
        blockEntity.namedTag.putInt("data", 0);
        this.setBooleanValue(BlockLeaves.UPDATE, false);
        this.getLevel().setBlock((Vector3)this, this, true);
        blockEntity.spawnToAll();
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (this.getBooleanValue(BlockLeaves.UPDATE)) {
            if (player == null) {
                return false;
            }
            Item flower = this.getFlower();
            if (flower.getId() != 0) {
                this.removeFlower();
                player.giveItem(flower);
                return true;
            }
        }
        if (item.isNull()) {
            return false;
        }
        BlockEntityFlowerPot blockEntity = (BlockEntityFlowerPot)this.getOrCreateBlockEntity();
        if (blockEntity.namedTag.getShort("item") != 0 || blockEntity.namedTag.getInt("mData") != 0) {
            return false;
        }
        if (!this.setFlower(item)) {
            return false;
        }
        if (player == null || !player.isCreative()) {
            --item.count;
        }
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        boolean dropInside = false;
        int insideID = 0;
        int insideMeta = 0;
        BlockEntityFlowerPot blockEntity = (BlockEntityFlowerPot)this.getBlockEntity();
        if (blockEntity != null) {
            dropInside = true;
            insideID = blockEntity.namedTag.getShort("item");
            insideMeta = blockEntity.namedTag.getInt("data");
        }
        if (dropInside) {
            return new Item[]{new ItemFlowerPot(), BlockState.of(insideID, insideMeta).getBlock(this).toItem()};
        }
        return new Item[]{new ItemFlowerPot()};
    }

    @Override
    protected AxisAlignedBB recalculateBoundingBox() {
        return this;
    }

    @Override
    public double getMinX() {
        return this.x + 0.3125;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.3125;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.6875;
    }

    @Override
    public double getMaxY() {
        return this.y + 0.375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.6875;
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemFlowerPot();
    }
}

