/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockGrass;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockGrassPath
extends BlockGrass {
    @Override
    public int getId() {
        return 198;
    }

    @Override
    public String getName() {
        return "Grass Path";
    }

    @Override
    public int getToolType() {
        return 2;
    }

    @Override
    public double getMaxY() {
        return this.y + 1.0;
    }

    @Override
    public double getResistance() {
        return 3.25;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.DIRT_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public int onUpdate(int type) {
        return 0;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isHoe()) {
            item.useOn(this);
            this.getLevel().setBlock((Vector3)this, BlockGrassPath.get(60), true);
            if (player != null) {
                player.getLevel().addSound(player, Sound.USE_GRASS);
            }
            return true;
        }
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return true;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Will return true")
    public boolean isTransparent() {
        return true;
    }
}

