/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockIceFrosted;
import cn.nukkit.block.BlockWater;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.event.block.BlockGrowEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemKelp;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@PowerNukkitOnly
public class BlockKelp
extends BlockFlowable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty KELP_AGE = new IntBlockProperty("kelp_age", false, 25);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(KELP_AGE);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockKelp() {
        this(0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockKelp(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 393;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Kelp";
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getAge() {
        return this.getIntValue(KELP_AGE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setAge(int age) {
        this.setIntValue(KELP_AGE, age);
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        Block down = this.down();
        Block layer1Block = block.getLevelBlockAtLayer(1);
        if ((down.getId() == 393 || down.isSolid()) && down.getId() != 213 && down.getId() != 79 && down.getId() != 88 && layer1Block instanceof BlockWater && ((BlockWater)layer1Block).isSourceOrFlowingDown()) {
            if (((BlockWater)layer1Block).isFlowingDown()) {
                this.getLevel().setBlock(this, 1, BlockKelp.get(8), true, false);
            }
            int maxAge = KELP_AGE.getMaxValue();
            if (down.getId() == 393 && down.getIntValue(KELP_AGE) != maxAge - 1) {
                down.setIntValue(KELP_AGE, maxAge - 1);
                this.getLevel().setBlock((Vector3)down, down, true, true);
            }
            this.setAge(ThreadLocalRandom.current().nextInt(maxAge));
            this.getLevel().setBlock((Vector3)this, this, true, true);
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 1) {
            Block blockLayer1 = this.getLevelBlockAtLayer(1);
            if (!(blockLayer1 instanceof BlockIceFrosted || blockLayer1 instanceof BlockWater && ((BlockWater)blockLayer1).isSourceOrFlowingDown())) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            Block down = this.down();
            if (!down.isSolid() && down.getId() != 393 || down.getId() == 213 || down.getId() == 79 || down.getId() == 88) {
                this.getLevel().useBreakOn(this);
                return type;
            }
            if (blockLayer1 instanceof BlockWater && ((BlockWater)blockLayer1).isFlowingDown()) {
                this.getLevel().setBlock(this, 1, BlockKelp.get(8), true, false);
            }
            return type;
        }
        if (type == 2) {
            if (ThreadLocalRandom.current().nextInt(100) <= 14) {
                this.grow();
            }
            return type;
        }
        return super.onUpdate(type);
    }

    @PowerNukkitOnly
    public boolean grow() {
        Block up;
        int maxValue;
        int age = this.getAge();
        if (age < (maxValue = KELP_AGE.getMaxValue()) && (up = this.up()) instanceof BlockWater && ((BlockWater)up).isSourceOrFlowingDown()) {
            Block grown = BlockState.of(393, age + 1).getBlock();
            BlockGrowEvent ev = new BlockGrowEvent(this, grown);
            Server.getInstance().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.setAge(maxValue);
                this.getLevel().setBlock(this, 0, this, true, true);
                this.getLevel().setBlock(up, 1, BlockKelp.get(8), true, false);
                this.getLevel().setBlock(up, 0, ev.getNewState(), true, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onBreak(Item item) {
        Block down = this.down();
        if (down.getId() == 393) {
            this.getLevel().setBlock((Vector3)down, BlockState.of(393, ThreadLocalRandom.current().nextInt(KELP_AGE.getMaxValue())).getBlock(), true, true);
        }
        this.getLevel().setBlock((Vector3)this, BlockKelp.get(0), true, true);
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (item.isFertilizer()) {
            int x = (int)this.x;
            int z = (int)this.z;
            for (int y = (int)this.y + 1; y < 255; ++y) {
                BlockKelp highestKelp;
                BlockState blockStateAbove = this.getLevel().getBlockStateAt(x, y, z);
                int blockIdAbove = blockStateAbove.getBlockId();
                if (blockIdAbove == 393) continue;
                if ((blockIdAbove == 8 || blockIdAbove == 9) && ((BlockWater)blockStateAbove.getBlock()).isSourceOrFlowingDown() && (highestKelp = (BlockKelp)this.getLevel().getBlock(x, y - 1, z)).grow()) {
                    this.level.addParticle(new BoneMealParticle(this));
                    if (player != null && (player.gamemode & 1) == 0) {
                        --item.count;
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Item toItem() {
        return new ItemKelp();
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 2;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }
}

