/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.block.BlockWood;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.event.block.LeavesDecayEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Hash;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockLeaves
extends BlockTransparentMeta {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final ArrayBlockProperty<WoodType> OLD_LEAF_TYPE = new ArrayBlockProperty("old_leaf_type", true, (Serializable[])new WoodType[]{WoodType.OAK, WoodType.SPRUCE, WoodType.BIRCH, WoodType.JUNGLE});
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty PERSISTENT = new BooleanBlockProperty("persistent_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BooleanBlockProperty UPDATE = new BooleanBlockProperty("update_bit", false);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties OLD_LEAF_PROPERTIES = new BlockProperties(OLD_LEAF_TYPE, PERSISTENT, UPDATE);
    private static final BlockFace[] VISIT_ORDER = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN, BlockFace.UP};
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic value. Use the accessors instead")
    public static final int OAK = 0;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic value. Use the accessors instead")
    public static final int SPRUCE = 1;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic value. Use the accessors instead")
    public static final int BIRCH = 2;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic value. Use the accessors instead")
    public static final int JUNGLE = 3;

    public BlockLeaves() {
        this(0);
    }

    public BlockLeaves(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return OLD_LEAF_PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 0.2;
    }

    @Override
    public int getToolType() {
        return 6;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WoodType getType() {
        return this.getPropertyValue(OLD_LEAF_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setType(WoodType type) {
        this.setPropertyValue(OLD_LEAF_TYPE, type);
    }

    @Override
    public String getName() {
        return this.getType().getEnglishName() + " Leaves";
    }

    @Override
    public int getBurnChance() {
        return 30;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public int getBurnAbility() {
        return 60;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        this.setPersistent(true);
        this.getLevel().setBlock((Vector3)this, this, true);
        return true;
    }

    @Override
    public Item[] getDrops(Item item) {
        int saplingOdds;
        int stickOdds;
        int appleOdds;
        if (item.isShears()) {
            return new Item[]{this.toItem()};
        }
        ArrayList<Item> drops = new ArrayList<Item>(1);
        Enchantment fortuneEnchantment = item.getEnchantment(18);
        int fortune = fortuneEnchantment != null ? fortuneEnchantment.getLevel() : 0;
        switch (fortune) {
            case 0: {
                appleOdds = 200;
                stickOdds = 50;
                saplingOdds = this.getType() == WoodType.JUNGLE ? 40 : 20;
                break;
            }
            case 1: {
                appleOdds = 180;
                stickOdds = 45;
                saplingOdds = this.getType() == WoodType.JUNGLE ? 36 : 16;
                break;
            }
            case 2: {
                appleOdds = 160;
                stickOdds = 40;
                saplingOdds = this.getType() == WoodType.JUNGLE ? 32 : 12;
                break;
            }
            default: {
                appleOdds = 120;
                stickOdds = 30;
                saplingOdds = this.getType() == WoodType.JUNGLE ? 24 : 10;
            }
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (this.canDropApple() && random.nextInt(appleOdds) == 0) {
            drops.add(Item.get(260));
        }
        if (random.nextInt(stickOdds) == 0) {
            drops.add(Item.get(280));
        }
        if (random.nextInt(saplingOdds) == 0) {
            drops.add(this.getSapling());
        }
        return drops.toArray(Item.EMPTY_ARRAY);
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2) {
            if (this.isCheckDecay()) {
                if (this.isPersistent() || this.findLog(this, 7, null).booleanValue()) {
                    this.setCheckDecay(false);
                    this.getLevel().setBlock((Vector3)this, this, false, false);
                } else {
                    LeavesDecayEvent ev = new LeavesDecayEvent(this);
                    Server.getInstance().getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.getLevel().useBreakOn(this);
                    }
                }
                return type;
            }
        } else if (type == 1 || type == 3) {
            if (!this.isCheckDecay()) {
                this.setCheckDecay(true);
                this.getLevel().setBlock((Vector3)this, this, false, false);
            }
            for (BlockFace side : BlockFace.values()) {
                BlockLeaves otherLeave;
                Block other = this.getSide(side);
                if (!(other instanceof BlockLeaves) || (otherLeave = (BlockLeaves)other).isCheckDecay()) continue;
                this.getLevel().scheduleUpdate(otherLeave, 2);
            }
            return type;
        }
        return type;
    }

    private Boolean findLog(Block current, int distance, Long2LongMap visited) {
        if (visited == null) {
            visited = new Long2LongOpenHashMap();
            visited.defaultReturnValue(-1L);
        }
        if (current instanceof BlockWood) {
            return true;
        }
        if (distance == 0 || !(current instanceof BlockLeaves)) {
            return false;
        }
        long hash = Hash.hashBlock(current);
        if (visited.get(hash) >= (long)distance) {
            return false;
        }
        visited.put(hash, distance);
        for (BlockFace face : VISIT_ORDER) {
            if (!this.findLog(current.getSide(face), distance - 1, visited).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckDecay() {
        return this.getBooleanValue(UPDATE);
    }

    public void setCheckDecay(boolean checkDecay) {
        this.setBooleanValue(UPDATE, checkDecay);
    }

    public boolean isPersistent() {
        return this.getBooleanValue(PERSISTENT);
    }

    public void setPersistent(boolean persistent) {
        this.setBooleanValue(PERSISTENT, persistent);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.FOLIAGE_BLOCK_COLOR;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    protected boolean canDropApple() {
        return this.getType() == WoodType.OAK;
    }

    protected Item getSapling() {
        return Item.get(6, this.getIntValue(OLD_LEAF_TYPE));
    }

    @Override
    public boolean diffusesSkyLight() {
        return true;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }
}

