/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.blockentity.BlockEntityLodestone;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemCompassLodestone;
import cn.nukkit.level.Sound;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.MainLogger;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockLodestone
extends BlockSolid
implements BlockEntityHolder<BlockEntityLodestone> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockLodestone() {
    }

    @Override
    public int getId() {
        return 477;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityLodestone> getBlockEntityClass() {
        return BlockEntityLodestone.class;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public String getBlockEntityType() {
        return "Lodestone";
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        return BlockEntityHolder.setBlockAndCreateEntity(this) != null;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        int trackingHandle;
        if (player == null || item.isNull() || item.getId() != 345 && item.getId() != 741) {
            return false;
        }
        ItemCompassLodestone compass = (ItemCompassLodestone)Item.get(741);
        if (item.hasCompoundTag()) {
            compass.setCompoundTag((byte[])item.getCompoundTag().clone());
        }
        try {
            trackingHandle = ((BlockEntityLodestone)this.getOrCreateBlockEntity()).requestTrackingHandler();
            compass.setTrackingHandle(trackingHandle);
        }
        catch (Exception e) {
            MainLogger.getLogger().warning("Could not create a lodestone compass to " + this.getLocation() + " for " + player.getName(), e);
            return false;
        }
        boolean added = true;
        if (item.getCount() == 1) {
            player.getInventory().setItemInHand(compass);
        } else {
            Item clone = item.clone();
            --clone.count;
            player.getInventory().setItemInHand(clone);
            for (Item failed : player.getInventory().addItem(compass)) {
                added = false;
                player.getLevel().dropItem(player.getPosition(), failed);
            }
        }
        this.getLevel().addSound(player.getPosition(), Sound.LODESTONE_COMPASS_LINK_COMPASS_TO_LODESTONE);
        if (added) {
            try {
                this.getLevel().getServer().getPositionTrackingService().startTracking(player, trackingHandle, false);
            }
            catch (IOException e) {
                MainLogger.getLogger().warning("Make the player " + player.getName() + " track " + trackingHandle + " at " + this.getLocation(), e);
            }
            this.getLevel().getServer().getScheduler().scheduleTask(null, player::updateTrackingPositions);
        }
        return true;
    }

    @Override
    public String getName() {
        return "Lodestone";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 3.5;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.IRON_BLOCK_COLOR;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }
}

