/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.level.generator.object.ObjectNyliumVegetation;
import cn.nukkit.level.particle.BoneMealParticle;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BlockNylium
extends BlockSolid {
    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 2 && !this.up().isTransparent()) {
            this.level.setBlock((Vector3)this, Block.get(87), false);
            return type;
        }
        return 0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        Block up = this.up();
        if (item.isNull() || !item.isFertilizer() || up.getId() != 0) {
            return false;
        }
        if (player != null && !player.isCreative()) {
            --item.count;
        }
        this.grow();
        this.level.addParticle(new BoneMealParticle(up));
        return true;
    }

    public boolean grow() {
        ObjectNyliumVegetation.growVegetation(this.level, this, new NukkitRandom());
        return true;
    }

    @Override
    public double getResistance() {
        return 0.4;
    }

    @Override
    public double getHardness() {
        return 0.4;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{Item.get(87)};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

