/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BlockColor;

public class BlockObsidian
extends BlockSolid {
    @Override
    public String getName() {
        return "Obsidian";
    }

    @Override
    public int getId() {
        return 49;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public int getToolTier() {
        return 5;
    }

    @Override
    public double getHardness() {
        return 35.0;
    }

    @Override
    public double getResistance() {
        return 6000.0;
    }

    @Override
    public boolean onBreak(Item item) {
        Block[] nearby;
        for (Block aNearby : nearby = new Block[]{this.up(), this.down(), this.north(), this.south(), this.west(), this.east()}) {
            if (aNearby == null || aNearby.getId() != 90) continue;
            aNearby.onBreak(item);
        }
        return super.onBreak(item);
    }

    @Override
    @Since(value="1.2.1.0-PN")
    @PowerNukkitOnly
    public void afterRemoval(Block newBlock, boolean update) {
        if (update) {
            this.onBreak(Item.get(0));
        }
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.OBSIDIAN_BLOCK_COLOR;
    }

    @Override
    public boolean canBePushed() {
        return false;
    }

    @Override
    public boolean canBePulled() {
        return false;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

