/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.utils.BlockColor;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockOreGoldNether
extends BlockSolid {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockOreGoldNether() {
    }

    @Override
    public int getId() {
        return 543;
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 3.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return "Nether Gold Ore";
    }

    @Override
    public Item[] getDrops(Item item) {
        if (!item.isPickaxe() || item.getTier() < 1) {
            return Item.EMPTY_ARRAY;
        }
        Enchantment enchantment = item.getEnchantment(18);
        int fortune = 0;
        if (enchantment != null) {
            fortune = enchantment.getLevel();
        }
        NukkitRandom nukkitRandom = new NukkitRandom();
        int count = nukkitRandom.nextRange(2, 6);
        switch (fortune) {
            case 0: {
                break;
            }
            case 1: {
                if (nukkitRandom.nextRange(0, 2) != 0) break;
                count *= 2;
                break;
            }
            case 2: {
                if (nukkitRandom.nextRange(0, 1) != 0) break;
                count *= nukkitRandom.nextRange(2, 3);
                break;
            }
            default: {
                if (nukkitRandom.nextRange(0, 4) >= 3) break;
                count *= nukkitRandom.nextRange(2, 4);
            }
        }
        return new Item[]{Item.get(371, 0, count)};
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean canSilkTouch() {
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }
}

