/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockPlanks
extends BlockSolidMeta {
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;
    public static final int ACACIA = 4;
    public static final int DARK_OAK = 5;
    public static final BlockProperties PROPERTIES = new BlockProperties(WoodType.PROPERTY);

    public BlockPlanks() {
        this(0);
    }

    public BlockPlanks(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 20;
    }

    @Override
    public String getName() {
        return this.getWoodType().getEnglishName() + " Wood Planks";
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WoodType getWoodType() {
        return this.getPropertyValue(WoodType.PROPERTY);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWoodType(WoodType type) {
        this.setPropertyValue(WoodType.PROPERTY, type);
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    public BlockColor getColor() {
        return this.getWoodType().getColor();
    }
}

