/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLever;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Event;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.entity.EntityInteractEvent;
import cn.nukkit.event.player.PlayerInteractEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemTool;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import javax.annotation.Nonnull;

public abstract class BlockPressurePlateBase
extends BlockFlowable {
    public static final BlockProperties PROPERTIES = new BlockProperties(CommonBlockProperties.REDSTONE_SIGNAL);
    protected float onPitch;
    protected float offPitch;

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    protected BlockPressurePlateBase() {
        this(0);
    }

    protected BlockPressurePlateBase(int meta) {
        super(meta);
    }

    @Override
    public boolean canPassThrough() {
        return true;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public double getMinX() {
        return this.x + 0.625;
    }

    @Override
    public double getMinZ() {
        return this.z + 0.625;
    }

    @Override
    public double getMinY() {
        return this.y + 0.0;
    }

    @Override
    public double getMaxX() {
        return this.x + 0.9375;
    }

    @Override
    public double getMaxZ() {
        return this.z + 0.9375;
    }

    @Override
    public double getMaxY() {
        return this.isActivated() ? this.y + 0.03125 : this.y + 0.0625;
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    public boolean isActivated() {
        return this.getRedstonePower() == 0;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")})
    public int onUpdate(int type) {
        int power;
        if (type == 1) {
            if (!BlockLever.isSupportValid(this.down(), BlockFace.UP)) {
                this.level.useBreakOn(this, ItemTool.getBestTool(this.getToolType()));
            }
        } else if (type == 3 && (power = this.getRedstonePower()) > 0) {
            this.updateState(power);
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference.DifferenceList(value={@PowerNukkitDifference(info="Allow to be placed on top of the walls", since="1.3.0.0-PN"), @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed support logic")})
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (!BlockLever.isSupportValid(this.down(), BlockFace.UP)) {
            return false;
        }
        this.level.setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    protected AxisAlignedBB recalculateCollisionBoundingBox() {
        return new SimpleAxisAlignedBB(this.x + 0.125, this.y, this.z + 0.125, this.x + 0.875, this.y + 0.25, this.z + 0.875);
    }

    @Override
    public void onEntityCollide(Entity entity) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return;
        }
        int power = this.getRedstonePower();
        if (power == 0) {
            Event ev = entity instanceof Player ? new PlayerInteractEvent((Player)entity, null, this, null, PlayerInteractEvent.Action.PHYSICAL) : new EntityInteractEvent(entity, this);
            this.level.getServer().getPluginManager().callEvent(ev);
            if (!ev.isCancelled()) {
                this.updateState(power);
            }
        }
    }

    protected void updateState(int oldStrength) {
        boolean isPowered;
        int strength = this.computeRedstoneStrength();
        boolean wasPowered = oldStrength > 0;
        boolean bl = isPowered = strength > 0;
        if (oldStrength != strength) {
            this.setRedstonePower(strength);
            this.level.setBlock((Vector3)this, this, false, false);
            this.level.updateAroundRedstone(this, null);
            this.level.updateAroundRedstone(this.getLocation().down(), null);
            if (!isPowered && wasPowered) {
                this.playOffSound();
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 15, 0));
            } else if (isPowered && !wasPowered) {
                this.playOnSound();
                this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, 0, 15));
            }
        }
        if (isPowered) {
            this.level.scheduleUpdate(this, 20);
        }
    }

    @Override
    public boolean onBreak(Item item) {
        this.level.setBlock((Vector3)this, Block.get(0), true, true);
        if (this.getRedstonePower() > 0) {
            this.level.updateAroundRedstone(this, null);
            this.level.updateAroundRedstone(this.getLocation().down(), null);
        }
        return true;
    }

    @Override
    public int getWeakPower(BlockFace side) {
        return this.getRedstonePower();
    }

    @Override
    public int getStrongPower(BlockFace side) {
        return side == BlockFace.UP ? this.getRedstonePower() : 0;
    }

    public int getRedstonePower() {
        return this.getPropertyValue(CommonBlockProperties.REDSTONE_SIGNAL);
    }

    public void setRedstonePower(int power) {
        this.setIntValue(CommonBlockProperties.REDSTONE_SIGNAL, power);
    }

    protected void playOnSound() {
        this.level.addLevelSoundEvent(this.add(0.5, 0.1, 0.5), 73, GlobalBlockPalette.getOrCreateRuntimeId(this.getId(), this.getDamage()));
    }

    protected void playOffSound() {
        this.level.addLevelSoundEvent(this.add(0.5, 0.1, 0.5), 74, GlobalBlockPalette.getOrCreateRuntimeId(this.getId(), this.getDamage()));
    }

    protected abstract int computeRedstoneStrength();
}

