/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.block.BlockSolidMeta;
import cn.nukkit.utils.BlockColor;

public class BlockPrismarine
extends BlockSolidMeta {
    public static final int NORMAL = 0;
    public static final int DARK = 1;
    public static final int BRICKS = 2;
    private static final String[] NAMES = new String[]{"Prismarine", "Dark prismarine", "Prismarine bricks"};

    public BlockPrismarine() {
        this(0);
    }

    public BlockPrismarine(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 168;
    }

    @Override
    public double getHardness() {
        return 1.5;
    }

    @Override
    public double getResistance() {
        return 30.0;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public String getName() {
        return NAMES[this.getDamage() > 2 ? 0 : this.getDamage()];
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public BlockColor getColor() {
        switch (this.getDamage() & 7) {
            case 0: {
                return BlockColor.CYAN_BLOCK_COLOR;
            }
            case 1: 
            case 2: {
                return BlockColor.DIAMOND_BLOCK_COLOR;
            }
        }
        return BlockColor.STONE_BLOCK_COLOR;
    }
}

