/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockSlabBlackstone
extends BlockSlab {
    public BlockSlabBlackstone() {
        this(0);
    }

    public BlockSlabBlackstone(int meta) {
        super(meta, 538);
    }

    @Override
    public int getId() {
        return 537;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return SIMPLE_SLAB_PROPERTIES;
    }

    @Override
    public String getSlabName() {
        return "Blackstone Slab";
    }

    @Override
    public boolean isSameType(BlockSlab slab) {
        return slab.getId() == this.getId();
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    public double getResistance() {
        return 6.0;
    }

    @Override
    public Item[] getDrops(Item item) {
        if (item.isPickaxe() && item.getTier() >= 1) {
            return new Item[]{this.toItem()};
        }
        return Item.EMPTY_ARRAY;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.BLACK_BLOCK_COLOR;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

