/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockSlab;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.value.StoneSlab1Type;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

public class BlockSlabStone
extends BlockSlab {
    public static final BlockProperties PROPERTIES = new BlockProperties(StoneSlab1Type.PROPERTY, TOP_SLOT_PROPERTY);
    public static final int STONE = 0;
    public static final int SANDSTONE = 1;
    public static final int WOODEN = 2;
    public static final int COBBLESTONE = 3;
    public static final int BRICK = 4;
    public static final int STONE_BRICK = 5;
    public static final int QUARTZ = 6;
    public static final int NETHER_BRICK = 7;

    public BlockSlabStone() {
        this(0);
    }

    public BlockSlabStone(int meta) {
        super(meta, 43);
    }

    @Override
    public int getId() {
        return 44;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getSlabName() {
        return this.getSlabType().getEnglishName();
    }

    @Override
    public boolean isSameType(BlockSlab slab) {
        return slab.getId() == this.getId() && this.getSlabType().equals((Object)slab.getPropertyValue(StoneSlab1Type.PROPERTY));
    }

    @Override
    public int getToolTier() {
        return 1;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    public StoneSlab1Type getSlabType() {
        return this.getPropertyValue(StoneSlab1Type.PROPERTY);
    }

    public void setSlabType(StoneSlab1Type type) {
        this.setPropertyValue(StoneSlab1Type.PROPERTY, type);
    }

    @Override
    public BlockColor getColor() {
        return this.getSlabType().getColor();
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }
}

