/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.item.Item;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BlockStairs
extends BlockTransparentMeta
implements Faceable {
    public static final BooleanBlockProperty UPSIDE_DOWN = new BooleanBlockProperty("upside_down_bit", false);
    public static final BlockProperty<BlockFace> STAIRS_DIRECTION = new ArrayBlockProperty("weirdo_direction", false, (Serializable[])new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH}).ordinal(true);
    public static final BlockProperties PROPERTIES = new BlockProperties(STAIRS_DIRECTION, UPSIDE_DOWN);

    protected BlockStairs(int meta) {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getMinY() {
        return this.y + (this.isUpsideDown() ? 0.5 : 0.0);
    }

    @Override
    public double getMaxY() {
        return this.y + (this.isUpsideDown() ? 1.0 : 0.5);
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return side == BlockFace.UP && this.isUpsideDown() || side == BlockFace.DOWN && !this.isUpsideDown();
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (player != null) {
            this.setBlockFace(player.getDirection());
        }
        if (fy > 0.5 && face != BlockFace.UP || face == BlockFace.DOWN) {
            this.setUpsideDown(true);
        }
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public boolean collidesWithBB(AxisAlignedBB bb) {
        BlockFace face = this.getBlockFace();
        double minSlabY = 0.0;
        double maxSlabY = 0.5;
        double minHalfSlabY = 0.5;
        double maxHalfSlabY = 1.0;
        if (this.isUpsideDown()) {
            minSlabY = 0.5;
            maxSlabY = 1.0;
            minHalfSlabY = 0.0;
            maxHalfSlabY = 0.5;
        }
        if (bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + minSlabY, this.z, this.x + 1.0, this.y + maxSlabY, this.z + 1.0))) {
            return true;
        }
        switch (face) {
            case EAST: {
                return bb.intersectsWith(new SimpleAxisAlignedBB(this.x + 0.5, this.y + minHalfSlabY, this.z, this.x + 1.0, this.y + maxHalfSlabY, this.z + 1.0));
            }
            case WEST: {
                return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + minHalfSlabY, this.z, this.x + 0.5, this.y + maxHalfSlabY, this.z + 1.0));
            }
            case SOUTH: {
                return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + minHalfSlabY, this.z + 0.5, this.x + 1.0, this.y + maxHalfSlabY, this.z + 1.0));
            }
            case NORTH: {
                return bb.intersectsWith(new SimpleAxisAlignedBB(this.x, this.y + minHalfSlabY, this.z, this.x + 1.0, this.y + maxHalfSlabY, this.z + 0.5));
            }
        }
        return false;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    public void setUpsideDown(boolean upsideDown) {
        this.setBooleanValue(UPSIDE_DOWN, upsideDown);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isUpsideDown() {
        return this.getBooleanValue(UPSIDE_DOWN);
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getPropertyValue(STAIRS_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(STAIRS_DIRECTION, face);
    }
}

