/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSolid;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitRandom;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockTNT
extends BlockSolid {
    @Override
    public String getName() {
        return "TNT";
    }

    @Override
    public int getId() {
        return 46;
    }

    @Override
    public double getHardness() {
        return 0.0;
    }

    @Override
    public double getResistance() {
        return 0.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getBurnChance() {
        return 15;
    }

    @Override
    public int getBurnAbility() {
        return 100;
    }

    public void prime() {
        this.prime(80);
    }

    public void prime(int fuse) {
        this.prime(fuse, null);
    }

    public void prime(int fuse, Entity source) {
        this.getLevel().setBlock((Vector3)this, Block.get(0), true);
        double mot = (double)new NukkitRandom().nextSignedFloat() * Math.PI * 2.0;
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", this.x + 0.5)).add(new DoubleTag("", this.y)).add(new DoubleTag("", this.z + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", -Math.sin(mot) * 0.02)).add(new DoubleTag("", 0.2)).add(new DoubleTag("", -Math.cos(mot) * 0.02))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f))).putShort("Fuse", fuse);
        Entity tnt = Entity.createEntity("PrimedTnt", (FullChunk)this.getLevel().getChunk(this.getFloorX() >> 4, this.getFloorZ() >> 4), nbt, source);
        if (tnt == null) {
            return;
        }
        tnt.spawnToAll();
        this.getLevel().addLevelEvent(this, 1005);
    }

    @Override
    public int onUpdate(int type) {
        if (!this.level.getServer().isRedstoneEnabled()) {
            return 0;
        }
        if ((type == 1 || type == 6) && this.level.isBlockPowered(this.getLocation())) {
            this.prime();
        }
        return 0;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (item.getId() == 259) {
            item.useOn(this);
            this.prime(80, player);
            return true;
        }
        if (item.getId() == 385) {
            if (!player.isCreative()) {
                player.getInventory().removeItem(Item.get(385, 0, 1));
            }
            this.prime(80, player);
            return true;
        }
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean onProjectileHit(@Nonnull Entity projectile, @Nonnull Position position, @Nonnull Vector3 motion) {
        if (projectile.isOnFire() && projectile instanceof EntityArrow) {
            this.prime(80, projectile);
            return true;
        }
        return false;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.TNT_BLOCK_COLOR;
    }
}

