/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntityTarget;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.level.Level;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockTarget
extends BlockTransparent
implements BlockEntityHolder<BlockEntityTarget> {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockTarget() {
    }

    @Override
    public int getId() {
        return 494;
    }

    @Override
    public String getName() {
        return "Target";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityTarget> getBlockEntityClass() {
        return BlockEntityTarget.class;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public String getBlockEntityType() {
        return "Target";
    }

    @Override
    public boolean isPowerSource() {
        return true;
    }

    @Override
    public int getWeakPower(BlockFace face) {
        BlockEntityTarget target = (BlockEntityTarget)this.getBlockEntity();
        return target == null ? 0 : target.getActivePower();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean activatePower(int power) {
        return this.activatePower(power, 8);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean activatePower(int power, int ticks) {
        Level level = this.getLevel();
        if (power <= 0 || ticks <= 0) {
            return this.deactivatePower();
        }
        if (!level.getServer().isRedstoneEnabled()) {
            return false;
        }
        BlockEntityTarget target = (BlockEntityTarget)this.getOrCreateBlockEntity();
        int previous = target.getActivePower();
        level.cancelSheduledUpdate(this, this);
        level.scheduleUpdate(this, ticks);
        target.setActivePower(power);
        if (previous != power) {
            level.updateAroundRedstone(this, null);
        }
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean deactivatePower() {
        BlockEntityTarget target = (BlockEntityTarget)this.getBlockEntity();
        if (target != null) {
            int currentPower = target.getActivePower();
            target.setActivePower(0);
            target.close();
            if (currentPower != 0 && this.level.getServer().isRedstoneEnabled()) {
                this.level.updateAroundRedstone(this, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public int onUpdate(int type) {
        if (type == 3) {
            this.deactivatePower();
            return type;
        }
        return 0;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean onProjectileHit(@Nonnull Entity projectile, @Nonnull Position position, @Nonnull Vector3 motion) {
        MovingObjectPosition intercept;
        int ticks = 8;
        if (projectile instanceof EntityArrow || projectile instanceof EntityThrownTrident) {
            ticks = 20;
        }
        if ((intercept = this.calculateIntercept(position, position.add(motion.multiply(2.0)))) == null) {
            return false;
        }
        BlockFace faceHit = intercept.getFaceHit();
        if (faceHit == null) {
            return false;
        }
        Vector3 hitVector = intercept.hitVector.subtract(this.x * 2.0, this.y * 2.0, this.z * 2.0);
        ArrayList<BlockFace.Axis> axes = new ArrayList<BlockFace.Axis>(Arrays.asList(BlockFace.Axis.values()));
        axes.remove(faceHit.getAxis());
        double[] coords = new double[]{hitVector.getAxis((BlockFace.Axis)axes.get(0)), hitVector.getAxis((BlockFace.Axis)axes.get(1))};
        for (int i = 0; i < 2; ++i) {
            if (coords[i] == 0.5) {
                coords[i] = 1.0;
                continue;
            }
            if (coords[i] <= 0.0 || coords[i] >= 1.0) {
                coords[i] = 0.0;
                continue;
            }
            if (coords[i] < 0.5) {
                int n = i;
                coords[n] = coords[n] * 2.0;
                continue;
            }
            coords[i] = coords[i] / -0.5 + 2.0;
        }
        double scale = (coords[0] + coords[1]) / 2.0;
        this.activatePower(NukkitMath.ceilDouble(16.0 * scale), ticks);
        return true;
    }

    @Override
    public int getToolType() {
        return 6;
    }

    @Override
    public double getHardness() {
        return 0.5;
    }

    @Override
    public double getResistance() {
        return 0.5;
    }

    @Override
    public int getBurnAbility() {
        return 15;
    }

    @Override
    public int getBurnChance() {
        return 0;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.QUARTZ_BLOCK_COLOR;
    }
}

