/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLever;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockTorch
extends BlockFlowable
implements Faceable {
    public static final BlockProperty<TorchAttachment> TORCH_FACING_DIRECTION = new ArrayBlockProperty<TorchAttachment>("torch_facing_direction", false, TorchAttachment.class);
    public static final BlockProperties PROPERTIES = new BlockProperties(TORCH_FACING_DIRECTION);

    public BlockTorch() {
        this(0);
    }

    public BlockTorch(int meta) {
        super(meta);
    }

    @Override
    public String getName() {
        return "Torch";
    }

    @Override
    public int getId() {
        return 50;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public int getLightLevel() {
        return 14;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed the block update logic to follow the same behaviour has vanilla")
    public int onUpdate(int type) {
        TorchAttachment torchAttachment;
        Block support;
        if (type == 1 && !BlockLever.isSupportValid(support = this.getSide((torchAttachment = this.getTorchAttachment()).getAttachedFace()), torchAttachment.getTorchDirection())) {
            this.getLevel().useBreakOn(this);
            return 1;
        }
        return 0;
    }

    @Nullable
    private BlockFace findValidSupport() {
        for (BlockFace horizontalFace : BlockFace.Plane.HORIZONTAL) {
            if (!BlockLever.isSupportValid(this.getSide(horizontalFace.getOpposite()), horizontalFace)) continue;
            return horizontalFace;
        }
        if (BlockLever.isSupportValid(this.down(), BlockFace.UP)) {
            return BlockFace.UP;
        }
        return null;
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed the logic to follow the same behaviour has vanilla")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, Player player) {
        if (target.canBeReplaced()) {
            target = target.down();
            face = BlockFace.UP;
        }
        if (face == BlockFace.DOWN || !BlockLever.isSupportValid(target, face)) {
            BlockFace valid = this.findValidSupport();
            if (valid == null) {
                return false;
            }
            face = valid;
        }
        this.setBlockFace(face);
        this.getLevel().setBlock((Vector3)block, this, true, true);
        return true;
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.AIR_BLOCK_COLOR;
    }

    @Override
    public BlockFace getBlockFace() {
        return this.getTorchAttachment().getTorchDirection();
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        TorchAttachment torchAttachment = TorchAttachment.getByTorchDirection(face);
        if (torchAttachment == null) {
            throw new InvalidBlockPropertyValueException(TORCH_FACING_DIRECTION, (Serializable)((Object)this.getTorchAttachment()), (Serializable)((Object)face), "The give BlockFace can't be mapped to TorchFace");
        }
        this.setTorchAttachment(torchAttachment);
    }

    @Deprecated
    @DeprecationDetails(reason="Using magic value", replaceWith="getBlockFace()", since="1.4.0.0-PN")
    public BlockFace getBlockFace(int meta) {
        return TORCH_FACING_DIRECTION.getValueForMeta(meta).getTorchDirection();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public TorchAttachment getTorchAttachment() {
        return this.getPropertyValue(TORCH_FACING_DIRECTION);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTorchAttachment(TorchAttachment face) {
        this.setPropertyValue(TORCH_FACING_DIRECTION, face);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static enum TorchAttachment {
        UNKNOWN,
        WEST,
        EAST,
        NORTH,
        SOUTH,
        TOP;


        public BlockFace getTorchDirection() {
            switch (this) {
                default: {
                    return BlockFace.UP;
                }
                case EAST: {
                    return BlockFace.WEST;
                }
                case WEST: {
                    return BlockFace.EAST;
                }
                case SOUTH: {
                    return BlockFace.NORTH;
                }
                case NORTH: 
            }
            return BlockFace.SOUTH;
        }

        @Nullable
        public static TorchAttachment getByTorchDirection(@Nonnull BlockFace face) {
            switch (face) {
                default: {
                    return null;
                }
                case UP: {
                    return TOP;
                }
                case EAST: {
                    return WEST;
                }
                case WEST: {
                    return EAST;
                }
                case SOUTH: {
                    return NORTH;
                }
                case NORTH: 
            }
            return SOUTH;
        }

        @Nonnull
        public BlockFace getAttachedFace() {
            switch (this) {
                default: {
                    return BlockFace.DOWN;
                }
                case EAST: {
                    return BlockFace.EAST;
                }
                case WEST: {
                    return BlockFace.WEST;
                }
                case SOUTH: {
                    return BlockFace.SOUTH;
                }
                case NORTH: 
            }
            return BlockFace.NORTH;
        }

        @Nullable
        public static TorchAttachment getByAttachedFace(@Nonnull BlockFace face) {
            switch (face) {
                default: {
                    return null;
                }
                case DOWN: {
                    return TOP;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case NORTH: {
                    return NORTH;
                }
                case EAST: {
                    return EAST;
                }
                case WEST: 
            }
            return WEST;
        }
    }
}

