/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockStairs;
import cn.nukkit.block.BlockTransparentMeta;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.event.block.BlockRedstoneEvent;
import cn.nukkit.event.block.DoorToggleEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Sound;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.Faceable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockTrapdoor
extends BlockTransparentMeta
implements Faceable {
    private static final double THICKNESS = 0.1875;
    public static final BlockProperty<BlockFace> TRAPDOOR_DIRECTION = new ArrayBlockProperty("direction", false, (Serializable[])new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH}).ordinal(true);
    public static final BlockProperties PROPERTIES = new BlockProperties(TRAPDOOR_DIRECTION, BlockStairs.UPSIDE_DOWN, CommonBlockProperties.OPEN);
    private static final AxisAlignedBB[] boundingBoxDamage = new AxisAlignedBB[1 << PROPERTIES.getBitSize()];
    @Deprecated
    @DeprecationDetails(reason="Use the properties or the accessors", since="1.4.0.0-PN", replaceWith="CommonBlockProperties.OPEN")
    public static final int TRAPDOOR_OPEN_BIT = 8;
    @Deprecated
    @DeprecationDetails(reason="Use the properties or the accessors", since="1.4.0.0-PN", replaceWith="BlockStairs.UPSIDE_DOWN")
    public static final int TRAPDOOR_TOP_BIT = 4;

    public BlockTrapdoor() {
        this(0);
    }

    public BlockTrapdoor(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 96;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return "Oak Trapdoor";
    }

    @Override
    public double getHardness() {
        return 3.0;
    }

    @Override
    public double getResistance() {
        return 15.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 4;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @PowerNukkitDifference(info="The bounding box was fixed", since="1.3.0.0-PN")
    private AxisAlignedBB getRelativeBoundingBox() {
        int bigDamage = this.getSignedBigDamage();
        return boundingBoxDamage[bigDamage];
    }

    @Override
    public double getMinX() {
        return this.x + this.getRelativeBoundingBox().getMinX();
    }

    @Override
    public double getMaxX() {
        return this.x + this.getRelativeBoundingBox().getMaxX();
    }

    @Override
    public double getMinY() {
        return this.y + this.getRelativeBoundingBox().getMinY();
    }

    @Override
    public double getMaxY() {
        return this.y + this.getRelativeBoundingBox().getMaxY();
    }

    @Override
    public double getMinZ() {
        return this.z + this.getRelativeBoundingBox().getMinZ();
    }

    @Override
    public double getMaxZ() {
        return this.z + this.getRelativeBoundingBox().getMaxZ();
    }

    @Override
    public int onUpdate(int type) {
        if (type == 6 && this.level.getServer().isRedstoneEnabled() && this.isOpen() != this.level.isBlockPowered(this.getLocation())) {
            this.level.getServer().getPluginManager().callEvent(new BlockRedstoneEvent(this, this.isOpen() ? 15 : 0, this.isOpen() ? 0 : 15));
            this.toggleBooleanProperty(CommonBlockProperties.OPEN);
            this.level.setBlock((Vector3)this, this, true);
            this.playOpenCloseSound();
            return type;
        }
        return 0;
    }

    @Override
    @PowerNukkitDifference(info="Will return false if setBlock fails and the direction is relative to where the player is facing", since="1.4.0.0-PN")
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        if (face.getAxis().isHorizontal()) {
            this.setBlockFace(player == null ? face : player.getDirection().getOpposite());
            this.setTop(fy > 0.5);
        } else {
            this.setBlockFace(player.getDirection().getOpposite());
            this.setTop(face != BlockFace.UP);
        }
        return this.level.setBlock((Vector3)block, this, true, true);
    }

    @Override
    public boolean onActivate(@Nonnull Item item, Player player) {
        if (this.toggle(player)) {
            this.playOpenCloseSound();
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenCloseSound() {
        if (this.isOpen()) {
            this.playOpenSound();
        } else {
            this.playCloseSound();
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playOpenSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void playCloseSound() {
        this.level.addSound(this, Sound.RANDOM_DOOR_CLOSE);
    }

    @PowerNukkitDifference(info="Returns false if setBlock fails", since="1.4.0.0-PN")
    public boolean toggle(Player player) {
        DoorToggleEvent ev = new DoorToggleEvent(this, player);
        this.getLevel().getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        this.toggleBooleanProperty(CommonBlockProperties.OPEN);
        return this.getLevel().setBlock((Vector3)this, this, true);
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.WOOD_BLOCK_COLOR;
    }

    public boolean isOpen() {
        return this.getBooleanValue(CommonBlockProperties.OPEN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setOpen(boolean open) {
        this.setBooleanValue(CommonBlockProperties.OPEN, open);
    }

    public boolean isTop() {
        return this.getBooleanValue(BlockStairs.UPSIDE_DOWN);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTop(boolean top) {
        this.setBooleanValue(BlockStairs.UPSIDE_DOWN, top);
    }

    @Override
    @PowerNukkitDifference(info="Was returning the wrong face", since="1.3.0.0-PN")
    public BlockFace getBlockFace() {
        return this.getPropertyValue(TRAPDOOR_DIRECTION);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockFace(BlockFace face) {
        this.setPropertyValue(TRAPDOOR_DIRECTION, face);
    }

    static {
        for (int damage = 0; damage < boundingBoxDamage.length; ++damage) {
            SimpleAxisAlignedBB bb;
            if (PROPERTIES.getBooleanValue(damage, CommonBlockProperties.OPEN.getName())) {
                BlockFace face = (BlockFace)((Object)PROPERTIES.getValue(damage, TRAPDOOR_DIRECTION.getName()));
                bb = (face = face.getOpposite()).getAxisDirection() == BlockFace.AxisDirection.NEGATIVE ? new SimpleAxisAlignedBB(0.0, 0.0, 0.0, (double)(1 + face.getXOffset()) - 0.1875 * (double)face.getXOffset(), 1.0, (double)(1 + face.getZOffset()) - 0.1875 * (double)face.getZOffset()) : new SimpleAxisAlignedBB((double)face.getXOffset() - 0.1875 * (double)face.getXOffset(), 0.0, (double)face.getZOffset() - 0.1875 * (double)face.getZOffset(), 1.0, 1.0, 1.0);
            } else {
                bb = PROPERTIES.getBooleanValue(damage, BlockStairs.UPSIDE_DOWN.getName()) ? new SimpleAxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0) : new SimpleAxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
            }
            BlockTrapdoor.boundingBoxDamage[damage] = bb;
        }
    }
}

