/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockAir;
import cn.nukkit.block.BlockEntityHolder;
import cn.nukkit.block.BlockFlowable;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.block.BlockTransparent;
import cn.nukkit.blockentity.BlockEntityShulkerBox;
import cn.nukkit.inventory.ContainerInventory;
import cn.nukkit.inventory.ShulkerBoxInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BlockColor;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitDifference(since="1.4.0.0-PN", info="Implements BlockEntityHolder only in PowerNukkit")
public class BlockUndyedShulkerBox
extends BlockTransparent
implements BlockEntityHolder<BlockEntityShulkerBox> {
    @Override
    public int getId() {
        return 205;
    }

    @Override
    public String getName() {
        return "Shulker Box";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Class<? extends BlockEntityShulkerBox> getBlockEntityClass() {
        return BlockEntityShulkerBox.class;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getBlockEntityType() {
        return "ShulkerBox";
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 10.0;
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public int getToolType() {
        return 3;
    }

    @Override
    @PowerNukkitOnly
    public int getWaterloggingLevel() {
        return 1;
    }

    @Override
    public Item toItem() {
        ItemBlock item = new ItemBlock(this, (Integer)this.getDamage(), 1);
        BlockEntityShulkerBox tile = (BlockEntityShulkerBox)this.getBlockEntity();
        if (tile == null) {
            return item;
        }
        ShulkerBoxInventory inv = tile.getRealInventory();
        if (!inv.isEmpty()) {
            CompoundTag nbt = item.getNamedTag();
            if (nbt == null) {
                nbt = new CompoundTag("");
            }
            ListTag<CompoundTag> items = new ListTag<CompoundTag>();
            for (int it = 0; it < inv.getSize(); ++it) {
                if (inv.getItem(it).isNull()) continue;
                CompoundTag d = NBTIO.putItemHelper(inv.getItem(it), it);
                items.add(d);
            }
            nbt.put("Items", items);
            item.setCompoundTag(nbt);
        }
        if (tile.hasName()) {
            item.setCustomName(tile.getName());
        }
        return item;
    }

    @Override
    public boolean place(@Nonnull Item item, @Nonnull Block block, @Nonnull Block target, @Nonnull BlockFace face, double fx, double fy, double fz, @Nullable Player player) {
        CompoundTag t;
        CompoundTag nbt = new CompoundTag().putByte("facing", face.getIndex());
        if (item.hasCustomName()) {
            nbt.putString("CustomName", item.getCustomName());
        }
        if ((t = item.getNamedTag()) != null && t.contains("Items")) {
            nbt.putList(t.getList("Items"));
        }
        if (item.hasCustomBlockData()) {
            Map<String, Tag> customData = item.getCustomBlockData().getTags();
            for (Map.Entry<String, Tag> tag : customData.entrySet()) {
                nbt.put(tag.getKey(), tag.getValue());
            }
        }
        return BlockEntityHolder.setBlockAndCreateEntity(this, true, true, nbt, new Object[0]) != null;
    }

    @Override
    public boolean canHarvestWithHand() {
        return false;
    }

    @Override
    public boolean onActivate(@Nonnull Item item, @Nullable Player player) {
        if (player == null) {
            return false;
        }
        BlockEntityShulkerBox box = (BlockEntityShulkerBox)this.getOrCreateBlockEntity();
        Block block = this.getSide(BlockFace.fromIndex(box.namedTag.getByte("facing")));
        if (!(block instanceof BlockAir || block instanceof BlockLiquid || block instanceof BlockFlowable)) {
            return false;
        }
        player.addWindow(box.getInventory());
        return true;
    }

    @Override
    public boolean hasComparatorInputOverride() {
        return true;
    }

    @Override
    public int getComparatorInputOverride() {
        BlockEntityShulkerBox be = (BlockEntityShulkerBox)this.getBlockEntity();
        if (be == null) {
            return 0;
        }
        return ContainerInventory.calculateRedstone(be.getInventory());
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.PURPLE_BLOCK_COLOR;
    }

    @Override
    public boolean breaksWhenMoved() {
        return true;
    }

    @Override
    public boolean sticksToPiston() {
        return false;
    }

    @Override
    @Since(value="1.3.0.0-PN")
    @PowerNukkitOnly
    public boolean isSolid(BlockFace side) {
        return false;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getItemMaxStackSize() {
        return 1;
    }
}

