/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockVinesNether;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockVinesTwisting
extends BlockVinesNether {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty TWISTING_VINES_AGE = new IntBlockProperty("twisting_vines_age", false, 25);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(TWISTING_VINES_AGE);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVinesTwisting() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVinesTwisting(int meta) throws InvalidBlockPropertyMetaException {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public int getId() {
        return 542;
    }

    @Override
    public String getName() {
        return "Twisting Vines";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockFace getGrowthDirection() {
        return BlockFace.UP;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getVineAge() {
        return this.getIntValue(TWISTING_VINES_AGE);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setVineAge(int vineAge) throws InvalidBlockPropertyValueException {
        this.setIntValue(TWISTING_VINES_AGE, vineAge);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getMaxVineAge() {
        return TWISTING_VINES_AGE.getMaxValue();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.CYAN_BLOCK_COLOR;
    }
}

