/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockVinesNether;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.IntBlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.math.BlockFace;
import cn.nukkit.utils.BlockColor;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockVinesWeeping
extends BlockVinesNether {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final IntBlockProperty WEEPING_VINES_AGE = new IntBlockProperty("weeping_vines_age", false, 25);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockProperties PROPERTIES = new BlockProperties(WEEPING_VINES_AGE);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVinesWeeping() {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockVinesWeeping(int meta) throws InvalidBlockPropertyMetaException {
        super(meta);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public int getId() {
        return 486;
    }

    @Override
    public String getName() {
        return "Weeping Vines";
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockFace getGrowthDirection() {
        return BlockFace.DOWN;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getVineAge() {
        return this.getIntValue(WEEPING_VINES_AGE);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setVineAge(int vineAge) {
        this.setIntValue(WEEPING_VINES_AGE, vineAge);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getMaxVineAge() {
        return WEEPING_VINES_AGE.getMaxValue();
    }

    @Override
    public BlockColor getColor() {
        return BlockColor.NETHERRACK_BLOCK_COLOR;
    }
}

