/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockLog;
import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class BlockWood
extends BlockLog {
    public static final BlockProperty<WoodType> OLD_LOG_TYPE = new ArrayBlockProperty("old_log_type", true, (Serializable[])new WoodType[]{WoodType.OAK, WoodType.SPRUCE, WoodType.BIRCH, WoodType.JUNGLE});
    public static final BlockProperties PROPERTIES = new BlockProperties(OLD_LOG_TYPE, CommonBlockProperties.PILLAR_AXIS);
    public static final int OAK = 0;
    public static final int SPRUCE = 1;
    public static final int BIRCH = 2;
    public static final int JUNGLE = 3;

    public BlockWood() {
        this(0);
    }

    public BlockWood(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public double getHardness() {
        return 2.0;
    }

    @Override
    public double getResistance() {
        return 2.0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public WoodType getWoodType() {
        return this.getPropertyValue(OLD_LOG_TYPE);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setWoodType(WoodType woodType) {
        this.setPropertyValue(OLD_LOG_TYPE, woodType);
    }

    @Override
    public String getName() {
        return this.getWoodType().getEnglishName() + " Wood";
    }

    @Override
    public int getBurnChance() {
        return 5;
    }

    @Override
    public int getBurnAbility() {
        return 10;
    }

    @Override
    protected BlockState getStrippedState() {
        int strippedId;
        switch (this.getWoodType()) {
            default: {
                strippedId = 265;
                break;
            }
            case SPRUCE: {
                strippedId = 260;
                break;
            }
            case BIRCH: {
                strippedId = 261;
                break;
            }
            case JUNGLE: {
                strippedId = 262;
                break;
            }
            case ACACIA: {
                strippedId = 263;
                break;
            }
            case DARK_OAK: {
                strippedId = 264;
            }
        }
        return BlockState.of(strippedId).withProperty(CommonBlockProperties.PILLAR_AXIS, this.getPillarAxis());
    }

    @Override
    public BlockColor getColor() {
        return this.getWoodType().getColor();
    }
}

